package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterResource invokes the foas.GetClusterResource API synchronously
func (client *Client) GetClusterResource(request *GetClusterResourceRequest) (response *GetClusterResourceResponse, err error) {
	response = CreateGetClusterResourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterResourceWithChan invokes the foas.GetClusterResource API asynchronously
func (client *Client) GetClusterResourceWithChan(request *GetClusterResourceRequest) (<-chan *GetClusterResourceResponse, <-chan error) {
	responseChan := make(chan *GetClusterResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterResourceWithCallback invokes the foas.GetClusterResource API asynchronously
func (client *Client) GetClusterResourceWithCallback(request *GetClusterResourceRequest, callback func(response *GetClusterResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterResourceResponse
		var err error
		defer close(result)
		response, err = client.GetClusterResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterResourceRequest is the request struct for api GetClusterResource
type GetClusterResourceRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"clusterId"`
}

// GetClusterResourceResponse is the response struct for api GetClusterResource
type GetClusterResourceResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Resource  Resource `json:"Resource" xml:"Resource"`
}

// CreateGetClusterResourceRequest creates a request to invoke GetClusterResource API
func CreateGetClusterResourceRequest() (request *GetClusterResourceRequest) {
	request = &GetClusterResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetClusterResource", "/api/v2/clusters/[clusterId]/resource", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetClusterResourceResponse creates a response to parse from GetClusterResource response
func CreateGetClusterResourceResponse() (response *GetClusterResourceResponse) {
	response = &GetClusterResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
