package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApiDestination invokes the eventbridge.DeleteApiDestination API synchronously
func (client *Client) DeleteApiDestination(request *DeleteApiDestinationRequest) (response *DeleteApiDestinationResponse, err error) {
	response = CreateDeleteApiDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApiDestinationWithChan invokes the eventbridge.DeleteApiDestination API asynchronously
func (client *Client) DeleteApiDestinationWithChan(request *DeleteApiDestinationRequest) (<-chan *DeleteApiDestinationResponse, <-chan error) {
	responseChan := make(chan *DeleteApiDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApiDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApiDestinationWithCallback invokes the eventbridge.DeleteApiDestination API asynchronously
func (client *Client) DeleteApiDestinationWithCallback(request *DeleteApiDestinationRequest, callback func(response *DeleteApiDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApiDestinationResponse
		var err error
		defer close(result)
		response, err = client.DeleteApiDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApiDestinationRequest is the request struct for api DeleteApiDestination
type DeleteApiDestinationRequest struct {
	*requests.RpcRequest
	ClientToken        string `position:"Query" name:"ClientToken"`
	ApiDestinationName string `position:"Query" name:"ApiDestinationName"`
}

// DeleteApiDestinationResponse is the response struct for api DeleteApiDestination
type DeleteApiDestinationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateDeleteApiDestinationRequest creates a request to invoke DeleteApiDestination API
func CreateDeleteApiDestinationRequest() (request *DeleteApiDestinationRequest) {
	request = &DeleteApiDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DeleteApiDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteApiDestinationResponse creates a response to parse from DeleteApiDestination response
func CreateDeleteApiDestinationResponse() (response *DeleteApiDestinationResponse) {
	response = &DeleteApiDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
