package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosticReports invokes the ecs.DescribeDiagnosticReports API synchronously
func (client *Client) DescribeDiagnosticReports(request *DescribeDiagnosticReportsRequest) (response *DescribeDiagnosticReportsResponse, err error) {
	response = CreateDescribeDiagnosticReportsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosticReportsWithChan invokes the ecs.DescribeDiagnosticReports API asynchronously
func (client *Client) DescribeDiagnosticReportsWithChan(request *DescribeDiagnosticReportsRequest) (<-chan *DescribeDiagnosticReportsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosticReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosticReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosticReportsWithCallback invokes the ecs.DescribeDiagnosticReports API asynchronously
func (client *Client) DescribeDiagnosticReportsWithCallback(request *DescribeDiagnosticReportsRequest, callback func(response *DescribeDiagnosticReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosticReportsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosticReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosticReportsRequest is the request struct for api DescribeDiagnosticReports
type DescribeDiagnosticReportsRequest struct {
	*requests.RpcRequest
	NextToken   string           `position:"Query" name:"NextToken"`
	Severity    string           `position:"Query" name:"Severity"`
	ReportIds   *[]string        `position:"Query" name:"ReportIds"  type:"Repeated"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
	Status      string           `position:"Query" name:"Status"`
	ResourceIds *[]string        `position:"Query" name:"ResourceIds"  type:"Repeated"`
}

// DescribeDiagnosticReportsResponse is the response struct for api DescribeDiagnosticReports
type DescribeDiagnosticReportsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	NextToken string  `json:"NextToken" xml:"NextToken"`
	Reports   Reports `json:"Reports" xml:"Reports"`
}

// CreateDescribeDiagnosticReportsRequest creates a request to invoke DescribeDiagnosticReports API
func CreateDescribeDiagnosticReportsRequest() (request *DescribeDiagnosticReportsRequest) {
	request = &DescribeDiagnosticReportsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeDiagnosticReports", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosticReportsResponse creates a response to parse from DescribeDiagnosticReports response
func CreateDescribeDiagnosticReportsResponse() (response *DescribeDiagnosticReportsResponse) {
	response = &DescribeDiagnosticReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
