package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCdsFileShareLink invokes the ecd.ModifyCdsFileShareLink API synchronously
func (client *Client) ModifyCdsFileShareLink(request *ModifyCdsFileShareLinkRequest) (response *ModifyCdsFileShareLinkResponse, err error) {
	response = CreateModifyCdsFileShareLinkResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCdsFileShareLinkWithChan invokes the ecd.ModifyCdsFileShareLink API asynchronously
func (client *Client) ModifyCdsFileShareLinkWithChan(request *ModifyCdsFileShareLinkRequest) (<-chan *ModifyCdsFileShareLinkResponse, <-chan error) {
	responseChan := make(chan *ModifyCdsFileShareLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCdsFileShareLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCdsFileShareLinkWithCallback invokes the ecd.ModifyCdsFileShareLink API asynchronously
func (client *Client) ModifyCdsFileShareLinkWithCallback(request *ModifyCdsFileShareLinkRequest, callback func(response *ModifyCdsFileShareLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCdsFileShareLinkResponse
		var err error
		defer close(result)
		response, err = client.ModifyCdsFileShareLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCdsFileShareLinkRequest is the request struct for api ModifyCdsFileShareLink
type ModifyCdsFileShareLinkRequest struct {
	*requests.RpcRequest
	Description       string           `position:"Query" name:"Description"`
	ShareId           string           `position:"Query" name:"ShareId"`
	PreviewLimit      requests.Integer `position:"Query" name:"PreviewLimit"`
	DisableDownload   requests.Boolean `position:"Query" name:"DisableDownload"`
	DisablePreview    requests.Boolean `position:"Query" name:"DisablePreview"`
	SharePwd          string           `position:"Query" name:"SharePwd"`
	ShareName         string           `position:"Query" name:"ShareName"`
	DownloadCount     requests.Integer `position:"Query" name:"DownloadCount"`
	DisableSave       requests.Boolean `position:"Query" name:"DisableSave"`
	SaveCount         requests.Integer `position:"Query" name:"SaveCount"`
	ReportCount       requests.Integer `position:"Query" name:"ReportCount"`
	VideoPreviewCount requests.Integer `position:"Query" name:"VideoPreviewCount"`
	DownloadLimit     requests.Integer `position:"Query" name:"DownloadLimit"`
	CdsId             string           `position:"Query" name:"CdsId"`
	SaveLimit         requests.Integer `position:"Query" name:"SaveLimit"`
	Expiration        string           `position:"Query" name:"Expiration"`
	PreviewCount      requests.Integer `position:"Query" name:"PreviewCount"`
	Status            string           `position:"Query" name:"Status"`
}

// ModifyCdsFileShareLinkResponse is the response struct for api ModifyCdsFileShareLink
type ModifyCdsFileShareLinkResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyCdsFileShareLinkRequest creates a request to invoke ModifyCdsFileShareLink API
func CreateModifyCdsFileShareLinkRequest() (request *ModifyCdsFileShareLinkRequest) {
	request = &ModifyCdsFileShareLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyCdsFileShareLink", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCdsFileShareLinkResponse creates a response to parse from ModifyCdsFileShareLink response
func CreateModifyCdsFileShareLinkResponse() (response *ModifyCdsFileShareLinkResponse) {
	response = &ModifyCdsFileShareLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
