package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudDriveUsers invokes the ecd.DescribeCloudDriveUsers API synchronously
func (client *Client) DescribeCloudDriveUsers(request *DescribeCloudDriveUsersRequest) (response *DescribeCloudDriveUsersResponse, err error) {
	response = CreateDescribeCloudDriveUsersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudDriveUsersWithChan invokes the ecd.DescribeCloudDriveUsers API asynchronously
func (client *Client) DescribeCloudDriveUsersWithChan(request *DescribeCloudDriveUsersRequest) (<-chan *DescribeCloudDriveUsersResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudDriveUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudDriveUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudDriveUsersWithCallback invokes the ecd.DescribeCloudDriveUsers API asynchronously
func (client *Client) DescribeCloudDriveUsersWithCallback(request *DescribeCloudDriveUsersRequest, callback func(response *DescribeCloudDriveUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudDriveUsersResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudDriveUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudDriveUsersRequest is the request struct for api DescribeCloudDriveUsers
type DescribeCloudDriveUsersRequest struct {
	*requests.RpcRequest
	CdsId      string           `position:"Query" name:"CdsId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	EndUserId  string           `position:"Query" name:"EndUserId"`
}

// DescribeCloudDriveUsersResponse is the response struct for api DescribeCloudDriveUsers
type DescribeCloudDriveUsersResponse struct {
	*responses.BaseResponse
	NextToken       string           `json:"NextToken" xml:"NextToken"`
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	CloudDriveUsers []CloudDriveUser `json:"CloudDriveUsers" xml:"CloudDriveUsers"`
}

// CreateDescribeCloudDriveUsersRequest creates a request to invoke DescribeCloudDriveUsers API
func CreateDescribeCloudDriveUsersRequest() (request *DescribeCloudDriveUsersRequest) {
	request = &DescribeCloudDriveUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeCloudDriveUsers", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudDriveUsersResponse creates a response to parse from DescribeCloudDriveUsers response
func CreateDescribeCloudDriveUsersResponse() (response *DescribeCloudDriveUsersResponse) {
	response = &DescribeCloudDriveUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
