package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsParams invokes the drds.DescribeDrdsParams API synchronously
func (client *Client) DescribeDrdsParams(request *DescribeDrdsParamsRequest) (response *DescribeDrdsParamsResponse, err error) {
	response = CreateDescribeDrdsParamsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsParamsWithChan invokes the drds.DescribeDrdsParams API asynchronously
func (client *Client) DescribeDrdsParamsWithChan(request *DescribeDrdsParamsRequest) (<-chan *DescribeDrdsParamsResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsParamsWithCallback invokes the drds.DescribeDrdsParams API asynchronously
func (client *Client) DescribeDrdsParamsWithCallback(request *DescribeDrdsParamsRequest, callback func(response *DescribeDrdsParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsParamsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsParamsRequest is the request struct for api DescribeDrdsParams
type DescribeDrdsParamsRequest struct {
	*requests.RpcRequest
	ParamLevel     string `position:"Query" name:"ParamLevel"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// DescribeDrdsParamsResponse is the response struct for api DescribeDrdsParams
type DescribeDrdsParamsResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	List      []ListItem `json:"List" xml:"List"`
}

// CreateDescribeDrdsParamsRequest creates a request to invoke DescribeDrdsParams API
func CreateDescribeDrdsParamsRequest() (request *DescribeDrdsParamsRequest) {
	request = &DescribeDrdsParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsParams", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsParamsResponse creates a response to parse from DescribeDrdsParams response
func CreateDescribeDrdsParamsResponse() (response *DescribeDrdsParamsResponse) {
	response = &DescribeDrdsParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
