package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTagByParam invokes the dm.QueryTagByParam API synchronously
// api document: https://help.aliyun.com/api/dm/querytagbyparam.html
func (client *Client) QueryTagByParam(request *QueryTagByParamRequest) (response *QueryTagByParamResponse, err error) {
	response = CreateQueryTagByParamResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTagByParamWithChan invokes the dm.QueryTagByParam API asynchronously
// api document: https://help.aliyun.com/api/dm/querytagbyparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTagByParamWithChan(request *QueryTagByParamRequest) (<-chan *QueryTagByParamResponse, <-chan error) {
	responseChan := make(chan *QueryTagByParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTagByParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTagByParamWithCallback invokes the dm.QueryTagByParam API asynchronously
// api document: https://help.aliyun.com/api/dm/querytagbyparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTagByParamWithCallback(request *QueryTagByParamRequest, callback func(response *QueryTagByParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTagByParamResponse
		var err error
		defer close(result)
		response, err = client.QueryTagByParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTagByParamRequest is the request struct for api QueryTagByParam
type QueryTagByParamRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	KeyWord              string           `position:"Query" name:"KeyWord"`
}

// QueryTagByParamResponse is the response struct for api QueryTagByParam
type QueryTagByParamResponse struct {
	*responses.BaseResponse
	RequestId  string                `json:"RequestId" xml:"RequestId"`
	TotalCount int                   `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                   `json:"PageSize" xml:"PageSize"`
	Data       DataInQueryTagByParam `json:"data" xml:"data"`
}

// CreateQueryTagByParamRequest creates a request to invoke QueryTagByParam API
func CreateQueryTagByParamRequest() (request *QueryTagByParamRequest) {
	request = &QueryTagByParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "QueryTagByParam", "", "")
	return
}

// CreateQueryTagByParamResponse creates a response to parse from QueryTagByParam response
func CreateQueryTagByParamResponse() (response *QueryTagByParamResponse) {
	response = &QueryTagByParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
