package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUdpReflect invokes the ddoscoo.DescribeUdpReflect API synchronously
func (client *Client) DescribeUdpReflect(request *DescribeUdpReflectRequest) (response *DescribeUdpReflectResponse, err error) {
	response = CreateDescribeUdpReflectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUdpReflectWithChan invokes the ddoscoo.DescribeUdpReflect API asynchronously
func (client *Client) DescribeUdpReflectWithChan(request *DescribeUdpReflectRequest) (<-chan *DescribeUdpReflectResponse, <-chan error) {
	responseChan := make(chan *DescribeUdpReflectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUdpReflect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUdpReflectWithCallback invokes the ddoscoo.DescribeUdpReflect API asynchronously
func (client *Client) DescribeUdpReflectWithCallback(request *DescribeUdpReflectRequest, callback func(response *DescribeUdpReflectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUdpReflectResponse
		var err error
		defer close(result)
		response, err = client.DescribeUdpReflect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUdpReflectRequest is the request struct for api DescribeUdpReflect
type DescribeUdpReflectRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// DescribeUdpReflectResponse is the response struct for api DescribeUdpReflect
type DescribeUdpReflectResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	UdpSports []string `json:"UdpSports" xml:"UdpSports"`
}

// CreateDescribeUdpReflectRequest creates a request to invoke DescribeUdpReflect API
func CreateDescribeUdpReflectRequest() (request *DescribeUdpReflectRequest) {
	request = &DescribeUdpReflectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeUdpReflect", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUdpReflectResponse creates a response to parse from DescribeUdpReflect response
func CreateDescribeUdpReflectResponse() (response *DescribeUdpReflectResponse) {
	response = &DescribeUdpReflectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
