package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePort invokes the ddoscoo.DescribePort API synchronously
func (client *Client) DescribePort(request *DescribePortRequest) (response *DescribePortResponse, err error) {
	response = CreateDescribePortResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePortWithChan invokes the ddoscoo.DescribePort API asynchronously
func (client *Client) DescribePortWithChan(request *DescribePortRequest) (<-chan *DescribePortResponse, <-chan error) {
	responseChan := make(chan *DescribePortResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePort(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePortWithCallback invokes the ddoscoo.DescribePort API asynchronously
func (client *Client) DescribePortWithCallback(request *DescribePortRequest, callback func(response *DescribePortResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePortResponse
		var err error
		defer close(result)
		response, err = client.DescribePort(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePortRequest is the request struct for api DescribePort
type DescribePortRequest struct {
	*requests.RpcRequest
	IsOffset         requests.Boolean `position:"Query" name:"IsOffset"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	FrontendProtocol string           `position:"Query" name:"FrontendProtocol"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	FrontendPort     requests.Integer `position:"Query" name:"FrontendPort"`
}

// DescribePortResponse is the response struct for api DescribePort
type DescribePortResponse struct {
	*responses.BaseResponse
	TotalCount   int64         `json:"TotalCount" xml:"TotalCount"`
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	NetworkRules []NetworkRule `json:"NetworkRules" xml:"NetworkRules"`
}

// CreateDescribePortRequest creates a request to invoke DescribePort API
func CreateDescribePortRequest() (request *DescribePortRequest) {
	request = &DescribePortRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribePort", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePortResponse creates a response to parse from DescribePort response
func CreateDescribePortResponse() (response *DescribePortResponse) {
	response = &DescribePortResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
