package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDIJobs invokes the dataworks_public.ListDIJobs API synchronously
func (client *Client) ListDIJobs(request *ListDIJobsRequest) (response *ListDIJobsResponse, err error) {
	response = CreateListDIJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDIJobsWithChan invokes the dataworks_public.ListDIJobs API asynchronously
func (client *Client) ListDIJobsWithChan(request *ListDIJobsRequest) (<-chan *ListDIJobsResponse, <-chan error) {
	responseChan := make(chan *ListDIJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDIJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDIJobsWithCallback invokes the dataworks_public.ListDIJobs API asynchronously
func (client *Client) ListDIJobsWithCallback(request *ListDIJobsRequest, callback func(response *ListDIJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDIJobsResponse
		var err error
		defer close(result)
		response, err = client.ListDIJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDIJobsRequest is the request struct for api ListDIJobs
type ListDIJobsRequest struct {
	*requests.RpcRequest
	SourceDataSourceType      string           `position:"Body" name:"SourceDataSourceType"`
	PageNumber                requests.Integer `position:"Body" name:"PageNumber"`
	DestinationDataSourceType string           `position:"Body" name:"DestinationDataSourceType"`
	PageSize                  requests.Integer `position:"Body" name:"PageSize"`
	ProjectId                 requests.Integer `position:"Body" name:"ProjectId"`
	JobName                   string           `position:"Body" name:"JobName"`
}

// ListDIJobsResponse is the response struct for api ListDIJobs
type ListDIJobsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	DIJobPaging DIJobPaging `json:"DIJobPaging" xml:"DIJobPaging"`
}

// CreateListDIJobsRequest creates a request to invoke ListDIJobs API
func CreateListDIJobsRequest() (request *ListDIJobsRequest) {
	request = &ListDIJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListDIJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateListDIJobsResponse creates a response to parse from ListDIJobs response
func CreateListDIJobsResponse() (response *ListDIJobsResponse) {
	response = &ListDIJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
