package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableOutput invokes the dataworks_public.GetMetaTableOutput API synchronously
func (client *Client) GetMetaTableOutput(request *GetMetaTableOutputRequest) (response *GetMetaTableOutputResponse, err error) {
	response = CreateGetMetaTableOutputResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableOutputWithChan invokes the dataworks_public.GetMetaTableOutput API asynchronously
func (client *Client) GetMetaTableOutputWithChan(request *GetMetaTableOutputRequest) (<-chan *GetMetaTableOutputResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableOutputResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableOutput(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableOutputWithCallback invokes the dataworks_public.GetMetaTableOutput API asynchronously
func (client *Client) GetMetaTableOutputWithCallback(request *GetMetaTableOutputRequest, callback func(response *GetMetaTableOutputResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableOutputResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableOutput(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableOutputRequest is the request struct for api GetMetaTableOutput
type GetMetaTableOutputRequest struct {
	*requests.RpcRequest
	StartDate  string           `position:"Query" name:"StartDate"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	EndDate    string           `position:"Query" name:"EndDate"`
	TableGuid  string           `position:"Query" name:"TableGuid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TaskId     string           `position:"Query" name:"TaskId"`
}

// GetMetaTableOutputResponse is the response struct for api GetMetaTableOutput
type GetMetaTableOutputResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	ErrorCode      string                   `json:"ErrorCode" xml:"ErrorCode"`
	Data           DataInGetMetaTableOutput `json:"Data" xml:"Data"`
}

// CreateGetMetaTableOutputRequest creates a request to invoke GetMetaTableOutput API
func CreateGetMetaTableOutputRequest() (request *GetMetaTableOutputRequest) {
	request = &GetMetaTableOutputRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableOutput", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMetaTableOutputResponse creates a response to parse from GetMetaTableOutput response
func CreateGetMetaTableOutputResponse() (response *GetMetaTableOutputResponse) {
	response = &GetMetaTableOutputResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
