package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUserDevicesStatus invokes the csas.UpdateUserDevicesStatus API synchronously
func (client *Client) UpdateUserDevicesStatus(request *UpdateUserDevicesStatusRequest) (response *UpdateUserDevicesStatusResponse, err error) {
	response = CreateUpdateUserDevicesStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUserDevicesStatusWithChan invokes the csas.UpdateUserDevicesStatus API asynchronously
func (client *Client) UpdateUserDevicesStatusWithChan(request *UpdateUserDevicesStatusRequest) (<-chan *UpdateUserDevicesStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateUserDevicesStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUserDevicesStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUserDevicesStatusWithCallback invokes the csas.UpdateUserDevicesStatus API asynchronously
func (client *Client) UpdateUserDevicesStatusWithCallback(request *UpdateUserDevicesStatusRequest, callback func(response *UpdateUserDevicesStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUserDevicesStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateUserDevicesStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUserDevicesStatusRequest is the request struct for api UpdateUserDevicesStatus
type UpdateUserDevicesStatusRequest struct {
	*requests.RpcRequest
	DeviceAction string    `position:"Body" name:"DeviceAction"`
	DeviceTags   *[]string `position:"Body" name:"DeviceTags"  type:"Repeated"`
	SourceIp     string    `position:"Query" name:"SourceIp"`
}

// UpdateUserDevicesStatusResponse is the response struct for api UpdateUserDevicesStatus
type UpdateUserDevicesStatusResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Devices   []DataInUpdateUserDevicesStatus `json:"Devices" xml:"Devices"`
}

// CreateUpdateUserDevicesStatusRequest creates a request to invoke UpdateUserDevicesStatus API
func CreateUpdateUserDevicesStatusRequest() (request *UpdateUserDevicesStatusRequest) {
	request = &UpdateUserDevicesStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateUserDevicesStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateUserDevicesStatusResponse creates a response to parse from UpdateUserDevicesStatus response
func CreateUpdateUserDevicesStatusResponse() (response *UpdateUserDevicesStatusResponse) {
	response = &UpdateUserDevicesStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
