package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePrivateAccessApplication invokes the csas.DeletePrivateAccessApplication API synchronously
func (client *Client) DeletePrivateAccessApplication(request *DeletePrivateAccessApplicationRequest) (response *DeletePrivateAccessApplicationResponse, err error) {
	response = CreateDeletePrivateAccessApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePrivateAccessApplicationWithChan invokes the csas.DeletePrivateAccessApplication API asynchronously
func (client *Client) DeletePrivateAccessApplicationWithChan(request *DeletePrivateAccessApplicationRequest) (<-chan *DeletePrivateAccessApplicationResponse, <-chan error) {
	responseChan := make(chan *DeletePrivateAccessApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePrivateAccessApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePrivateAccessApplicationWithCallback invokes the csas.DeletePrivateAccessApplication API asynchronously
func (client *Client) DeletePrivateAccessApplicationWithCallback(request *DeletePrivateAccessApplicationRequest, callback func(response *DeletePrivateAccessApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePrivateAccessApplicationResponse
		var err error
		defer close(result)
		response, err = client.DeletePrivateAccessApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePrivateAccessApplicationRequest is the request struct for api DeletePrivateAccessApplication
type DeletePrivateAccessApplicationRequest struct {
	*requests.RpcRequest
	SourceIp      string `position:"Query" name:"SourceIp"`
	ApplicationId string `position:"Body" name:"ApplicationId"`
}

// DeletePrivateAccessApplicationResponse is the response struct for api DeletePrivateAccessApplication
type DeletePrivateAccessApplicationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePrivateAccessApplicationRequest creates a request to invoke DeletePrivateAccessApplication API
func CreateDeletePrivateAccessApplicationRequest() (request *DeletePrivateAccessApplicationRequest) {
	request = &DeletePrivateAccessApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeletePrivateAccessApplication", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePrivateAccessApplicationResponse creates a response to parse from DeletePrivateAccessApplication response
func CreateDeletePrivateAccessApplicationResponse() (response *DeletePrivateAccessApplicationResponse) {
	response = &DeletePrivateAccessApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
