package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterEventConfig invokes the cloudcallcenter.RegisterEventConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/registereventconfig.html
func (client *Client) RegisterEventConfig(request *RegisterEventConfigRequest) (response *RegisterEventConfigResponse, err error) {
	response = CreateRegisterEventConfigResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterEventConfigWithChan invokes the cloudcallcenter.RegisterEventConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/registereventconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterEventConfigWithChan(request *RegisterEventConfigRequest) (<-chan *RegisterEventConfigResponse, <-chan error) {
	responseChan := make(chan *RegisterEventConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterEventConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterEventConfigWithCallback invokes the cloudcallcenter.RegisterEventConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/registereventconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RegisterEventConfigWithCallback(request *RegisterEventConfigRequest, callback func(response *RegisterEventConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterEventConfigResponse
		var err error
		defer close(result)
		response, err = client.RegisterEventConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterEventConfigRequest is the request struct for api RegisterEventConfig
type RegisterEventConfigRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	AccessPoint   string `position:"Query" name:"AccessPoint"`
	EventTypeList string `position:"Query" name:"EventTypeList"`
	Topic         string `position:"Query" name:"Topic"`
	ProducerId    string `position:"Query" name:"ProducerId"`
}

// RegisterEventConfigResponse is the response struct for api RegisterEventConfig
type RegisterEventConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRegisterEventConfigRequest creates a request to invoke RegisterEventConfig API
func CreateRegisterEventConfigRequest() (request *RegisterEventConfigRequest) {
	request = &RegisterEventConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RegisterEventConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterEventConfigResponse creates a response to parse from RegisterEventConfig response
func CreateRegisterEventConfigResponse() (response *RegisterEventConfigResponse) {
	response = &RegisterEventConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
