package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatasetList invokes the cloudapi.DescribeDatasetList API synchronously
func (client *Client) DescribeDatasetList(request *DescribeDatasetListRequest) (response *DescribeDatasetListResponse, err error) {
	response = CreateDescribeDatasetListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatasetListWithChan invokes the cloudapi.DescribeDatasetList API asynchronously
func (client *Client) DescribeDatasetListWithChan(request *DescribeDatasetListRequest) (<-chan *DescribeDatasetListResponse, <-chan error) {
	responseChan := make(chan *DescribeDatasetListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatasetList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatasetListWithCallback invokes the cloudapi.DescribeDatasetList API asynchronously
func (client *Client) DescribeDatasetListWithCallback(request *DescribeDatasetListRequest, callback func(response *DescribeDatasetListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatasetListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatasetList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatasetListRequest is the request struct for api DescribeDatasetList
type DescribeDatasetListRequest struct {
	*requests.RpcRequest
	DatasetIds    string           `position:"Query" name:"DatasetIds"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeDatasetListResponse is the response struct for api DescribeDatasetList
type DescribeDatasetListResponse struct {
	*responses.BaseResponse
	PageNumber      int           `json:"PageNumber" xml:"PageNumber"`
	RequestId       string        `json:"RequestId" xml:"RequestId"`
	PageSize        int           `json:"PageSize" xml:"PageSize"`
	TotalCount      int           `json:"TotalCount" xml:"TotalCount"`
	DatasetInfoList []DatasetInfo `json:"DatasetInfoList" xml:"DatasetInfoList"`
}

// CreateDescribeDatasetListRequest creates a request to invoke DescribeDatasetList API
func CreateDescribeDatasetListRequest() (request *DescribeDatasetListRequest) {
	request = &DescribeDatasetListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeDatasetList", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatasetListResponse creates a response to parse from DescribeDatasetList response
func CreateDescribeDatasetListResponse() (response *DescribeDatasetListResponse) {
	response = &DescribeDatasetListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
