package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackendInfo invokes the cloudapi.DescribeBackendInfo API synchronously
func (client *Client) DescribeBackendInfo(request *DescribeBackendInfoRequest) (response *DescribeBackendInfoResponse, err error) {
	response = CreateDescribeBackendInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackendInfoWithChan invokes the cloudapi.DescribeBackendInfo API asynchronously
func (client *Client) DescribeBackendInfoWithChan(request *DescribeBackendInfoRequest) (<-chan *DescribeBackendInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeBackendInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackendInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackendInfoWithCallback invokes the cloudapi.DescribeBackendInfo API asynchronously
func (client *Client) DescribeBackendInfoWithCallback(request *DescribeBackendInfoRequest, callback func(response *DescribeBackendInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackendInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackendInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackendInfoRequest is the request struct for api DescribeBackendInfo
type DescribeBackendInfoRequest struct {
	*requests.RpcRequest
	BackendId     string `position:"Query" name:"BackendId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeBackendInfoResponse is the response struct for api DescribeBackendInfo
type DescribeBackendInfoResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	BackendInfo BackendInfo `json:"BackendInfo" xml:"BackendInfo"`
}

// CreateDescribeBackendInfoRequest creates a request to invoke DescribeBackendInfo API
func CreateDescribeBackendInfoRequest() (request *DescribeBackendInfoRequest) {
	request = &DescribeBackendInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeBackendInfo", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackendInfoResponse creates a response to parse from DescribeBackendInfo response
func CreateDescribeBackendInfoResponse() (response *DescribeBackendInfoResponse) {
	response = &DescribeBackendInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
