package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAudioFile invokes the ccc.CreateAudioFile API synchronously
func (client *Client) CreateAudioFile(request *CreateAudioFileRequest) (response *CreateAudioFileResponse, err error) {
	response = CreateCreateAudioFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAudioFileWithChan invokes the ccc.CreateAudioFile API asynchronously
func (client *Client) CreateAudioFileWithChan(request *CreateAudioFileRequest) (<-chan *CreateAudioFileResponse, <-chan error) {
	responseChan := make(chan *CreateAudioFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAudioFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAudioFileWithCallback invokes the ccc.CreateAudioFile API asynchronously
func (client *Client) CreateAudioFileWithCallback(request *CreateAudioFileRequest, callback func(response *CreateAudioFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAudioFileResponse
		var err error
		defer close(result)
		response, err = client.CreateAudioFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAudioFileRequest is the request struct for api CreateAudioFile
type CreateAudioFileRequest struct {
	*requests.RpcRequest
	OssFileKey    string `position:"Query" name:"OssFileKey"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	AudioFileName string `position:"Query" name:"AudioFileName"`
	Name          string `position:"Query" name:"Name"`
}

// CreateAudioFileResponse is the response struct for api CreateAudioFile
type CreateAudioFileResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAudioFileRequest creates a request to invoke CreateAudioFile API
func CreateCreateAudioFileRequest() (request *CreateAudioFileRequest) {
	request = &CreateAudioFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "CreateAudioFile", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAudioFileResponse creates a response to parse from CreateAudioFile response
func CreateCreateAudioFileResponse() (response *CreateAudioFileResponse) {
	response = &CreateAudioFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
