package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNodeToolExecutionHistory invokes the cassandra.DescribeNodeToolExecutionHistory API synchronously
func (client *Client) DescribeNodeToolExecutionHistory(request *DescribeNodeToolExecutionHistoryRequest) (response *DescribeNodeToolExecutionHistoryResponse, err error) {
	response = CreateDescribeNodeToolExecutionHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeToolExecutionHistoryWithChan invokes the cassandra.DescribeNodeToolExecutionHistory API asynchronously
func (client *Client) DescribeNodeToolExecutionHistoryWithChan(request *DescribeNodeToolExecutionHistoryRequest) (<-chan *DescribeNodeToolExecutionHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeToolExecutionHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNodeToolExecutionHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeToolExecutionHistoryWithCallback invokes the cassandra.DescribeNodeToolExecutionHistory API asynchronously
func (client *Client) DescribeNodeToolExecutionHistoryWithCallback(request *DescribeNodeToolExecutionHistoryRequest, callback func(response *DescribeNodeToolExecutionHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeToolExecutionHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeNodeToolExecutionHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeToolExecutionHistoryRequest is the request struct for api DescribeNodeToolExecutionHistory
type DescribeNodeToolExecutionHistoryRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	JobId     string `position:"Query" name:"JobId"`
	DcId      string `position:"Query" name:"DcId"`
}

// DescribeNodeToolExecutionHistoryResponse is the response struct for api DescribeNodeToolExecutionHistory
type DescribeNodeToolExecutionHistoryResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	JobId        string `json:"JobId" xml:"JobId"`
	Command      string `json:"Command" xml:"Command"`
	Nodes        string `json:"Nodes" xml:"Nodes"`
	ModifyTime   int64  `json:"ModifyTime" xml:"ModifyTime"`
	CreateTime   int64  `json:"CreateTime" xml:"CreateTime"`
	RegionId     string `json:"RegionId" xml:"RegionId"`
	IsEnded      bool   `json:"IsEnded" xml:"IsEnded"`
	Arguments    string `json:"Arguments" xml:"Arguments"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	DataCenterId string `json:"DataCenterId" xml:"DataCenterId"`
	Result       string `json:"Result" xml:"Result"`
}

// CreateDescribeNodeToolExecutionHistoryRequest creates a request to invoke DescribeNodeToolExecutionHistory API
func CreateDescribeNodeToolExecutionHistoryRequest() (request *DescribeNodeToolExecutionHistoryRequest) {
	request = &DescribeNodeToolExecutionHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeNodeToolExecutionHistory", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNodeToolExecutionHistoryResponse creates a response to parse from DescribeNodeToolExecutionHistory response
func CreateDescribeNodeToolExecutionHistoryResponse() (response *DescribeNodeToolExecutionHistoryResponse) {
	response = &DescribeNodeToolExecutionHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
