package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAvatarVideoTask invokes the avatar.SubmitAvatarVideoTask API synchronously
func (client *Client) SubmitAvatarVideoTask(request *SubmitAvatarVideoTaskRequest) (response *SubmitAvatarVideoTaskResponse, err error) {
	response = CreateSubmitAvatarVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAvatarVideoTaskWithChan invokes the avatar.SubmitAvatarVideoTask API asynchronously
func (client *Client) SubmitAvatarVideoTaskWithChan(request *SubmitAvatarVideoTaskRequest) (<-chan *SubmitAvatarVideoTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitAvatarVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAvatarVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAvatarVideoTaskWithCallback invokes the avatar.SubmitAvatarVideoTask API asynchronously
func (client *Client) SubmitAvatarVideoTaskWithCallback(request *SubmitAvatarVideoTaskRequest, callback func(response *SubmitAvatarVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAvatarVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitAvatarVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAvatarVideoTaskRequest is the request struct for api SubmitAvatarVideoTask
type SubmitAvatarVideoTaskRequest struct {
	*requests.RpcRequest
	Title             string                   `position:"Query" name:"Title"`
	CallbackParams    string                   `position:"Query" name:"CallbackParams"`
	TenantId          requests.Integer         `position:"Query" name:"TenantId"`
	VideoParams       string                   `position:"Query" name:"VideoParams"`
	App               SubmitAvatarVideoTaskApp `position:"Query" name:"App"  type:"Struct"`
	ExtParams         string                   `position:"Query" name:"ExtParams"`
	VideoParamsCLS    string                   `position:"Query" name:"VideoParams_CLS"`
	Callback          requests.Boolean         `position:"Query" name:"Callback"`
	ExtParamsCLS      string                   `position:"Query" name:"ExtParams_CLS"`
	CallbackParamsCLS string                   `position:"Query" name:"CallbackParams_CLS"`
}

// SubmitAvatarVideoTaskApp is a repeated param struct in SubmitAvatarVideoTaskRequest
type SubmitAvatarVideoTaskApp struct {
	AppId string `name:"AppId"`
}

// SubmitAvatarVideoTaskResponse is the response struct for api SubmitAvatarVideoTask
type SubmitAvatarVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitAvatarVideoTaskRequest creates a request to invoke SubmitAvatarVideoTask API
func CreateSubmitAvatarVideoTaskRequest() (request *SubmitAvatarVideoTaskRequest) {
	request = &SubmitAvatarVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "SubmitAvatarVideoTask", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitAvatarVideoTaskResponse creates a response to parse from SubmitAvatarVideoTask response
func CreateSubmitAvatarVideoTaskResponse() (response *SubmitAvatarVideoTaskResponse) {
	response = &SubmitAvatarVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
