package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCloudClusterAllUrl invokes the arms.GetCloudClusterAllUrl API synchronously
func (client *Client) GetCloudClusterAllUrl(request *GetCloudClusterAllUrlRequest) (response *GetCloudClusterAllUrlResponse, err error) {
	response = CreateGetCloudClusterAllUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetCloudClusterAllUrlWithChan invokes the arms.GetCloudClusterAllUrl API asynchronously
func (client *Client) GetCloudClusterAllUrlWithChan(request *GetCloudClusterAllUrlRequest) (<-chan *GetCloudClusterAllUrlResponse, <-chan error) {
	responseChan := make(chan *GetCloudClusterAllUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCloudClusterAllUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCloudClusterAllUrlWithCallback invokes the arms.GetCloudClusterAllUrl API asynchronously
func (client *Client) GetCloudClusterAllUrlWithCallback(request *GetCloudClusterAllUrlRequest, callback func(response *GetCloudClusterAllUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCloudClusterAllUrlResponse
		var err error
		defer close(result)
		response, err = client.GetCloudClusterAllUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCloudClusterAllUrlRequest is the request struct for api GetCloudClusterAllUrl
type GetCloudClusterAllUrlRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetCloudClusterAllUrlResponse is the response struct for api GetCloudClusterAllUrl
type GetCloudClusterAllUrlResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetCloudClusterAllUrlRequest creates a request to invoke GetCloudClusterAllUrl API
func CreateGetCloudClusterAllUrlRequest() (request *GetCloudClusterAllUrlRequest) {
	request = &GetCloudClusterAllUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetCloudClusterAllUrl", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCloudClusterAllUrlResponse creates a response to parse from GetCloudClusterAllUrl response
func CreateGetCloudClusterAllUrlResponse() (response *GetCloudClusterAllUrlResponse) {
	response = &GetCloudClusterAllUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
