package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNerCustomizedSeaEcom invokes the alinlp.GetNerCustomizedSeaEcom API synchronously
func (client *Client) GetNerCustomizedSeaEcom(request *GetNerCustomizedSeaEcomRequest) (response *GetNerCustomizedSeaEcomResponse, err error) {
	response = CreateGetNerCustomizedSeaEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetNerCustomizedSeaEcomWithChan invokes the alinlp.GetNerCustomizedSeaEcom API asynchronously
func (client *Client) GetNerCustomizedSeaEcomWithChan(request *GetNerCustomizedSeaEcomRequest) (<-chan *GetNerCustomizedSeaEcomResponse, <-chan error) {
	responseChan := make(chan *GetNerCustomizedSeaEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNerCustomizedSeaEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNerCustomizedSeaEcomWithCallback invokes the alinlp.GetNerCustomizedSeaEcom API asynchronously
func (client *Client) GetNerCustomizedSeaEcomWithCallback(request *GetNerCustomizedSeaEcomRequest, callback func(response *GetNerCustomizedSeaEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNerCustomizedSeaEcomResponse
		var err error
		defer close(result)
		response, err = client.GetNerCustomizedSeaEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNerCustomizedSeaEcomRequest is the request struct for api GetNerCustomizedSeaEcom
type GetNerCustomizedSeaEcomRequest struct {
	*requests.RpcRequest
	Language    string `position:"Body" name:"Language"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetNerCustomizedSeaEcomResponse is the response struct for api GetNerCustomizedSeaEcom
type GetNerCustomizedSeaEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetNerCustomizedSeaEcomRequest creates a request to invoke GetNerCustomizedSeaEcom API
func CreateGetNerCustomizedSeaEcomRequest() (request *GetNerCustomizedSeaEcomRequest) {
	request = &GetNerCustomizedSeaEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetNerCustomizedSeaEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNerCustomizedSeaEcomResponse creates a response to parse from GetNerCustomizedSeaEcom response
func CreateGetNerCustomizedSeaEcomResponse() (response *GetNerCustomizedSeaEcomResponse) {
	response = &GetNerCustomizedSeaEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
