package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDohAccountStatistics invokes the alidns.DescribeDohAccountStatistics API synchronously
func (client *Client) DescribeDohAccountStatistics(request *DescribeDohAccountStatisticsRequest) (response *DescribeDohAccountStatisticsResponse, err error) {
	response = CreateDescribeDohAccountStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDohAccountStatisticsWithChan invokes the alidns.DescribeDohAccountStatistics API asynchronously
func (client *Client) DescribeDohAccountStatisticsWithChan(request *DescribeDohAccountStatisticsRequest) (<-chan *DescribeDohAccountStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeDohAccountStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDohAccountStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDohAccountStatisticsWithCallback invokes the alidns.DescribeDohAccountStatistics API asynchronously
func (client *Client) DescribeDohAccountStatisticsWithCallback(request *DescribeDohAccountStatisticsRequest, callback func(response *DescribeDohAccountStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDohAccountStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDohAccountStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDohAccountStatisticsRequest is the request struct for api DescribeDohAccountStatistics
type DescribeDohAccountStatisticsRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
	Lang      string `position:"Query" name:"Lang"`
}

// DescribeDohAccountStatisticsResponse is the response struct for api DescribeDohAccountStatistics
type DescribeDohAccountStatisticsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Statistics []Statistic `json:"Statistics" xml:"Statistics"`
}

// CreateDescribeDohAccountStatisticsRequest creates a request to invoke DescribeDohAccountStatistics API
func CreateDescribeDohAccountStatisticsRequest() (request *DescribeDohAccountStatisticsRequest) {
	request = &DescribeDohAccountStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDohAccountStatistics", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDohAccountStatisticsResponse creates a response to parse from DescribeDohAccountStatistics response
func CreateDescribeDohAccountStatisticsResponse() (response *DescribeDohAccountStatisticsResponse) {
	response = &DescribeDohAccountStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
