package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmInstances invokes the alidns.DescribeDnsGtmInstances API synchronously
func (client *Client) DescribeDnsGtmInstances(request *DescribeDnsGtmInstancesRequest) (response *DescribeDnsGtmInstancesResponse, err error) {
	response = CreateDescribeDnsGtmInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmInstancesWithChan invokes the alidns.DescribeDnsGtmInstances API asynchronously
func (client *Client) DescribeDnsGtmInstancesWithChan(request *DescribeDnsGtmInstancesRequest) (<-chan *DescribeDnsGtmInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmInstancesWithCallback invokes the alidns.DescribeDnsGtmInstances API asynchronously
func (client *Client) DescribeDnsGtmInstancesWithCallback(request *DescribeDnsGtmInstancesRequest, callback func(response *DescribeDnsGtmInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmInstancesRequest is the request struct for api DescribeDnsGtmInstances
type DescribeDnsGtmInstancesRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	UserClientIp    string           `position:"Query" name:"UserClientIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
	Keyword         string           `position:"Query" name:"Keyword"`
}

// DescribeDnsGtmInstancesResponse is the response struct for api DescribeDnsGtmInstances
type DescribeDnsGtmInstancesResponse struct {
	*responses.BaseResponse
	PageSize     int           `json:"PageSize" xml:"PageSize"`
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	PageNumber   int           `json:"PageNumber" xml:"PageNumber"`
	TotalPages   int           `json:"TotalPages" xml:"TotalPages"`
	TotalItems   int           `json:"TotalItems" xml:"TotalItems"`
	GtmInstances []GtmInstance `json:"GtmInstances" xml:"GtmInstances"`
}

// CreateDescribeDnsGtmInstancesRequest creates a request to invoke DescribeDnsGtmInstances API
func CreateDescribeDnsGtmInstancesRequest() (request *DescribeDnsGtmInstancesRequest) {
	request = &DescribeDnsGtmInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmInstances", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmInstancesResponse creates a response to parse from DescribeDnsGtmInstances response
func CreateDescribeDnsGtmInstancesResponse() (response *DescribeDnsGtmInstancesResponse) {
	response = &DescribeDnsGtmInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
