// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opQueryOpenGetResourceCommon = "QueryOpenGetResource"

// QueryOpenGetResourceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryOpenGetResourceCommon operation. The "output" return
// value will be populated with the QueryOpenGetResourceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryOpenGetResourceCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryOpenGetResourceCommon Send returns without error.
//
// See QueryOpenGetResourceCommon for more information on using the QueryOpenGetResourceCommon
// API call, and error handling.
//
//    // Example sending a request using the QueryOpenGetResourceCommonRequest method.
//    req, resp := client.QueryOpenGetResourceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) QueryOpenGetResourceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opQueryOpenGetResourceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryOpenGetResourceCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation QueryOpenGetResourceCommon for usage and error information.
func (c *VMS) QueryOpenGetResourceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.QueryOpenGetResourceCommonRequest(input)
	return out, req.Send()
}

// QueryOpenGetResourceCommonWithContext is the same as QueryOpenGetResourceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See QueryOpenGetResourceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) QueryOpenGetResourceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.QueryOpenGetResourceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQueryOpenGetResource = "QueryOpenGetResource"

// QueryOpenGetResourceRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryOpenGetResource operation. The "output" return
// value will be populated with the QueryOpenGetResourceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryOpenGetResourceCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryOpenGetResourceCommon Send returns without error.
//
// See QueryOpenGetResource for more information on using the QueryOpenGetResource
// API call, and error handling.
//
//    // Example sending a request using the QueryOpenGetResourceRequest method.
//    req, resp := client.QueryOpenGetResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) QueryOpenGetResourceRequest(input *QueryOpenGetResourceInput) (req *request.Request, output *QueryOpenGetResourceOutput) {
	op := &request.Operation{
		Name:       opQueryOpenGetResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryOpenGetResourceInput{}
	}

	output = &QueryOpenGetResourceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryOpenGetResource API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation QueryOpenGetResource for usage and error information.
func (c *VMS) QueryOpenGetResource(input *QueryOpenGetResourceInput) (*QueryOpenGetResourceOutput, error) {
	req, out := c.QueryOpenGetResourceRequest(input)
	return out, req.Send()
}

// QueryOpenGetResourceWithContext is the same as QueryOpenGetResource with the addition of
// the ability to pass a context and additional request options.
//
// See QueryOpenGetResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) QueryOpenGetResourceWithContext(ctx volcengine.Context, input *QueryOpenGetResourceInput, opts ...request.Option) (*QueryOpenGetResourceOutput, error) {
	req, out := c.QueryOpenGetResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type QueryOpenGetResourceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	State *int32 `type:"int32" json:",omitempty"`

	// Type is a required field
	Type *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s QueryOpenGetResourceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryOpenGetResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryOpenGetResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryOpenGetResourceInput"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyword sets the Keyword field's value.
func (s *QueryOpenGetResourceInput) SetKeyword(v string) *QueryOpenGetResourceInput {
	s.Keyword = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *QueryOpenGetResourceInput) SetLimit(v int32) *QueryOpenGetResourceInput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *QueryOpenGetResourceInput) SetOffset(v int32) *QueryOpenGetResourceInput {
	s.Offset = &v
	return s
}

// SetState sets the State field's value.
func (s *QueryOpenGetResourceInput) SetState(v int32) *QueryOpenGetResourceInput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *QueryOpenGetResourceInput) SetType(v int32) *QueryOpenGetResourceInput {
	s.Type = &v
	return s
}

type QueryOpenGetResourceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	Records []*RecordForQueryOpenGetResourceOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s QueryOpenGetResourceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryOpenGetResourceOutput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *QueryOpenGetResourceOutput) SetLimit(v int32) *QueryOpenGetResourceOutput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *QueryOpenGetResourceOutput) SetOffset(v int32) *QueryOpenGetResourceOutput {
	s.Offset = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *QueryOpenGetResourceOutput) SetRecords(v []*RecordForQueryOpenGetResourceOutput) *QueryOpenGetResourceOutput {
	s.Records = v
	return s
}

// SetTotal sets the Total field's value.
func (s *QueryOpenGetResourceOutput) SetTotal(v int32) *QueryOpenGetResourceOutput {
	s.Total = &v
	return s
}

type RecordForQueryOpenGetResourceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	ResourceKey *string `type:"string" json:",omitempty"`

	State *int32 `type:"int32" json:",omitempty"`

	Suffix *string `type:"string" json:",omitempty"`

	TtsOptions *string `type:"string" json:",omitempty"`

	TtsTemplateContent *string `type:"string" json:",omitempty"`

	Type *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RecordForQueryOpenGetResourceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordForQueryOpenGetResourceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetCreateTime(v string) *RecordForQueryOpenGetResourceOutput {
	s.CreateTime = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetDuration(v int32) *RecordForQueryOpenGetResourceOutput {
	s.Duration = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetName(v string) *RecordForQueryOpenGetResourceOutput {
	s.Name = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetRemark(v string) *RecordForQueryOpenGetResourceOutput {
	s.Remark = &v
	return s
}

// SetResourceKey sets the ResourceKey field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetResourceKey(v string) *RecordForQueryOpenGetResourceOutput {
	s.ResourceKey = &v
	return s
}

// SetState sets the State field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetState(v int32) *RecordForQueryOpenGetResourceOutput {
	s.State = &v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetSuffix(v string) *RecordForQueryOpenGetResourceOutput {
	s.Suffix = &v
	return s
}

// SetTtsOptions sets the TtsOptions field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetTtsOptions(v string) *RecordForQueryOpenGetResourceOutput {
	s.TtsOptions = &v
	return s
}

// SetTtsTemplateContent sets the TtsTemplateContent field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetTtsTemplateContent(v string) *RecordForQueryOpenGetResourceOutput {
	s.TtsTemplateContent = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecordForQueryOpenGetResourceOutput) SetType(v int32) *RecordForQueryOpenGetResourceOutput {
	s.Type = &v
	return s
}
