// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDefaultNodePoolCommon = "CreateDefaultNodePool"

// CreateDefaultNodePoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDefaultNodePoolCommon operation. The "output" return
// value will be populated with the CreateDefaultNodePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDefaultNodePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDefaultNodePoolCommon Send returns without error.
//
// See CreateDefaultNodePoolCommon for more information on using the CreateDefaultNodePoolCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDefaultNodePoolCommonRequest method.
//    req, resp := client.CreateDefaultNodePoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateDefaultNodePoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDefaultNodePoolCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDefaultNodePoolCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateDefaultNodePoolCommon for usage and error information.
func (c *VKE) CreateDefaultNodePoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDefaultNodePoolCommonRequest(input)
	return out, req.Send()
}

// CreateDefaultNodePoolCommonWithContext is the same as CreateDefaultNodePoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultNodePoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateDefaultNodePoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDefaultNodePoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultNodePool = "CreateDefaultNodePool"

// CreateDefaultNodePoolRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDefaultNodePool operation. The "output" return
// value will be populated with the CreateDefaultNodePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDefaultNodePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDefaultNodePoolCommon Send returns without error.
//
// See CreateDefaultNodePool for more information on using the CreateDefaultNodePool
// API call, and error handling.
//
//    // Example sending a request using the CreateDefaultNodePoolRequest method.
//    req, resp := client.CreateDefaultNodePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateDefaultNodePoolRequest(input *CreateDefaultNodePoolInput) (req *request.Request, output *CreateDefaultNodePoolOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultNodePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultNodePoolInput{}
	}

	output = &CreateDefaultNodePoolOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDefaultNodePool API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateDefaultNodePool for usage and error information.
func (c *VKE) CreateDefaultNodePool(input *CreateDefaultNodePoolInput) (*CreateDefaultNodePoolOutput, error) {
	req, out := c.CreateDefaultNodePoolRequest(input)
	return out, req.Send()
}

// CreateDefaultNodePoolWithContext is the same as CreateDefaultNodePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultNodePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateDefaultNodePoolWithContext(ctx volcengine.Context, input *CreateDefaultNodePoolInput, opts ...request.Option) (*CreateDefaultNodePoolOutput, error) {
	req, out := c.CreateDefaultNodePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	KubernetesConfig *KubernetesConfigForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	NodeConfig *NodeConfigForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDefaultNodePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDefaultNodePoolInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.KubernetesConfig != nil {
		if err := s.KubernetesConfig.Validate(); err != nil {
			invalidParams.AddNested("KubernetesConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDefaultNodePoolInput) SetClientToken(v string) *CreateDefaultNodePoolInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateDefaultNodePoolInput) SetClusterId(v string) *CreateDefaultNodePoolInput {
	s.ClusterId = &v
	return s
}

// SetKubernetesConfig sets the KubernetesConfig field's value.
func (s *CreateDefaultNodePoolInput) SetKubernetesConfig(v *KubernetesConfigForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.KubernetesConfig = v
	return s
}

// SetNodeConfig sets the NodeConfig field's value.
func (s *CreateDefaultNodePoolInput) SetNodeConfig(v *NodeConfigForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.NodeConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDefaultNodePoolInput) SetTags(v []*TagForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.Tags = v
	return s
}

type CreateDefaultNodePoolOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDefaultNodePoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDefaultNodePoolOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateDefaultNodePoolOutput) SetId(v string) *CreateDefaultNodePoolOutput {
	s.Id = &v
	return s
}

type EvictionHardForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s EvictionHardForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EvictionHardForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

type FeatureGatesForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	QoSResourceManager *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s FeatureGatesForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureGatesForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetQoSResourceManager sets the QoSResourceManager field's value.
func (s *FeatureGatesForCreateDefaultNodePoolInput) SetQoSResourceManager(v bool) *FeatureGatesForCreateDefaultNodePoolInput {
	s.QoSResourceManager = &v
	return s
}

type KubeletConfigForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EvictionHard []*EvictionHardForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`

	FeatureGates *FeatureGatesForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	KubeApiBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	KubeApiQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	RegistryBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	RegistryPullQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	SerializeImagePulls *bool `type:"boolean" json:",omitempty"`

	TopologyManagerPolicy *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInput"`

	TopologyManagerScope *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerScopeForCreateDefaultNodePoolInput"`
}

// String returns the string representation
func (s KubeletConfigForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubeletConfigForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KubeletConfigForCreateDefaultNodePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KubeletConfigForCreateDefaultNodePoolInput"}
	if s.KubeApiBurst != nil && *s.KubeApiBurst < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KubeApiBurst", 1))
	}
	if s.KubeApiBurst != nil && *s.KubeApiBurst > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("KubeApiBurst", 100))
	}
	if s.KubeApiQps != nil && *s.KubeApiQps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KubeApiQps", 1))
	}
	if s.KubeApiQps != nil && *s.KubeApiQps > 50 {
		invalidParams.Add(request.NewErrParamMaxValue("KubeApiQps", 50))
	}
	if s.RegistryBurst != nil && *s.RegistryBurst < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistryBurst", 1))
	}
	if s.RegistryBurst != nil && *s.RegistryBurst > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("RegistryBurst", 100))
	}
	if s.RegistryPullQps != nil && *s.RegistryPullQps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistryPullQps", 1))
	}
	if s.RegistryPullQps != nil && *s.RegistryPullQps > 50 {
		invalidParams.Add(request.NewErrParamMaxValue("RegistryPullQps", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvictionHard sets the EvictionHard field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetEvictionHard(v []*EvictionHardForCreateDefaultNodePoolInput) *KubeletConfigForCreateDefaultNodePoolInput {
	s.EvictionHard = v
	return s
}

// SetFeatureGates sets the FeatureGates field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetFeatureGates(v *FeatureGatesForCreateDefaultNodePoolInput) *KubeletConfigForCreateDefaultNodePoolInput {
	s.FeatureGates = v
	return s
}

// SetKubeApiBurst sets the KubeApiBurst field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetKubeApiBurst(v int32) *KubeletConfigForCreateDefaultNodePoolInput {
	s.KubeApiBurst = &v
	return s
}

// SetKubeApiQps sets the KubeApiQps field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetKubeApiQps(v int32) *KubeletConfigForCreateDefaultNodePoolInput {
	s.KubeApiQps = &v
	return s
}

// SetRegistryBurst sets the RegistryBurst field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetRegistryBurst(v int32) *KubeletConfigForCreateDefaultNodePoolInput {
	s.RegistryBurst = &v
	return s
}

// SetRegistryPullQps sets the RegistryPullQps field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetRegistryPullQps(v int32) *KubeletConfigForCreateDefaultNodePoolInput {
	s.RegistryPullQps = &v
	return s
}

// SetSerializeImagePulls sets the SerializeImagePulls field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetSerializeImagePulls(v bool) *KubeletConfigForCreateDefaultNodePoolInput {
	s.SerializeImagePulls = &v
	return s
}

// SetTopologyManagerPolicy sets the TopologyManagerPolicy field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetTopologyManagerPolicy(v string) *KubeletConfigForCreateDefaultNodePoolInput {
	s.TopologyManagerPolicy = &v
	return s
}

// SetTopologyManagerScope sets the TopologyManagerScope field's value.
func (s *KubeletConfigForCreateDefaultNodePoolInput) SetTopologyManagerScope(v string) *KubeletConfigForCreateDefaultNodePoolInput {
	s.TopologyManagerScope = &v
	return s
}

type KubernetesConfigForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoSyncDisabled *bool `type:"boolean" json:",omitempty"`

	Cordon *bool `type:"boolean" json:",omitempty"`

	KubeletConfig *KubeletConfigForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	Labels []*LabelForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Taints []*TaintForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s KubernetesConfigForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesConfigForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KubernetesConfigForCreateDefaultNodePoolInput"}
	if s.KubeletConfig != nil {
		if err := s.KubeletConfig.Validate(); err != nil {
			invalidParams.AddNested("KubeletConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoSyncDisabled sets the AutoSyncDisabled field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetAutoSyncDisabled(v bool) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.AutoSyncDisabled = &v
	return s
}

// SetCordon sets the Cordon field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetCordon(v bool) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Cordon = &v
	return s
}

// SetKubeletConfig sets the KubeletConfig field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetKubeletConfig(v *KubeletConfigForCreateDefaultNodePoolInput) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.KubeletConfig = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetLabels(v []*LabelForCreateDefaultNodePoolInput) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Labels = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetNamePrefix(v string) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.NamePrefix = &v
	return s
}

// SetTaints sets the Taints field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetTaints(v []*TaintForCreateDefaultNodePoolInput) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Taints = v
	return s
}

type LabelForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LabelForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForCreateDefaultNodePoolInput) SetKey(v string) *LabelForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LabelForCreateDefaultNodePoolInput) SetValue(v string) *LabelForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

type LoginForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Password *string `type:"string" json:",omitempty"`

	SshKeyPairName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LoginForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *LoginForCreateDefaultNodePoolInput) SetPassword(v string) *LoginForCreateDefaultNodePoolInput {
	s.Password = &v
	return s
}

// SetSshKeyPairName sets the SshKeyPairName field's value.
func (s *LoginForCreateDefaultNodePoolInput) SetSshKeyPairName(v string) *LoginForCreateDefaultNodePoolInput {
	s.SshKeyPairName = &v
	return s
}

type NodeConfigForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InitializeScript *string `type:"string" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Security *SecurityForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NodeConfigForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetInitializeScript sets the InitializeScript field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetInitializeScript(v string) *NodeConfigForCreateDefaultNodePoolInput {
	s.InitializeScript = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetNamePrefix(v string) *NodeConfigForCreateDefaultNodePoolInput {
	s.NamePrefix = &v
	return s
}

// SetSecurity sets the Security field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetSecurity(v *SecurityForCreateDefaultNodePoolInput) *NodeConfigForCreateDefaultNodePoolInput {
	s.Security = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetTags(v []*TagForCreateDefaultNodePoolInput) *NodeConfigForCreateDefaultNodePoolInput {
	s.Tags = v
	return s
}

type SecurityForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Login *LoginForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SecurityStrategies []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SecurityForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetLogin sets the Login field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetLogin(v *LoginForCreateDefaultNodePoolInput) *SecurityForCreateDefaultNodePoolInput {
	s.Login = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetSecurityGroupIds(v []*string) *SecurityForCreateDefaultNodePoolInput {
	s.SecurityGroupIds = v
	return s
}

// SetSecurityStrategies sets the SecurityStrategies field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetSecurityStrategies(v []*string) *SecurityForCreateDefaultNodePoolInput {
	s.SecurityStrategies = v
	return s
}

type TagForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateDefaultNodePoolInput) SetKey(v string) *TagForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateDefaultNodePoolInput) SetValue(v string) *TagForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

type TaintForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Effect *string `type:"string" json:",omitempty" enum:"EnumOfEffectForCreateDefaultNodePoolInput"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaintForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaintForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetEffect sets the Effect field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetEffect(v string) *TaintForCreateDefaultNodePoolInput {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetKey(v string) *TaintForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetValue(v string) *TaintForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

const (
	// EnumOfEffectForCreateDefaultNodePoolInputNoSchedule is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputNoSchedule = "NoSchedule"

	// EnumOfEffectForCreateDefaultNodePoolInputPreferNoSchedule is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputPreferNoSchedule = "PreferNoSchedule"

	// EnumOfEffectForCreateDefaultNodePoolInputNoExecute is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputNoExecute = "NoExecute"
)

const (
	// EnumOfSecurityStrategyListForCreateDefaultNodePoolInputHids is a EnumOfSecurityStrategyListForCreateDefaultNodePoolInput enum value
	EnumOfSecurityStrategyListForCreateDefaultNodePoolInputHids = "Hids"
)

const (
	// EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputRestricted is a EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputRestricted = "restricted"

	// EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputBestEffort is a EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputBestEffort = "best-effort"

	// EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputNone is a EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputNone = "none"

	// EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputSingleNumaNode is a EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerPolicyForCreateDefaultNodePoolInputSingleNumaNode = "single-numa-node"
)

const (
	// EnumOfTopologyManagerScopeForCreateDefaultNodePoolInputPod is a EnumOfTopologyManagerScopeForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerScopeForCreateDefaultNodePoolInputPod = "pod"

	// EnumOfTopologyManagerScopeForCreateDefaultNodePoolInputContainer is a EnumOfTopologyManagerScopeForCreateDefaultNodePoolInput enum value
	EnumOfTopologyManagerScopeForCreateDefaultNodePoolInputContainer = "container"
)
