// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateFileSystemCommon = "CreateFileSystem"

// CreateFileSystemCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFileSystemCommon operation. The "output" return
// value will be populated with the CreateFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFileSystemCommon Send returns without error.
//
// See CreateFileSystemCommon for more information on using the CreateFileSystemCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateFileSystemCommonRequest method.
//    req, resp := client.CreateFileSystemCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateFileSystemCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateFileSystemCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFileSystemCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateFileSystemCommon for usage and error information.
func (c *VEPFS) CreateFileSystemCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateFileSystemCommonRequest(input)
	return out, req.Send()
}

// CreateFileSystemCommonWithContext is the same as CreateFileSystemCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystemCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateFileSystemCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateFileSystemCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystem = "CreateFileSystem"

// CreateFileSystemRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFileSystem operation. The "output" return
// value will be populated with the CreateFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFileSystemCommon Send returns without error.
//
// See CreateFileSystem for more information on using the CreateFileSystem
// API call, and error handling.
//
//    // Example sending a request using the CreateFileSystemRequest method.
//    req, resp := client.CreateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateFileSystemRequest(input *CreateFileSystemInput) (req *request.Request, output *CreateFileSystemOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemInput{}
	}

	output = &CreateFileSystemOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFileSystem API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateFileSystem for usage and error information.
func (c *VEPFS) CreateFileSystem(input *CreateFileSystemInput) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	return out, req.Send()
}

// CreateFileSystemWithContext is the same as CreateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateFileSystemWithContext(ctx volcengine.Context, input *CreateFileSystemInput, opts ...request.Option) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateFileSystemInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Capacity *int32 `type:"int32" json:",omitempty"`

	// ChargeType is a required field
	ChargeType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfChargeTypeForCreateFileSystemInput"`

	Description *string `type:"string" json:",omitempty"`

	// FileSystemName is a required field
	FileSystemName *string `type:"string" json:",omitempty" required:"true"`

	// FileSystemType is a required field
	FileSystemType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfFileSystemTypeForCreateFileSystemInput"`

	Project *string `type:"string" json:",omitempty"`

	// ProtocolType is a required field
	ProtocolType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfProtocolTypeForCreateFileSystemInput"`

	// StoreType is a required field
	StoreType *string `type:"string" json:",omitempty" required:"true"`

	SubnetId *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateFileSystemInput `type:"list" json:",omitempty"`

	VersionNumber *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	// ZoneId is a required field
	ZoneId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateFileSystemInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemInput"}
	if s.ChargeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeType"))
	}
	if s.FileSystemName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemName"))
	}
	if s.FileSystemType == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemType"))
	}
	if s.ProtocolType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolType"))
	}
	if s.StoreType == nil {
		invalidParams.Add(request.NewErrParamRequired("StoreType"))
	}
	if s.ZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *CreateFileSystemInput) SetCapacity(v int32) *CreateFileSystemInput {
	s.Capacity = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateFileSystemInput) SetChargeType(v string) *CreateFileSystemInput {
	s.ChargeType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFileSystemInput) SetDescription(v string) *CreateFileSystemInput {
	s.Description = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CreateFileSystemInput) SetFileSystemName(v string) *CreateFileSystemInput {
	s.FileSystemName = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *CreateFileSystemInput) SetFileSystemType(v string) *CreateFileSystemInput {
	s.FileSystemType = &v
	return s
}

// SetProject sets the Project field's value.
func (s *CreateFileSystemInput) SetProject(v string) *CreateFileSystemInput {
	s.Project = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *CreateFileSystemInput) SetProtocolType(v string) *CreateFileSystemInput {
	s.ProtocolType = &v
	return s
}

// SetStoreType sets the StoreType field's value.
func (s *CreateFileSystemInput) SetStoreType(v string) *CreateFileSystemInput {
	s.StoreType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateFileSystemInput) SetSubnetId(v string) *CreateFileSystemInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemInput) SetTags(v []*TagForCreateFileSystemInput) *CreateFileSystemInput {
	s.Tags = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *CreateFileSystemInput) SetVersionNumber(v string) *CreateFileSystemInput {
	s.VersionNumber = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateFileSystemInput) SetVpcId(v string) *CreateFileSystemInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateFileSystemInput) SetZoneId(v string) *CreateFileSystemInput {
	s.ZoneId = &v
	return s
}

type CreateFileSystemOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	FileSystemId *string `type:"string" json:",omitempty"`

	OrderNO *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateFileSystemOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateFileSystemOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateFileSystemOutput) SetFileSystemId(v string) *CreateFileSystemOutput {
	s.FileSystemId = &v
	return s
}

// SetOrderNO sets the OrderNO field's value.
func (s *CreateFileSystemOutput) SetOrderNO(v string) *CreateFileSystemOutput {
	s.OrderNO = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemOutput) SetTags(v []*TagForCreateFileSystemOutput) *CreateFileSystemOutput {
	s.Tags = v
	return s
}

type TagForCreateFileSystemInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateFileSystemInput"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateFileSystemInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFileSystemInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFileSystemInput) SetKey(v string) *TagForCreateFileSystemInput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagForCreateFileSystemInput) SetType(v string) *TagForCreateFileSystemInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFileSystemInput) SetValue(v string) *TagForCreateFileSystemInput {
	s.Value = &v
	return s
}

type TagForCreateFileSystemOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateFileSystemOutput"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateFileSystemOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFileSystemOutput) SetKey(v string) *TagForCreateFileSystemOutput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagForCreateFileSystemOutput) SetType(v string) *TagForCreateFileSystemOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFileSystemOutput) SetValue(v string) *TagForCreateFileSystemOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateFileSystemInputPayAsYouGo is a EnumOfChargeTypeForCreateFileSystemInput enum value
	EnumOfChargeTypeForCreateFileSystemInputPayAsYouGo = "PayAsYouGo"
)

const (
	// EnumOfFileSystemTypeForCreateFileSystemInputVePfs is a EnumOfFileSystemTypeForCreateFileSystemInput enum value
	EnumOfFileSystemTypeForCreateFileSystemInputVePfs = "VePFS"
)

const (
	// EnumOfProtocolTypeForCreateFileSystemInputNfs is a EnumOfProtocolTypeForCreateFileSystemInput enum value
	EnumOfProtocolTypeForCreateFileSystemInputNfs = "NFS"

	// EnumOfProtocolTypeForCreateFileSystemInputSmb is a EnumOfProtocolTypeForCreateFileSystemInput enum value
	EnumOfProtocolTypeForCreateFileSystemInputSmb = "SMB"

	// EnumOfProtocolTypeForCreateFileSystemInputVePfs is a EnumOfProtocolTypeForCreateFileSystemInput enum value
	EnumOfProtocolTypeForCreateFileSystemInputVePfs = "VePFS"

	// EnumOfProtocolTypeForCreateFileSystemInputFsx is a EnumOfProtocolTypeForCreateFileSystemInput enum value
	EnumOfProtocolTypeForCreateFileSystemInputFsx = "FSX"
)

const (
	// EnumOfTypeForCreateFileSystemInputSystem is a EnumOfTypeForCreateFileSystemInput enum value
	EnumOfTypeForCreateFileSystemInputSystem = "System"

	// EnumOfTypeForCreateFileSystemInputCustom is a EnumOfTypeForCreateFileSystemInput enum value
	EnumOfTypeForCreateFileSystemInputCustom = "Custom"
)

const (
	// EnumOfTypeForCreateFileSystemOutputSystem is a EnumOfTypeForCreateFileSystemOutput enum value
	EnumOfTypeForCreateFileSystemOutputSystem = "System"

	// EnumOfTypeForCreateFileSystemOutputCustom is a EnumOfTypeForCreateFileSystemOutput enum value
	EnumOfTypeForCreateFileSystemOutputCustom = "Custom"
)
