// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateDeploymentCommon = "UpdateDeployment"

// UpdateDeploymentCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateDeploymentCommon operation. The "output" return
// value will be populated with the UpdateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateDeploymentCommon Send returns without error.
//
// See UpdateDeploymentCommon for more information on using the UpdateDeploymentCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateDeploymentCommonRequest method.
//    req, resp := client.UpdateDeploymentCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateDeploymentCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateDeploymentCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateDeploymentCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateDeploymentCommon for usage and error information.
func (c *MLPLATFORM20240701) UpdateDeploymentCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateDeploymentCommonRequest(input)
	return out, req.Send()
}

// UpdateDeploymentCommonWithContext is the same as UpdateDeploymentCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeploymentCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateDeploymentCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateDeploymentCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeployment = "UpdateDeployment"

// UpdateDeploymentRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateDeployment operation. The "output" return
// value will be populated with the UpdateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateDeploymentCommon Send returns without error.
//
// See UpdateDeployment for more information on using the UpdateDeployment
// API call, and error handling.
//
//    // Example sending a request using the UpdateDeploymentRequest method.
//    req, resp := client.UpdateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateDeploymentRequest(input *UpdateDeploymentInput) (req *request.Request, output *UpdateDeploymentOutput) {
	op := &request.Operation{
		Name:       opUpdateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentInput{}
	}

	output = &UpdateDeploymentOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateDeployment API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateDeployment for usage and error information.
func (c *MLPLATFORM20240701) UpdateDeployment(input *UpdateDeploymentInput) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	return out, req.Send()
}

// UpdateDeploymentWithContext is the same as UpdateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateDeploymentWithContext(ctx volcengine.Context, input *UpdateDeploymentInput, opts ...request.Option) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CfsForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForUpdateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForUpdateDeploymentInput) SetFileSystemName(v string) *CfsForUpdateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForUpdateDeploymentInput) SetNamespaceId(v string) *CfsForUpdateDeploymentInput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForUpdateDeploymentInput) SetOptions(v *OptionsForUpdateDeploymentInput) *CfsForUpdateDeploymentInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForUpdateDeploymentInput) SetTos(v *TosForUpdateDeploymentInput) *CfsForUpdateDeploymentInput {
	s.Tos = v
	return s
}

type ConfigForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Nas *NasForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForUpdateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForUpdateDeploymentInput) SetCfs(v *CfsForUpdateDeploymentInput) *ConfigForUpdateDeploymentInput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForUpdateDeploymentInput) SetNas(v *NasForUpdateDeploymentInput) *ConfigForUpdateDeploymentInput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForUpdateDeploymentInput) SetSfcs(v *SfcsForUpdateDeploymentInput) *ConfigForUpdateDeploymentInput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForUpdateDeploymentInput) SetTos(v *TosForUpdateDeploymentInput) *ConfigForUpdateDeploymentInput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForUpdateDeploymentInput) SetVepfs(v *VepfsForUpdateDeploymentInput) *ConfigForUpdateDeploymentInput {
	s.Vepfs = v
	return s
}

type ConvertCredentialForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertCredentialForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCredentialForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *ConvertCredentialForUpdateDeploymentInput) SetRegistryToken(v string) *ConvertCredentialForUpdateDeploymentInput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *ConvertCredentialForUpdateDeploymentInput) SetRegistryUsername(v string) *ConvertCredentialForUpdateDeploymentInput {
	s.RegistryUsername = &v
	return s
}

type ConvertOptionsForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForUpdateDeploymentInput) SetInternalSync(v int64) *ConvertOptionsForUpdateDeploymentInput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForUpdateDeploymentInput) SetReplicas(v int64) *ConvertOptionsForUpdateDeploymentInput {
	s.Replicas = &v
	return s
}

type CredentialForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *CredentialForUpdateDeploymentInput) SetAccessKey(v string) *CredentialForUpdateDeploymentInput {
	s.AccessKey = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *CredentialForUpdateDeploymentInput) SetSecretAccessKey(v string) *CredentialForUpdateDeploymentInput {
	s.SecretAccessKey = &v
	return s
}

type EnvForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvForUpdateDeploymentInput) SetName(v string) *EnvForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForUpdateDeploymentInput) SetValue(v string) *EnvForUpdateDeploymentInput {
	s.Value = &v
	return s
}

type ExecForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ExecForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ExecForUpdateDeploymentInput) SetCommand(v string) *ExecForUpdateDeploymentInput {
	s.Command = &v
	return s
}

type FlexibleResourceClaimForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetCpu(v float64) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetFamily(v string) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetGpuCount(v float64) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetGpuType(v string) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetMemoryGiB(v float64) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForUpdateDeploymentInput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForUpdateDeploymentInput {
	s.RdmaEniCount = &v
	return s
}

type HTTPGetForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTPHeaders []*HTTPHeaderForUpdateDeploymentInput `type:"list" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Scheme *string `type:"string" json:",omitempty" enum:"EnumOfSchemeForUpdateDeploymentInput"`
}

// String returns the string representation
func (s HTTPGetForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPGetForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetHTTPHeaders sets the HTTPHeaders field's value.
func (s *HTTPGetForUpdateDeploymentInput) SetHTTPHeaders(v []*HTTPHeaderForUpdateDeploymentInput) *HTTPGetForUpdateDeploymentInput {
	s.HTTPHeaders = v
	return s
}

// SetPath sets the Path field's value.
func (s *HTTPGetForUpdateDeploymentInput) SetPath(v string) *HTTPGetForUpdateDeploymentInput {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HTTPGetForUpdateDeploymentInput) SetPort(v int32) *HTTPGetForUpdateDeploymentInput {
	s.Port = &v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *HTTPGetForUpdateDeploymentInput) SetScheme(v string) *HTTPGetForUpdateDeploymentInput {
	s.Scheme = &v
	return s
}

type HTTPHeaderForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HTTPHeaderForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeaderForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HTTPHeaderForUpdateDeploymentInput) SetName(v string) *HTTPHeaderForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeaderForUpdateDeploymentInput) SetValue(v string) *HTTPHeaderForUpdateDeploymentInput {
	s.Value = &v
	return s
}

type ImageForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *ConvertCredentialForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForUpdateDeploymentInput) SetCredential(v *ConvertCredentialForUpdateDeploymentInput) *ImageForUpdateDeploymentInput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForUpdateDeploymentInput) SetType(v string) *ImageForUpdateDeploymentInput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForUpdateDeploymentInput) SetUrl(v string) *ImageForUpdateDeploymentInput {
	s.Url = &v
	return s
}

type LivenessProbeForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s LivenessProbeForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LivenessProbeForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetEnabled(v bool) *LivenessProbeForUpdateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetExec(v *ExecForUpdateDeploymentInput) *LivenessProbeForUpdateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetFailureThreshold(v int32) *LivenessProbeForUpdateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetHTTPGet(v *HTTPGetForUpdateDeploymentInput) *LivenessProbeForUpdateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetInitialDelaySeconds(v int32) *LivenessProbeForUpdateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetPeriodSeconds(v int32) *LivenessProbeForUpdateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetSuccessThreshold(v int32) *LivenessProbeForUpdateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetTCPSocket(v *TCPSocketForUpdateDeploymentInput) *LivenessProbeForUpdateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *LivenessProbeForUpdateDeploymentInput) SetTimeoutSeconds(v int32) *LivenessProbeForUpdateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type ModelForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ModelID *string `type:"string" json:",omitempty"`

	ModelVersionID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModelForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetModelID sets the ModelID field's value.
func (s *ModelForUpdateDeploymentInput) SetModelID(v string) *ModelForUpdateDeploymentInput {
	s.ModelID = &v
	return s
}

// SetModelVersionID sets the ModelVersionID field's value.
func (s *ModelForUpdateDeploymentInput) SetModelVersionID(v string) *ModelForUpdateDeploymentInput {
	s.ModelVersionID = &v
	return s
}

type NasForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForUpdateDeploymentInput) SetAddr(v string) *NasForUpdateDeploymentInput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForUpdateDeploymentInput) SetFileSystemName(v string) *NasForUpdateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForUpdateDeploymentInput) SetId(v string) *NasForUpdateDeploymentInput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForUpdateDeploymentInput) SetNasType(v string) *NasForUpdateDeploymentInput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForUpdateDeploymentInput) SetSubPath(v string) *NasForUpdateDeploymentInput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForUpdateDeploymentInput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForUpdateDeploymentInput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForUpdateDeploymentInput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForUpdateDeploymentInput) SetStrategyType(v string) *NodeAffinitySpecForUpdateDeploymentInput {
	s.StrategyType = &v
	return s
}

type OptionsForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForUpdateDeploymentInput) SetInternalSync(v int64) *OptionsForUpdateDeploymentInput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForUpdateDeploymentInput) SetMetaCacheCapacity(v int64) *OptionsForUpdateDeploymentInput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForUpdateDeploymentInput) SetMetaCacheExpiryMinutes(v int64) *OptionsForUpdateDeploymentInput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForUpdateDeploymentInput) SetMetaCacheExpiryMsec(v int64) *OptionsForUpdateDeploymentInput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type PortForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForUpdateDeploymentInput"`
}

// String returns the string representation
func (s PortForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForUpdateDeploymentInput) SetExposePort(v string) *PortForUpdateDeploymentInput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForUpdateDeploymentInput) SetListenPort(v string) *PortForUpdateDeploymentInput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForUpdateDeploymentInput) SetPath(v string) *PortForUpdateDeploymentInput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForUpdateDeploymentInput) SetType(v string) *PortForUpdateDeploymentInput {
	s.Type = &v
	return s
}

type ReadinessProbeForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReadinessProbeForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadinessProbeForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetEnabled(v bool) *ReadinessProbeForUpdateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetExec(v *ExecForUpdateDeploymentInput) *ReadinessProbeForUpdateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetFailureThreshold(v int32) *ReadinessProbeForUpdateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetHTTPGet(v *HTTPGetForUpdateDeploymentInput) *ReadinessProbeForUpdateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetInitialDelaySeconds(v int32) *ReadinessProbeForUpdateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetPeriodSeconds(v int32) *ReadinessProbeForUpdateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetSuccessThreshold(v int32) *ReadinessProbeForUpdateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetTCPSocket(v *TCPSocketForUpdateDeploymentInput) *ReadinessProbeForUpdateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *ReadinessProbeForUpdateDeploymentInput) SetTimeoutSeconds(v int32) *ReadinessProbeForUpdateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type ResourceForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForUpdateDeploymentInput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForUpdateDeploymentInput) *ResourceForUpdateDeploymentInput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForUpdateDeploymentInput) SetInstanceTypeId(v string) *ResourceForUpdateDeploymentInput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForUpdateDeploymentInput) SetType(v string) *ResourceForUpdateDeploymentInput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForUpdateDeploymentInput) SetZoneId(v string) *ResourceForUpdateDeploymentInput {
	s.ZoneId = &v
	return s
}

type RoleForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	Credential *CredentialForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Envs []*EnvForUpdateDeploymentInput `type:"list" json:",omitempty"`

	Expose *bool `type:"boolean" json:",omitempty"`

	GracefulShutdownPeriod *int32 `type:"int32" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Image *ImageForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	LivenessProbe *LivenessProbeForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Model *ModelForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Ports []*PortForUpdateDeploymentInput `type:"list" json:",omitempty"`

	ReadinessProbe *ReadinessProbeForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Replicas *int32 `type:"int32" json:",omitempty"`

	Resource *ResourceForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	RollingUpdateStrategy *RollingUpdateStrategyForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	ShardNum *int32 `type:"int32" json:",omitempty"`

	StartupProbe *StartupProbeForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Storages []*StorageForUpdateDeploymentInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RoleForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *RoleForUpdateDeploymentInput) SetCommand(v string) *RoleForUpdateDeploymentInput {
	s.Command = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *RoleForUpdateDeploymentInput) SetCredential(v *CredentialForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Credential = v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *RoleForUpdateDeploymentInput) SetEnvs(v []*EnvForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Envs = v
	return s
}

// SetExpose sets the Expose field's value.
func (s *RoleForUpdateDeploymentInput) SetExpose(v bool) *RoleForUpdateDeploymentInput {
	s.Expose = &v
	return s
}

// SetGracefulShutdownPeriod sets the GracefulShutdownPeriod field's value.
func (s *RoleForUpdateDeploymentInput) SetGracefulShutdownPeriod(v int32) *RoleForUpdateDeploymentInput {
	s.GracefulShutdownPeriod = &v
	return s
}

// SetId sets the Id field's value.
func (s *RoleForUpdateDeploymentInput) SetId(v string) *RoleForUpdateDeploymentInput {
	s.Id = &v
	return s
}

// SetImage sets the Image field's value.
func (s *RoleForUpdateDeploymentInput) SetImage(v *ImageForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Image = v
	return s
}

// SetLivenessProbe sets the LivenessProbe field's value.
func (s *RoleForUpdateDeploymentInput) SetLivenessProbe(v *LivenessProbeForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.LivenessProbe = v
	return s
}

// SetModel sets the Model field's value.
func (s *RoleForUpdateDeploymentInput) SetModel(v *ModelForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Model = v
	return s
}

// SetName sets the Name field's value.
func (s *RoleForUpdateDeploymentInput) SetName(v string) *RoleForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForUpdateDeploymentInput) SetNodeAffinitySpec(v *NodeAffinitySpecForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.NodeAffinitySpec = v
	return s
}

// SetPorts sets the Ports field's value.
func (s *RoleForUpdateDeploymentInput) SetPorts(v []*PortForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Ports = v
	return s
}

// SetReadinessProbe sets the ReadinessProbe field's value.
func (s *RoleForUpdateDeploymentInput) SetReadinessProbe(v *ReadinessProbeForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.ReadinessProbe = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForUpdateDeploymentInput) SetReplicas(v int32) *RoleForUpdateDeploymentInput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForUpdateDeploymentInput) SetResource(v *ResourceForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Resource = v
	return s
}

// SetRollingUpdateStrategy sets the RollingUpdateStrategy field's value.
func (s *RoleForUpdateDeploymentInput) SetRollingUpdateStrategy(v *RollingUpdateStrategyForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.RollingUpdateStrategy = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *RoleForUpdateDeploymentInput) SetSecurityGroupIds(v []*string) *RoleForUpdateDeploymentInput {
	s.SecurityGroupIds = v
	return s
}

// SetShardNum sets the ShardNum field's value.
func (s *RoleForUpdateDeploymentInput) SetShardNum(v int32) *RoleForUpdateDeploymentInput {
	s.ShardNum = &v
	return s
}

// SetStartupProbe sets the StartupProbe field's value.
func (s *RoleForUpdateDeploymentInput) SetStartupProbe(v *StartupProbeForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.StartupProbe = v
	return s
}

// SetStorages sets the Storages field's value.
func (s *RoleForUpdateDeploymentInput) SetStorages(v []*StorageForUpdateDeploymentInput) *RoleForUpdateDeploymentInput {
	s.Storages = v
	return s
}

type RollingUpdateStrategyForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxSurge *int32 `type:"int32" json:",omitempty"`

	MaxUnavailable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RollingUpdateStrategyForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RollingUpdateStrategyForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetMaxSurge sets the MaxSurge field's value.
func (s *RollingUpdateStrategyForUpdateDeploymentInput) SetMaxSurge(v int32) *RollingUpdateStrategyForUpdateDeploymentInput {
	s.MaxSurge = &v
	return s
}

// SetMaxUnavailable sets the MaxUnavailable field's value.
func (s *RollingUpdateStrategyForUpdateDeploymentInput) SetMaxUnavailable(v int32) *RollingUpdateStrategyForUpdateDeploymentInput {
	s.MaxUnavailable = &v
	return s
}

type SfcsForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForUpdateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForUpdateDeploymentInput) SetCachePolicyId(v string) *SfcsForUpdateDeploymentInput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForUpdateDeploymentInput) SetFileSystemName(v string) *SfcsForUpdateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForUpdateDeploymentInput) SetOptions(v *ConvertOptionsForUpdateDeploymentInput) *SfcsForUpdateDeploymentInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForUpdateDeploymentInput) SetTos(v *TosForUpdateDeploymentInput) *SfcsForUpdateDeploymentInput {
	s.Tos = v
	return s
}

type StartupProbeForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartupProbeForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartupProbeForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetEnabled(v bool) *StartupProbeForUpdateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetExec(v *ExecForUpdateDeploymentInput) *StartupProbeForUpdateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetFailureThreshold(v int32) *StartupProbeForUpdateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetHTTPGet(v *HTTPGetForUpdateDeploymentInput) *StartupProbeForUpdateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetInitialDelaySeconds(v int32) *StartupProbeForUpdateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetPeriodSeconds(v int32) *StartupProbeForUpdateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetSuccessThreshold(v int32) *StartupProbeForUpdateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetTCPSocket(v *TCPSocketForUpdateDeploymentInput) *StartupProbeForUpdateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *StartupProbeForUpdateDeploymentInput) SetTimeoutSeconds(v int32) *StartupProbeForUpdateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type StatusForUpdateDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForUpdateDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForUpdateDeploymentOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForUpdateDeploymentOutput) SetMessage(v string) *StatusForUpdateDeploymentOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForUpdateDeploymentOutput) SetSecondaryState(v string) *StatusForUpdateDeploymentOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForUpdateDeploymentOutput) SetState(v string) *StatusForUpdateDeploymentOutput {
	s.State = &v
	return s
}

type StorageForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForUpdateDeploymentInput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForUpdateDeploymentInput) SetConfig(v *ConfigForUpdateDeploymentInput) *StorageForUpdateDeploymentInput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForUpdateDeploymentInput) SetMountPath(v string) *StorageForUpdateDeploymentInput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForUpdateDeploymentInput) SetReadOnly(v bool) *StorageForUpdateDeploymentInput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForUpdateDeploymentInput) SetType(v string) *StorageForUpdateDeploymentInput {
	s.Type = &v
	return s
}

type TCPSocketForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TCPSocketForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPSocketForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *TCPSocketForUpdateDeploymentInput) SetPort(v int32) *TCPSocketForUpdateDeploymentInput {
	s.Port = &v
	return s
}

type TosForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForUpdateDeploymentInput) SetBucket(v string) *TosForUpdateDeploymentInput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForUpdateDeploymentInput) SetPrefix(v string) *TosForUpdateDeploymentInput {
	s.Prefix = &v
	return s
}

type UpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AcceptServiceTraffic *bool `type:"boolean" json:",omitempty"`

	DeploymentName *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	Roles []*RoleForUpdateDeploymentInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptServiceTraffic sets the AcceptServiceTraffic field's value.
func (s *UpdateDeploymentInput) SetAcceptServiceTraffic(v bool) *UpdateDeploymentInput {
	s.AcceptServiceTraffic = &v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *UpdateDeploymentInput) SetDeploymentName(v string) *UpdateDeploymentInput {
	s.DeploymentName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDeploymentInput) SetDescription(v string) *UpdateDeploymentInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateDeploymentInput) SetDryRun(v bool) *UpdateDeploymentInput {
	s.DryRun = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDeploymentInput) SetId(v string) *UpdateDeploymentInput {
	s.Id = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *UpdateDeploymentInput) SetResourceQueueId(v string) *UpdateDeploymentInput {
	s.ResourceQueueId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *UpdateDeploymentInput) SetRoles(v []*RoleForUpdateDeploymentInput) *UpdateDeploymentInput {
	s.Roles = v
	return s
}

type UpdateDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DeploymentId *string `type:"string" json:",omitempty"`

	DeploymentVersionId *string `type:"string" json:",omitempty"`

	ServiceId *string `type:"string" json:",omitempty"`

	Status *StatusForUpdateDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s UpdateDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateDeploymentOutput) SetDeploymentId(v string) *UpdateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentVersionId sets the DeploymentVersionId field's value.
func (s *UpdateDeploymentOutput) SetDeploymentVersionId(v string) *UpdateDeploymentOutput {
	s.DeploymentVersionId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *UpdateDeploymentOutput) SetServiceId(v string) *UpdateDeploymentOutput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDeploymentOutput) SetStatus(v *StatusForUpdateDeploymentOutput) *UpdateDeploymentOutput {
	s.Status = v
	return s
}

type VepfsForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForUpdateDeploymentInput) SetFileSystemName(v string) *VepfsForUpdateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForUpdateDeploymentInput) SetHostPath(v string) *VepfsForUpdateDeploymentInput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForUpdateDeploymentInput) SetId(v string) *VepfsForUpdateDeploymentInput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForUpdateDeploymentInput) SetSubPath(v string) *VepfsForUpdateDeploymentInput {
	s.SubPath = &v
	return s
}

const (
	// EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputGpurequired is a EnumOfGPUCPUNodePreferenceForUpdateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputGpupreferred is a EnumOfGPUCPUNodePreferenceForUpdateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputCpurequired is a EnumOfGPUCPUNodePreferenceForUpdateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputCpupreferred is a EnumOfGPUCPUNodePreferenceForUpdateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForUpdateDeploymentInputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfSchemeForUpdateDeploymentInputHttp is a EnumOfSchemeForUpdateDeploymentInput enum value
	EnumOfSchemeForUpdateDeploymentInputHttp = "HTTP"

	// EnumOfSchemeForUpdateDeploymentInputHttps is a EnumOfSchemeForUpdateDeploymentInput enum value
	EnumOfSchemeForUpdateDeploymentInputHttps = "HTTPS"
)

const (
	// EnumOfTypeForUpdateDeploymentInputHttp11 is a EnumOfTypeForUpdateDeploymentInput enum value
	EnumOfTypeForUpdateDeploymentInputHttp11 = "HTTP/1.1"

	// EnumOfTypeForUpdateDeploymentInputHttp2 is a EnumOfTypeForUpdateDeploymentInput enum value
	EnumOfTypeForUpdateDeploymentInputHttp2 = "HTTP2"

	// EnumOfTypeForUpdateDeploymentInputGrpc is a EnumOfTypeForUpdateDeploymentInput enum value
	EnumOfTypeForUpdateDeploymentInputGrpc = "GRPC"

	// EnumOfTypeForUpdateDeploymentInputMetrics is a EnumOfTypeForUpdateDeploymentInput enum value
	EnumOfTypeForUpdateDeploymentInputMetrics = "Metrics"

	// EnumOfTypeForUpdateDeploymentInputOther is a EnumOfTypeForUpdateDeploymentInput enum value
	EnumOfTypeForUpdateDeploymentInputOther = "Other"
)
