// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package hbase

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstancesCommon = "DescribeDBInstances"

// DescribeDBInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstancesCommon operation. The "output" return
// value will be populated with the DescribeDBInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstancesCommon Send returns without error.
//
// See DescribeDBInstancesCommon for more information on using the DescribeDBInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstancesCommonRequest method.
//    req, resp := client.DescribeDBInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *HBASE) DescribeDBInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstancesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstancesCommon API operation for HBASE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for HBASE's
// API operation DescribeDBInstancesCommon for usage and error information.
func (c *HBASE) DescribeDBInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstancesCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesCommonWithContext is the same as DescribeDBInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HBASE) DescribeDBInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the DescribeDBInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstancesCommon Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *HBASE) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstances API operation for HBASE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for HBASE's
// API operation DescribeDBInstances for usage and error information.
func (c *HBASE) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HBASE) DescribeDBInstancesWithContext(ctx volcengine.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DBInstanceEndpointForDescribeDBInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressType *string `type:"string" json:",omitempty"`

	EipId *string `type:"string" json:",omitempty"`

	EndpointId *string `type:"string" json:",omitempty"`

	EndpointStr *string `type:"string" json:",omitempty"`

	NetworkType *string `type:"string" json:",omitempty"`

	PrivateDNSVisibility *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s DBInstanceEndpointForDescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceEndpointForDescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetAddressType sets the AddressType field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetAddressType(v string) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.AddressType = &v
	return s
}

// SetEipId sets the EipId field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetEipId(v string) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.EipId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetEndpointId(v string) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.EndpointId = &v
	return s
}

// SetEndpointStr sets the EndpointStr field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetEndpointStr(v string) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.EndpointStr = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetNetworkType(v string) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.NetworkType = &v
	return s
}

// SetPrivateDNSVisibility sets the PrivateDNSVisibility field's value.
func (s *DBInstanceEndpointForDescribeDBInstancesOutput) SetPrivateDNSVisibility(v bool) *DBInstanceEndpointForDescribeDBInstancesOutput {
	s.PrivateDNSVisibility = &v
	return s
}

type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTimeEnd *string `type:"string" json:",omitempty"`

	CreateTimeStart *string `type:"string" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceStatus *string `type:"string" json:",omitempty"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	// RegionId is a required field
	RegionId *string `type:"string" json:",omitempty" required:"true"`

	TagFilters []*TagFilterForDescribeDBInstancesInput `type:"list" json:",omitempty"`

	Tags []*TagForDescribeDBInstancesInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstancesInput"}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.RegionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateTimeEnd sets the CreateTimeEnd field's value.
func (s *DescribeDBInstancesInput) SetCreateTimeEnd(v string) *DescribeDBInstancesInput {
	s.CreateTimeEnd = &v
	return s
}

// SetCreateTimeStart sets the CreateTimeStart field's value.
func (s *DescribeDBInstancesInput) SetCreateTimeStart(v string) *DescribeDBInstancesInput {
	s.CreateTimeStart = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstancesInput) SetInstanceId(v string) *DescribeDBInstancesInput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *DescribeDBInstancesInput) SetInstanceName(v string) *DescribeDBInstancesInput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *DescribeDBInstancesInput) SetInstanceStatus(v string) *DescribeDBInstancesInput {
	s.InstanceStatus = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeDBInstancesInput) SetPageNumber(v int32) *DescribeDBInstancesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeDBInstancesInput) SetPageSize(v int32) *DescribeDBInstancesInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeDBInstancesInput) SetProjectName(v string) *DescribeDBInstancesInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *DescribeDBInstancesInput) SetRegionId(v string) *DescribeDBInstancesInput {
	s.RegionId = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeDBInstancesInput) SetTagFilters(v []*TagFilterForDescribeDBInstancesInput) *DescribeDBInstancesInput {
	s.TagFilters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDBInstancesInput) SetTags(v []*TagForDescribeDBInstancesInput) *DescribeDBInstancesInput {
	s.Tags = v
	return s
}

type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Instances []*InstanceForDescribeDBInstancesOutput `type:"list" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeDBInstancesOutput) SetInstances(v []*InstanceForDescribeDBInstancesOutput) *DescribeDBInstancesOutput {
	s.Instances = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeDBInstancesOutput) SetTotalCount(v int32) *DescribeDBInstancesOutput {
	s.TotalCount = &v
	return s
}

type InstanceForDescribeDBInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeDBInstancesOutput"`

	CreateTime *string `type:"string" json:",omitempty"`

	DBInstanceEndpoint []*DBInstanceEndpointForDescribeDBInstancesOutput `type:"list" json:",omitempty"`

	DeletionProtection *string `type:"string" json:",omitempty"`

	EngineVersion *string `type:"string" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	MultiAZ *bool `type:"boolean" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RSCount *int32 `type:"int32" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	StandbyUsedStorage *float64 `type:"double" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	StorageCapacity *int32 `type:"int32" json:",omitempty"`

	StorageType *string `type:"string" json:",omitempty" enum:"EnumOfStorageTypeForDescribeDBInstancesOutput"`

	SubnetId *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeDBInstancesOutput `type:"list" json:",omitempty"`

	UsedStorage *float64 `type:"double" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceForDescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceForDescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetChargeType sets the ChargeType field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetChargeType(v string) *InstanceForDescribeDBInstancesOutput {
	s.ChargeType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetCreateTime(v string) *InstanceForDescribeDBInstancesOutput {
	s.CreateTime = &v
	return s
}

// SetDBInstanceEndpoint sets the DBInstanceEndpoint field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetDBInstanceEndpoint(v []*DBInstanceEndpointForDescribeDBInstancesOutput) *InstanceForDescribeDBInstancesOutput {
	s.DBInstanceEndpoint = v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetDeletionProtection(v string) *InstanceForDescribeDBInstancesOutput {
	s.DeletionProtection = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetEngineVersion(v string) *InstanceForDescribeDBInstancesOutput {
	s.EngineVersion = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetExpireTime(v string) *InstanceForDescribeDBInstancesOutput {
	s.ExpireTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetInstanceId(v string) *InstanceForDescribeDBInstancesOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetInstanceName(v string) *InstanceForDescribeDBInstancesOutput {
	s.InstanceName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetInstanceType(v string) *InstanceForDescribeDBInstancesOutput {
	s.InstanceType = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetMultiAZ(v bool) *InstanceForDescribeDBInstancesOutput {
	s.MultiAZ = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetProjectName(v string) *InstanceForDescribeDBInstancesOutput {
	s.ProjectName = &v
	return s
}

// SetRSCount sets the RSCount field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetRSCount(v int32) *InstanceForDescribeDBInstancesOutput {
	s.RSCount = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetRegionId(v string) *InstanceForDescribeDBInstancesOutput {
	s.RegionId = &v
	return s
}

// SetStandbyUsedStorage sets the StandbyUsedStorage field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetStandbyUsedStorage(v float64) *InstanceForDescribeDBInstancesOutput {
	s.StandbyUsedStorage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetStatus(v string) *InstanceForDescribeDBInstancesOutput {
	s.Status = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetStorageCapacity(v int32) *InstanceForDescribeDBInstancesOutput {
	s.StorageCapacity = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetStorageType(v string) *InstanceForDescribeDBInstancesOutput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetSubnetId(v string) *InstanceForDescribeDBInstancesOutput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetTags(v []*TagForDescribeDBInstancesOutput) *InstanceForDescribeDBInstancesOutput {
	s.Tags = v
	return s
}

// SetUsedStorage sets the UsedStorage field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetUsedStorage(v float64) *InstanceForDescribeDBInstancesOutput {
	s.UsedStorage = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetVpcId(v string) *InstanceForDescribeDBInstancesOutput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetVpcName(v string) *InstanceForDescribeDBInstancesOutput {
	s.VpcName = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetZoneId(v string) *InstanceForDescribeDBInstancesOutput {
	s.ZoneId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *InstanceForDescribeDBInstancesOutput) SetZoneName(v string) *InstanceForDescribeDBInstancesOutput {
	s.ZoneName = &v
	return s
}

type TagFilterForDescribeDBInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForDescribeDBInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeDBInstancesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeDBInstancesInput) SetKey(v string) *TagFilterForDescribeDBInstancesInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForDescribeDBInstancesInput) SetValues(v []*string) *TagFilterForDescribeDBInstancesInput {
	s.Values = v
	return s
}

type TagForDescribeDBInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeDBInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeDBInstancesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeDBInstancesInput) SetKey(v string) *TagForDescribeDBInstancesInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeDBInstancesInput) SetValue(v string) *TagForDescribeDBInstancesInput {
	s.Value = &v
	return s
}

type TagForDescribeDBInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeDBInstancesOutput) SetKey(v string) *TagForDescribeDBInstancesOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeDBInstancesOutput) SetValue(v string) *TagForDescribeDBInstancesOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeTypeForDescribeDBInstancesOutputPostPaid is a EnumOfChargeTypeForDescribeDBInstancesOutput enum value
	EnumOfChargeTypeForDescribeDBInstancesOutputPostPaid = "PostPaid"

	// EnumOfChargeTypeForDescribeDBInstancesOutputPrePaid is a EnumOfChargeTypeForDescribeDBInstancesOutput enum value
	EnumOfChargeTypeForDescribeDBInstancesOutputPrePaid = "PrePaid"
)

const (
	// EnumOfStorageTypeForDescribeDBInstancesOutputHdfsHdd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputHdfsHdd = "HdfsHdd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputHdfsSsd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputHdfsSsd = "HdfsSsd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputHdfsEssd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputHdfsEssd = "HdfsEssd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputCfsHdd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputCfsHdd = "CfsHdd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputCfsSsd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputCfsSsd = "CfsSsd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputCfsEssd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputCfsEssd = "CfsEssd"

	// EnumOfStorageTypeForDescribeDBInstancesOutputTosStandard is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputTosStandard = "TosStandard"
)
