// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package graph

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeInstanceCommon = "DescribeInstance"

// DescribeInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstanceCommon operation. The "output" return
// value will be populated with the DescribeInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceCommon Send returns without error.
//
// See DescribeInstanceCommon for more information on using the DescribeInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceCommonRequest method.
//    req, resp := client.DescribeInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) DescribeInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstanceCommon API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation DescribeInstanceCommon for usage and error information.
func (c *GRAPH) DescribeInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceCommonRequest(input)
	return out, req.Send()
}

// DescribeInstanceCommonWithContext is the same as DescribeInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) DescribeInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstance = "DescribeInstance"

// DescribeInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstance operation. The "output" return
// value will be populated with the DescribeInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceCommon Send returns without error.
//
// See DescribeInstance for more information on using the DescribeInstance
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceRequest method.
//    req, resp := client.DescribeInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) DescribeInstanceRequest(input *DescribeInstanceInput) (req *request.Request, output *DescribeInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceInput{}
	}

	output = &DescribeInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstance API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation DescribeInstance for usage and error information.
func (c *GRAPH) DescribeInstance(input *DescribeInstanceInput) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	return out, req.Send()
}

// DescribeInstanceWithContext is the same as DescribeInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) DescribeInstanceWithContext(ctx volcengine.Context, input *DescribeInstanceInput, opts ...request.Option) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AvailabilityZoneForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	K8sDomain *string `type:"string" json:",omitempty"`

	NodeNum *int32 `type:"int32" json:",omitempty"`

	NodePoolName *string `type:"string" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AvailabilityZoneForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZoneForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetAvailabilityZoneId(v string) *AvailabilityZoneForDescribeInstanceOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetK8sDomain sets the K8sDomain field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetK8sDomain(v string) *AvailabilityZoneForDescribeInstanceOutput {
	s.K8sDomain = &v
	return s
}

// SetNodeNum sets the NodeNum field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetNodeNum(v int32) *AvailabilityZoneForDescribeInstanceOutput {
	s.NodeNum = &v
	return s
}

// SetNodePoolName sets the NodePoolName field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetNodePoolName(v string) *AvailabilityZoneForDescribeInstanceOutput {
	s.NodePoolName = &v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetSubnetID(v string) *AvailabilityZoneForDescribeInstanceOutput {
	s.SubnetID = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *AvailabilityZoneForDescribeInstanceOutput) SetSubnetName(v string) *AvailabilityZoneForDescribeInstanceOutput {
	s.SubnetName = &v
	return s
}

type Bg3LinkForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressType *string `type:"string" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	Bg3Link *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s Bg3LinkForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Bg3LinkForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetAddressType sets the AddressType field's value.
func (s *Bg3LinkForDescribeInstanceOutput) SetAddressType(v string) *Bg3LinkForDescribeInstanceOutput {
	s.AddressType = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *Bg3LinkForDescribeInstanceOutput) SetAvailabilityZoneId(v string) *Bg3LinkForDescribeInstanceOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetBg3Link sets the Bg3Link field's value.
func (s *Bg3LinkForDescribeInstanceOutput) SetBg3Link(v string) *Bg3LinkForDescribeInstanceOutput {
	s.Bg3Link = &v
	return s
}

type BytestoreInfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cluster *string `type:"string" json:",omitempty"`

	Id *int64 `type:"int64" json:",omitempty"`

	Pool *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BytestoreInfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BytestoreInfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *BytestoreInfoForDescribeInstanceOutput) SetCluster(v string) *BytestoreInfoForDescribeInstanceOutput {
	s.Cluster = &v
	return s
}

// SetId sets the Id field's value.
func (s *BytestoreInfoForDescribeInstanceOutput) SetId(v int64) *BytestoreInfoForDescribeInstanceOutput {
	s.Id = &v
	return s
}

// SetPool sets the Pool field's value.
func (s *BytestoreInfoForDescribeInstanceOutput) SetPool(v string) *BytestoreInfoForDescribeInstanceOutput {
	s.Pool = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *BytestoreInfoForDescribeInstanceOutput) SetRegion(v string) *BytestoreInfoForDescribeInstanceOutput {
	s.Region = &v
	return s
}

type DescribeInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstanceInput) SetInstanceId(v string) *DescribeInstanceInput {
	s.InstanceId = &v
	return s
}

type DescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Info *InfoForDescribeInstanceOutput `type:"structure" json:"info,omitempty"`
}

// String returns the string representation
func (s DescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetInfo sets the Info field's value.
func (s *DescribeInstanceOutput) SetInfo(v *InfoForDescribeInstanceOutput) *DescribeInstanceOutput {
	s.Info = v
	return s
}

type ImageInfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bg3DeployVersion *string `type:"string" json:",omitempty"`

	Bg3ImageVersion *string `type:"string" json:",omitempty"`

	MsDeployVersion *string `type:"string" json:",omitempty"`

	MsImageVersion *string `type:"string" json:",omitempty"`

	VersionSetID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ImageInfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageInfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetBg3DeployVersion sets the Bg3DeployVersion field's value.
func (s *ImageInfoForDescribeInstanceOutput) SetBg3DeployVersion(v string) *ImageInfoForDescribeInstanceOutput {
	s.Bg3DeployVersion = &v
	return s
}

// SetBg3ImageVersion sets the Bg3ImageVersion field's value.
func (s *ImageInfoForDescribeInstanceOutput) SetBg3ImageVersion(v string) *ImageInfoForDescribeInstanceOutput {
	s.Bg3ImageVersion = &v
	return s
}

// SetMsDeployVersion sets the MsDeployVersion field's value.
func (s *ImageInfoForDescribeInstanceOutput) SetMsDeployVersion(v string) *ImageInfoForDescribeInstanceOutput {
	s.MsDeployVersion = &v
	return s
}

// SetMsImageVersion sets the MsImageVersion field's value.
func (s *ImageInfoForDescribeInstanceOutput) SetMsImageVersion(v string) *ImageInfoForDescribeInstanceOutput {
	s.MsImageVersion = &v
	return s
}

// SetVersionSetID sets the VersionSetID field's value.
func (s *ImageInfoForDescribeInstanceOutput) SetVersionSetID(v int64) *ImageInfoForDescribeInstanceOutput {
	s.VersionSetID = &v
	return s
}

type InfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	AvailabilityZones []*AvailabilityZoneForDescribeInstanceOutput `type:"list" json:",omitempty"`

	Bg3Link *string `type:"string" json:",omitempty"`

	Bg3Links []*Bg3LinkForDescribeInstanceOutput `type:"list" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Creator *string `type:"string" json:",omitempty"`

	DeletionProtection *string `type:"string" json:",omitempty"`

	DiskSpace *int32 `type:"int32" json:",omitempty"`

	DiskUsed *int64 `type:"int64" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	GraphVersion *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	ImageInfo *ImageInfoForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	InsSpec *InsSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	K8sDomain *string `type:"string" json:",omitempty"`

	MaintenanceTime *string `type:"string" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeNum *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	StorageInfo *StorageInfoForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeInstanceOutput `type:"list" json:",omitempty"`

	TradeNO *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *InfoForDescribeInstanceOutput) SetAvailabilityZoneId(v string) *InfoForDescribeInstanceOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *InfoForDescribeInstanceOutput) SetAvailabilityZones(v []*AvailabilityZoneForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.AvailabilityZones = v
	return s
}

// SetBg3Link sets the Bg3Link field's value.
func (s *InfoForDescribeInstanceOutput) SetBg3Link(v string) *InfoForDescribeInstanceOutput {
	s.Bg3Link = &v
	return s
}

// SetBg3Links sets the Bg3Links field's value.
func (s *InfoForDescribeInstanceOutput) SetBg3Links(v []*Bg3LinkForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.Bg3Links = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *InfoForDescribeInstanceOutput) SetCreateTime(v string) *InfoForDescribeInstanceOutput {
	s.CreateTime = &v
	return s
}

// SetCreator sets the Creator field's value.
func (s *InfoForDescribeInstanceOutput) SetCreator(v string) *InfoForDescribeInstanceOutput {
	s.Creator = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InfoForDescribeInstanceOutput) SetDeletionProtection(v string) *InfoForDescribeInstanceOutput {
	s.DeletionProtection = &v
	return s
}

// SetDiskSpace sets the DiskSpace field's value.
func (s *InfoForDescribeInstanceOutput) SetDiskSpace(v int32) *InfoForDescribeInstanceOutput {
	s.DiskSpace = &v
	return s
}

// SetDiskUsed sets the DiskUsed field's value.
func (s *InfoForDescribeInstanceOutput) SetDiskUsed(v int64) *InfoForDescribeInstanceOutput {
	s.DiskUsed = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *InfoForDescribeInstanceOutput) SetExpireTime(v string) *InfoForDescribeInstanceOutput {
	s.ExpireTime = &v
	return s
}

// SetGraphVersion sets the GraphVersion field's value.
func (s *InfoForDescribeInstanceOutput) SetGraphVersion(v string) *InfoForDescribeInstanceOutput {
	s.GraphVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *InfoForDescribeInstanceOutput) SetId(v string) *InfoForDescribeInstanceOutput {
	s.Id = &v
	return s
}

// SetImageInfo sets the ImageInfo field's value.
func (s *InfoForDescribeInstanceOutput) SetImageInfo(v *ImageInfoForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.ImageInfo = v
	return s
}

// SetInsSpec sets the InsSpec field's value.
func (s *InfoForDescribeInstanceOutput) SetInsSpec(v *InsSpecForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.InsSpec = v
	return s
}

// SetK8sDomain sets the K8sDomain field's value.
func (s *InfoForDescribeInstanceOutput) SetK8sDomain(v string) *InfoForDescribeInstanceOutput {
	s.K8sDomain = &v
	return s
}

// SetMaintenanceTime sets the MaintenanceTime field's value.
func (s *InfoForDescribeInstanceOutput) SetMaintenanceTime(v string) *InfoForDescribeInstanceOutput {
	s.MaintenanceTime = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *InfoForDescribeInstanceOutput) SetMode(v string) *InfoForDescribeInstanceOutput {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *InfoForDescribeInstanceOutput) SetName(v string) *InfoForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetNodeNum sets the NodeNum field's value.
func (s *InfoForDescribeInstanceOutput) SetNodeNum(v int32) *InfoForDescribeInstanceOutput {
	s.NodeNum = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InfoForDescribeInstanceOutput) SetProjectName(v string) *InfoForDescribeInstanceOutput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InfoForDescribeInstanceOutput) SetRegionId(v string) *InfoForDescribeInstanceOutput {
	s.RegionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InfoForDescribeInstanceOutput) SetStatus(v string) *InfoForDescribeInstanceOutput {
	s.Status = &v
	return s
}

// SetStorageInfo sets the StorageInfo field's value.
func (s *InfoForDescribeInstanceOutput) SetStorageInfo(v *StorageInfoForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.StorageInfo = v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *InfoForDescribeInstanceOutput) SetSubnetID(v string) *InfoForDescribeInstanceOutput {
	s.SubnetID = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *InfoForDescribeInstanceOutput) SetSubnetName(v string) *InfoForDescribeInstanceOutput {
	s.SubnetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InfoForDescribeInstanceOutput) SetTags(v []*TagForDescribeInstanceOutput) *InfoForDescribeInstanceOutput {
	s.Tags = v
	return s
}

// SetTradeNO sets the TradeNO field's value.
func (s *InfoForDescribeInstanceOutput) SetTradeNO(v string) *InfoForDescribeInstanceOutput {
	s.TradeNO = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InfoForDescribeInstanceOutput) SetVpcId(v string) *InfoForDescribeInstanceOutput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *InfoForDescribeInstanceOutput) SetVpcName(v string) *InfoForDescribeInstanceOutput {
	s.VpcName = &v
	return s
}

type InsSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CpuNum *int32 `type:"int32" json:",omitempty"`

	MemInGb *int32 `type:"int32" json:",omitempty"`

	SpecName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InsSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InsSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCpuNum sets the CpuNum field's value.
func (s *InsSpecForDescribeInstanceOutput) SetCpuNum(v int32) *InsSpecForDescribeInstanceOutput {
	s.CpuNum = &v
	return s
}

// SetMemInGb sets the MemInGb field's value.
func (s *InsSpecForDescribeInstanceOutput) SetMemInGb(v int32) *InsSpecForDescribeInstanceOutput {
	s.MemInGb = &v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *InsSpecForDescribeInstanceOutput) SetSpecName(v string) *InsSpecForDescribeInstanceOutput {
	s.SpecName = &v
	return s
}

type StorageInfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BytestoreInfo *BytestoreInfoForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	StorageType *string `type:"string" json:",omitempty" enum:"EnumOfStorageTypeForDescribeInstanceOutput"`
}

// String returns the string representation
func (s StorageInfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageInfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetBytestoreInfo sets the BytestoreInfo field's value.
func (s *StorageInfoForDescribeInstanceOutput) SetBytestoreInfo(v *BytestoreInfoForDescribeInstanceOutput) *StorageInfoForDescribeInstanceOutput {
	s.BytestoreInfo = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *StorageInfoForDescribeInstanceOutput) SetStorageType(v string) *StorageInfoForDescribeInstanceOutput {
	s.StorageType = &v
	return s
}

type TagForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeInstanceOutput) SetKey(v string) *TagForDescribeInstanceOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeInstanceOutput) SetValue(v string) *TagForDescribeInstanceOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfStorageTypeForDescribeInstanceOutputMemory is a EnumOfStorageTypeForDescribeInstanceOutput enum value
	EnumOfStorageTypeForDescribeInstanceOutputMemory = "Memory"

	// EnumOfStorageTypeForDescribeInstanceOutputByteStore is a EnumOfStorageTypeForDescribeInstanceOutput enum value
	EnumOfStorageTypeForDescribeInstanceOutputByteStore = "ByteStore"
)
