// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNatFirewallCommon = "CreateNatFirewall"

// CreateNatFirewallCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNatFirewallCommon operation. The "output" return
// value will be populated with the CreateNatFirewallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNatFirewallCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNatFirewallCommon Send returns without error.
//
// See CreateNatFirewallCommon for more information on using the CreateNatFirewallCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNatFirewallCommonRequest method.
//    req, resp := client.CreateNatFirewallCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) CreateNatFirewallCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNatFirewallCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNatFirewallCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation CreateNatFirewallCommon for usage and error information.
func (c *FWCENTER) CreateNatFirewallCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNatFirewallCommonRequest(input)
	return out, req.Send()
}

// CreateNatFirewallCommonWithContext is the same as CreateNatFirewallCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatFirewallCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) CreateNatFirewallCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNatFirewallCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNatFirewall = "CreateNatFirewall"

// CreateNatFirewallRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNatFirewall operation. The "output" return
// value will be populated with the CreateNatFirewallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNatFirewallCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNatFirewallCommon Send returns without error.
//
// See CreateNatFirewall for more information on using the CreateNatFirewall
// API call, and error handling.
//
//    // Example sending a request using the CreateNatFirewallRequest method.
//    req, resp := client.CreateNatFirewallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) CreateNatFirewallRequest(input *CreateNatFirewallInput) (req *request.Request, output *CreateNatFirewallOutput) {
	op := &request.Operation{
		Name:       opCreateNatFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatFirewallInput{}
	}

	output = &CreateNatFirewallOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNatFirewall API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation CreateNatFirewall for usage and error information.
func (c *FWCENTER) CreateNatFirewall(input *CreateNatFirewallInput) (*CreateNatFirewallOutput, error) {
	req, out := c.CreateNatFirewallRequest(input)
	return out, req.Send()
}

// CreateNatFirewallWithContext is the same as CreateNatFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) CreateNatFirewallWithContext(ctx volcengine.Context, input *CreateNatFirewallInput, opts ...request.Option) (*CreateNatFirewallOutput, error) {
	req, out := c.CreateNatFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNatFirewallInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Bandwidth is a required field
	Bandwidth *int32 `min:"10" type:"int32" json:",omitempty" required:"true"`

	CloudFirewallId *string `type:"string" json:",omitempty"`

	// FirewallCidr is a required field
	FirewallCidr *string `type:"string" json:",omitempty" required:"true"`

	// NatFirewallName is a required field
	NatFirewallName *string `type:"string" json:",omitempty" required:"true"`

	// NatGatewayId is a required field
	NatGatewayId *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateNatFirewallInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateNatFirewallInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNatFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNatFirewallInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.Bandwidth != nil && *s.Bandwidth < 10 {
		invalidParams.Add(request.NewErrParamMinValue("Bandwidth", 10))
	}
	if s.FirewallCidr == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallCidr"))
	}
	if s.NatFirewallName == nil {
		invalidParams.Add(request.NewErrParamRequired("NatFirewallName"))
	}
	if s.NatGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("NatGatewayId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateNatFirewallInput) SetBandwidth(v int32) *CreateNatFirewallInput {
	s.Bandwidth = &v
	return s
}

// SetCloudFirewallId sets the CloudFirewallId field's value.
func (s *CreateNatFirewallInput) SetCloudFirewallId(v string) *CreateNatFirewallInput {
	s.CloudFirewallId = &v
	return s
}

// SetFirewallCidr sets the FirewallCidr field's value.
func (s *CreateNatFirewallInput) SetFirewallCidr(v string) *CreateNatFirewallInput {
	s.FirewallCidr = &v
	return s
}

// SetNatFirewallName sets the NatFirewallName field's value.
func (s *CreateNatFirewallInput) SetNatFirewallName(v string) *CreateNatFirewallInput {
	s.NatFirewallName = &v
	return s
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *CreateNatFirewallInput) SetNatGatewayId(v string) *CreateNatFirewallInput {
	s.NatGatewayId = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateNatFirewallInput) SetProjectName(v string) *CreateNatFirewallInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNatFirewallInput) SetTags(v []*TagForCreateNatFirewallInput) *CreateNatFirewallInput {
	s.Tags = v
	return s
}

type CreateNatFirewallOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AccountId *string `type:"string" json:",omitempty"`

	NatFirewallId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateNatFirewallOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatFirewallOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CreateNatFirewallOutput) SetAccountId(v string) *CreateNatFirewallOutput {
	s.AccountId = &v
	return s
}

// SetNatFirewallId sets the NatFirewallId field's value.
func (s *CreateNatFirewallOutput) SetNatFirewallId(v string) *CreateNatFirewallOutput {
	s.NatFirewallId = &v
	return s
}

type TagForCreateNatFirewallInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateNatFirewallInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateNatFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateNatFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateNatFirewallInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateNatFirewallInput) SetKey(v string) *TagForCreateNatFirewallInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateNatFirewallInput) SetValue(v string) *TagForCreateNatFirewallInput {
	s.Value = &v
	return s
}
