// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opResetPasswordCommon = "ResetPassword"

// ResetPasswordCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ResetPasswordCommon operation. The "output" return
// value will be populated with the ResetPasswordCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ResetPasswordCommon Request to send the API call to the service.
// the "output" return value is not valid until after ResetPasswordCommon Send returns without error.
//
// See ResetPasswordCommon for more information on using the ResetPasswordCommon
// API call, and error handling.
//
//    // Example sending a request using the ResetPasswordCommonRequest method.
//    req, resp := client.ResetPasswordCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ResetPasswordCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opResetPasswordCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ResetPasswordCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ResetPasswordCommon for usage and error information.
func (c *CLOUDIDENTITY) ResetPasswordCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ResetPasswordCommonRequest(input)
	return out, req.Send()
}

// ResetPasswordCommonWithContext is the same as ResetPasswordCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPasswordCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ResetPasswordCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ResetPasswordCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPassword = "ResetPassword"

// ResetPasswordRequest generates a "volcengine/request.Request" representing the
// client's request for the ResetPassword operation. The "output" return
// value will be populated with the ResetPasswordCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ResetPasswordCommon Request to send the API call to the service.
// the "output" return value is not valid until after ResetPasswordCommon Send returns without error.
//
// See ResetPassword for more information on using the ResetPassword
// API call, and error handling.
//
//    // Example sending a request using the ResetPasswordRequest method.
//    req, resp := client.ResetPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ResetPasswordRequest(input *ResetPasswordInput) (req *request.Request, output *ResetPasswordOutput) {
	op := &request.Operation{
		Name:       opResetPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetPasswordInput{}
	}

	output = &ResetPasswordOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ResetPassword API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ResetPassword for usage and error information.
func (c *CLOUDIDENTITY) ResetPassword(input *ResetPasswordInput) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	return out, req.Send()
}

// ResetPasswordWithContext is the same as ResetPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ResetPasswordWithContext(ctx volcengine.Context, input *ResetPasswordInput, opts ...request.Option) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ResetPasswordInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// GenerateRandomPassword is a required field
	GenerateRandomPassword *bool `type:"boolean" json:",omitempty" required:"true"`

	Password *string `min:"8" max:"32" type:"string" json:",omitempty"`

	// PasswordResetRequired is a required field
	PasswordResetRequired *bool `type:"boolean" json:",omitempty" required:"true"`

	// UserId is a required field
	UserId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ResetPasswordInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetPasswordInput"}
	if s.GenerateRandomPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerateRandomPassword"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.Password != nil && len(*s.Password) > 32 {
		invalidParams.Add(request.NewErrParamMaxLen("Password", 32, *s.Password))
	}
	if s.PasswordResetRequired == nil {
		invalidParams.Add(request.NewErrParamRequired("PasswordResetRequired"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerateRandomPassword sets the GenerateRandomPassword field's value.
func (s *ResetPasswordInput) SetGenerateRandomPassword(v bool) *ResetPasswordInput {
	s.GenerateRandomPassword = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ResetPasswordInput) SetPassword(v string) *ResetPasswordInput {
	s.Password = &v
	return s
}

// SetPasswordResetRequired sets the PasswordResetRequired field's value.
func (s *ResetPasswordInput) SetPasswordResetRequired(v bool) *ResetPasswordInput {
	s.PasswordResetRequired = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResetPasswordInput) SetUserId(v string) *ResetPasswordInput {
	s.UserId = &v
	return s
}

type ResetPasswordOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Password *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResetPasswordOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordOutput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *ResetPasswordOutput) SetPassword(v string) *ResetPasswordOutput {
	s.Password = &v
	return s
}
