// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package certificateservice

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCertificateAddOrganizationCommon = "CertificateAddOrganization"

// CertificateAddOrganizationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CertificateAddOrganizationCommon operation. The "output" return
// value will be populated with the CertificateAddOrganizationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CertificateAddOrganizationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CertificateAddOrganizationCommon Send returns without error.
//
// See CertificateAddOrganizationCommon for more information on using the CertificateAddOrganizationCommon
// API call, and error handling.
//
//    // Example sending a request using the CertificateAddOrganizationCommonRequest method.
//    req, resp := client.CertificateAddOrganizationCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CERTIFICATESERVICE) CertificateAddOrganizationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCertificateAddOrganizationCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CertificateAddOrganizationCommon API operation for CERTIFICATE_SERVICE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CERTIFICATE_SERVICE's
// API operation CertificateAddOrganizationCommon for usage and error information.
func (c *CERTIFICATESERVICE) CertificateAddOrganizationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CertificateAddOrganizationCommonRequest(input)
	return out, req.Send()
}

// CertificateAddOrganizationCommonWithContext is the same as CertificateAddOrganizationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CertificateAddOrganizationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CERTIFICATESERVICE) CertificateAddOrganizationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CertificateAddOrganizationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCertificateAddOrganization = "CertificateAddOrganization"

// CertificateAddOrganizationRequest generates a "volcengine/request.Request" representing the
// client's request for the CertificateAddOrganization operation. The "output" return
// value will be populated with the CertificateAddOrganizationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CertificateAddOrganizationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CertificateAddOrganizationCommon Send returns without error.
//
// See CertificateAddOrganization for more information on using the CertificateAddOrganization
// API call, and error handling.
//
//    // Example sending a request using the CertificateAddOrganizationRequest method.
//    req, resp := client.CertificateAddOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CERTIFICATESERVICE) CertificateAddOrganizationRequest(input *CertificateAddOrganizationInput) (req *request.Request, output *CertificateAddOrganizationOutput) {
	op := &request.Operation{
		Name:       opCertificateAddOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CertificateAddOrganizationInput{}
	}

	output = &CertificateAddOrganizationOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CertificateAddOrganization API operation for CERTIFICATE_SERVICE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CERTIFICATE_SERVICE's
// API operation CertificateAddOrganization for usage and error information.
func (c *CERTIFICATESERVICE) CertificateAddOrganization(input *CertificateAddOrganizationInput) (*CertificateAddOrganizationOutput, error) {
	req, out := c.CertificateAddOrganizationRequest(input)
	return out, req.Send()
}

// CertificateAddOrganizationWithContext is the same as CertificateAddOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See CertificateAddOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CERTIFICATESERVICE) CertificateAddOrganizationWithContext(ctx volcengine.Context, input *CertificateAddOrganizationInput, opts ...request.Option) (*CertificateAddOrganizationOutput, error) {
	req, out := c.CertificateAddOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CertificateAddOrganizationInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	BusinessLicenseNo *string `type:"string" json:",omitempty"`

	City *string `type:"string" json:",omitempty"`

	Contact *ContactForCertificateAddOrganizationInput `type:"structure" json:",omitempty"`

	Country *string `type:"string" json:",omitempty"`

	Department *string `type:"string" json:",omitempty"`

	Email *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	PostalCode *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	Province *string `type:"string" json:",omitempty"`

	// Tag is a required field
	Tag *string `max:"100" type:"string" json:",omitempty" required:"true"`

	Tags []*ConvertTagForCertificateAddOrganizationInput `type:"list" json:",omitempty"`

	// Type is a required field
	Type *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfTypeForCertificateAddOrganizationInput"`
}

// String returns the string representation
func (s CertificateAddOrganizationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateAddOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateAddOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateAddOrganizationInput"}
	if s.Tag == nil {
		invalidParams.Add(request.NewErrParamRequired("Tag"))
	}
	if s.Tag != nil && len(*s.Tag) > 100 {
		invalidParams.Add(request.NewErrParamMaxLen("Tag", 100, *s.Tag))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CertificateAddOrganizationInput) SetAddress(v string) *CertificateAddOrganizationInput {
	s.Address = &v
	return s
}

// SetBusinessLicenseNo sets the BusinessLicenseNo field's value.
func (s *CertificateAddOrganizationInput) SetBusinessLicenseNo(v string) *CertificateAddOrganizationInput {
	s.BusinessLicenseNo = &v
	return s
}

// SetCity sets the City field's value.
func (s *CertificateAddOrganizationInput) SetCity(v string) *CertificateAddOrganizationInput {
	s.City = &v
	return s
}

// SetContact sets the Contact field's value.
func (s *CertificateAddOrganizationInput) SetContact(v *ContactForCertificateAddOrganizationInput) *CertificateAddOrganizationInput {
	s.Contact = v
	return s
}

// SetCountry sets the Country field's value.
func (s *CertificateAddOrganizationInput) SetCountry(v string) *CertificateAddOrganizationInput {
	s.Country = &v
	return s
}

// SetDepartment sets the Department field's value.
func (s *CertificateAddOrganizationInput) SetDepartment(v string) *CertificateAddOrganizationInput {
	s.Department = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CertificateAddOrganizationInput) SetEmail(v string) *CertificateAddOrganizationInput {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *CertificateAddOrganizationInput) SetName(v string) *CertificateAddOrganizationInput {
	s.Name = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *CertificateAddOrganizationInput) SetPostalCode(v string) *CertificateAddOrganizationInput {
	s.PostalCode = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CertificateAddOrganizationInput) SetProjectName(v string) *CertificateAddOrganizationInput {
	s.ProjectName = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *CertificateAddOrganizationInput) SetProvince(v string) *CertificateAddOrganizationInput {
	s.Province = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *CertificateAddOrganizationInput) SetTag(v string) *CertificateAddOrganizationInput {
	s.Tag = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CertificateAddOrganizationInput) SetTags(v []*ConvertTagForCertificateAddOrganizationInput) *CertificateAddOrganizationInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateAddOrganizationInput) SetType(v string) *CertificateAddOrganizationInput {
	s.Type = &v
	return s
}

type CertificateAddOrganizationOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	OrganizationId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertificateAddOrganizationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateAddOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CertificateAddOrganizationOutput) SetOrganizationId(v string) *CertificateAddOrganizationOutput {
	s.OrganizationId = &v
	return s
}

type ContactForCertificateAddOrganizationInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Email *string `type:"string" json:",omitempty"`

	FirstName *string `type:"string" json:",omitempty"`

	IdCardNo *string `type:"string" json:",omitempty"`

	LastName *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ContactForCertificateAddOrganizationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactForCertificateAddOrganizationInput) GoString() string {
	return s.String()
}

// SetEmail sets the Email field's value.
func (s *ContactForCertificateAddOrganizationInput) SetEmail(v string) *ContactForCertificateAddOrganizationInput {
	s.Email = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *ContactForCertificateAddOrganizationInput) SetFirstName(v string) *ContactForCertificateAddOrganizationInput {
	s.FirstName = &v
	return s
}

// SetIdCardNo sets the IdCardNo field's value.
func (s *ContactForCertificateAddOrganizationInput) SetIdCardNo(v string) *ContactForCertificateAddOrganizationInput {
	s.IdCardNo = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *ContactForCertificateAddOrganizationInput) SetLastName(v string) *ContactForCertificateAddOrganizationInput {
	s.LastName = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *ContactForCertificateAddOrganizationInput) SetPhone(v string) *ContactForCertificateAddOrganizationInput {
	s.Phone = &v
	return s
}

type ConvertTagForCertificateAddOrganizationInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTagForCertificateAddOrganizationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTagForCertificateAddOrganizationInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ConvertTagForCertificateAddOrganizationInput) SetKey(v string) *ConvertTagForCertificateAddOrganizationInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertTagForCertificateAddOrganizationInput) SetValue(v string) *ConvertTagForCertificateAddOrganizationInput {
	s.Value = &v
	return s
}

const (
	// EnumOfTypeForCertificateAddOrganizationInputEnterprise is a EnumOfTypeForCertificateAddOrganizationInput enum value
	EnumOfTypeForCertificateAddOrganizationInputEnterprise = "Enterprise"

	// EnumOfTypeForCertificateAddOrganizationInputIndividual is a EnumOfTypeForCertificateAddOrganizationInput enum value
	EnumOfTypeForCertificateAddOrganizationInputIndividual = "Individual"
)
