// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateHealthCheckTemplatesCommon = "CreateHealthCheckTemplates"

// CreateHealthCheckTemplatesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateHealthCheckTemplatesCommon operation. The "output" return
// value will be populated with the CreateHealthCheckTemplatesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateHealthCheckTemplatesCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateHealthCheckTemplatesCommon Send returns without error.
//
// See CreateHealthCheckTemplatesCommon for more information on using the CreateHealthCheckTemplatesCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateHealthCheckTemplatesCommonRequest method.
//    req, resp := client.CreateHealthCheckTemplatesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateHealthCheckTemplatesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateHealthCheckTemplatesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateHealthCheckTemplatesCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateHealthCheckTemplatesCommon for usage and error information.
func (c *ALB) CreateHealthCheckTemplatesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateHealthCheckTemplatesCommonRequest(input)
	return out, req.Send()
}

// CreateHealthCheckTemplatesCommonWithContext is the same as CreateHealthCheckTemplatesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHealthCheckTemplatesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateHealthCheckTemplatesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateHealthCheckTemplatesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHealthCheckTemplates = "CreateHealthCheckTemplates"

// CreateHealthCheckTemplatesRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateHealthCheckTemplates operation. The "output" return
// value will be populated with the CreateHealthCheckTemplatesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateHealthCheckTemplatesCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateHealthCheckTemplatesCommon Send returns without error.
//
// See CreateHealthCheckTemplates for more information on using the CreateHealthCheckTemplates
// API call, and error handling.
//
//    // Example sending a request using the CreateHealthCheckTemplatesRequest method.
//    req, resp := client.CreateHealthCheckTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateHealthCheckTemplatesRequest(input *CreateHealthCheckTemplatesInput) (req *request.Request, output *CreateHealthCheckTemplatesOutput) {
	op := &request.Operation{
		Name:       opCreateHealthCheckTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHealthCheckTemplatesInput{}
	}

	output = &CreateHealthCheckTemplatesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateHealthCheckTemplates API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateHealthCheckTemplates for usage and error information.
func (c *ALB) CreateHealthCheckTemplates(input *CreateHealthCheckTemplatesInput) (*CreateHealthCheckTemplatesOutput, error) {
	req, out := c.CreateHealthCheckTemplatesRequest(input)
	return out, req.Send()
}

// CreateHealthCheckTemplatesWithContext is the same as CreateHealthCheckTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHealthCheckTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateHealthCheckTemplatesWithContext(ctx volcengine.Context, input *CreateHealthCheckTemplatesInput, opts ...request.Option) (*CreateHealthCheckTemplatesOutput, error) {
	req, out := c.CreateHealthCheckTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateHealthCheckTemplatesInput struct {
	_ struct{} `type:"structure"`

	HealthCheckTemplates []*HealthCheckTemplateForCreateHealthCheckTemplatesInput `type:"list"`
}

// String returns the string representation
func (s CreateHealthCheckTemplatesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHealthCheckTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHealthCheckTemplatesInput"}
	if s.HealthCheckTemplates != nil {
		for i, v := range s.HealthCheckTemplates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HealthCheckTemplates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheckTemplates sets the HealthCheckTemplates field's value.
func (s *CreateHealthCheckTemplatesInput) SetHealthCheckTemplates(v []*HealthCheckTemplateForCreateHealthCheckTemplatesInput) *CreateHealthCheckTemplatesInput {
	s.HealthCheckTemplates = v
	return s
}

type CreateHealthCheckTemplatesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	HealthCheckTemplateIDs []*string `type:"list"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateHealthCheckTemplatesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckTemplatesOutput) GoString() string {
	return s.String()
}

// SetHealthCheckTemplateIDs sets the HealthCheckTemplateIDs field's value.
func (s *CreateHealthCheckTemplatesOutput) SetHealthCheckTemplateIDs(v []*string) *CreateHealthCheckTemplatesOutput {
	s.HealthCheckTemplateIDs = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateHealthCheckTemplatesOutput) SetRequestId(v string) *CreateHealthCheckTemplatesOutput {
	s.RequestId = &v
	return s
}

type HealthCheckTemplateForCreateHealthCheckTemplatesInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	HealthCheckDomain *string `type:"string"`

	HealthCheckHttpCode *string `type:"string"`

	HealthCheckHttpVersion *string `type:"string"`

	HealthCheckInterval *int64 `type:"integer"`

	HealthCheckMethod *string `type:"string"`

	HealthCheckProtocol *string `type:"string"`

	// HealthCheckTemplateName is a required field
	HealthCheckTemplateName *string `min:"1" max:"128" type:"string" required:"true"`

	HealthCheckTimeout *int64 `type:"integer"`

	HealthCheckURI *string `type:"string"`

	HealthyThreshold *int64 `type:"integer"`

	// Port is a required field
	Port *int64 `max:"65535" type:"integer" required:"true"`

	ProjectName *string `type:"string"`

	Tags []*HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput `type:"list"`

	UnhealthyThreshold *int64 `type:"integer"`
}

// String returns the string representation
func (s HealthCheckTemplateForCreateHealthCheckTemplatesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckTemplateForCreateHealthCheckTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckTemplateForCreateHealthCheckTemplatesInput"}
	if s.HealthCheckTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckTemplateName"))
	}
	if s.HealthCheckTemplateName != nil && len(*s.HealthCheckTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckTemplateName", 1))
	}
	if s.HealthCheckTemplateName != nil && len(*s.HealthCheckTemplateName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("HealthCheckTemplateName", 128, *s.HealthCheckTemplateName))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port > 65535 {
		invalidParams.Add(request.NewErrParamMaxValue("Port", 65535))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetDescription(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.Description = &v
	return s
}

// SetHealthCheckDomain sets the HealthCheckDomain field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckDomain(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckDomain = &v
	return s
}

// SetHealthCheckHttpCode sets the HealthCheckHttpCode field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckHttpCode(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckHttpCode = &v
	return s
}

// SetHealthCheckHttpVersion sets the HealthCheckHttpVersion field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckHttpVersion(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckHttpVersion = &v
	return s
}

// SetHealthCheckInterval sets the HealthCheckInterval field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckInterval(v int64) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckInterval = &v
	return s
}

// SetHealthCheckMethod sets the HealthCheckMethod field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckMethod(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckMethod = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckProtocol(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckProtocol = &v
	return s
}

// SetHealthCheckTemplateName sets the HealthCheckTemplateName field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckTemplateName(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckTemplateName = &v
	return s
}

// SetHealthCheckTimeout sets the HealthCheckTimeout field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckTimeout(v int64) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckTimeout = &v
	return s
}

// SetHealthCheckURI sets the HealthCheckURI field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthCheckURI(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthCheckURI = &v
	return s
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetHealthyThreshold(v int64) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.HealthyThreshold = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetPort(v int64) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.Port = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetProjectName(v string) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetTags(v []*HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.Tags = v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckTemplateForCreateHealthCheckTemplatesInput) SetUnhealthyThreshold(v int64) *HealthCheckTemplateForCreateHealthCheckTemplatesInput {
	s.UnhealthyThreshold = &v
	return s
}

type HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) SetKey(v string) *HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput) SetValue(v string) *HealthCheckTemplatesTagForCreateHealthCheckTemplatesInput {
	s.Value = &v
	return s
}
