// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateVpc() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	createVpcInput := &vpc.CreateVpcInput{
		CidrBlock: volcengine.String("172.XX.XX.0/12"),
		VpcName:   volcengine.String("vpc-1"),
	}

	resp, err := svc.CreateVpc(createVpcInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
