package webapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/web/mgmt/2015-08-01-preview/web"
	"github.com/Azure/go-autorest/autorest"
)

// CertificateOrdersClientAPI contains the set of methods on the CertificateOrdersClient type.
type CertificateOrdersClientAPI interface {
	CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.CertificateOrderCertificate) (result web.CertificateOrderCertificate, err error)
	CreateOrUpdateCertificateOrder(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName web.CertificateOrder) (result web.CertificateOrder, err error)
	DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result web.SetObject, err error)
	DeleteCertificateOrder(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result web.CertificateOrderCertificate, err error)
	GetCertificateOrder(ctx context.Context, resourceGroupName string, name string) (result web.CertificateOrder, err error)
	GetCertificateOrders(ctx context.Context, resourceGroupName string) (result web.CertificateOrderCollectionPage, err error)
	GetCertificates(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.CertificateOrderCertificateCollectionPage, err error)
	ReissueCertificateOrder(ctx context.Context, resourceGroupName string, name string, reissueCertificateOrderRequest web.ReissueCertificateOrderRequest) (result web.SetObject, err error)
	RenewCertificateOrder(ctx context.Context, resourceGroupName string, name string, renewCertificateOrderRequest web.RenewCertificateOrderRequest) (result web.SetObject, err error)
	ResendCertificateEmail(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateOrderAction, err error)
	RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateEmail, err error)
	UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.CertificateOrderCertificate) (result web.CertificateOrderCertificate, err error)
	UpdateCertificateOrder(ctx context.Context, resourceGroupName string, name string, certificateDistinguishedName web.CertificateOrder) (result web.CertificateOrder, err error)
	VerifyDomainOwnership(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
}

var _ CertificateOrdersClientAPI = (*web.CertificateOrdersClient)(nil)

// CertificatesClientAPI contains the set of methods on the CertificatesClient type.
type CertificatesClientAPI interface {
	CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.Certificate) (result web.Certificate, err error)
	CreateOrUpdateCsr(ctx context.Context, resourceGroupName string, name string, csrEnvelope web.Csr) (result web.Csr, err error)
	DeleteCertificate(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	DeleteCsr(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetCertificate(ctx context.Context, resourceGroupName string, name string) (result web.Certificate, err error)
	GetCertificates(ctx context.Context, resourceGroupName string) (result web.CertificateCollectionPage, err error)
	GetCsr(ctx context.Context, resourceGroupName string, name string) (result web.Csr, err error)
	GetCsrs(ctx context.Context, resourceGroupName string) (result web.ListCsr, err error)
	UpdateCertificate(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.Certificate) (result web.Certificate, err error)
	UpdateCsr(ctx context.Context, resourceGroupName string, name string, csrEnvelope web.Csr) (result web.Csr, err error)
}

var _ CertificatesClientAPI = (*web.CertificatesClient)(nil)

// ClassicMobileServicesClientAPI contains the set of methods on the ClassicMobileServicesClient type.
type ClassicMobileServicesClientAPI interface {
	DeleteClassicMobileService(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetClassicMobileService(ctx context.Context, resourceGroupName string, name string) (result web.ClassicMobileService, err error)
	GetClassicMobileServices(ctx context.Context, resourceGroupName string) (result web.ClassicMobileServiceCollectionPage, err error)
}

var _ ClassicMobileServicesClientAPI = (*web.ClassicMobileServicesClient)(nil)

// DomainsClientAPI contains the set of methods on the DomainsClient type.
type DomainsClientAPI interface {
	CreateOrUpdateDomain(ctx context.Context, resourceGroupName string, domainName string, domain web.Domain) (result web.Domain, err error)
	DeleteDomain(ctx context.Context, resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (result web.SetObject, err error)
	GetDomain(ctx context.Context, resourceGroupName string, domainName string) (result web.Domain, err error)
	GetDomainOperation(ctx context.Context, resourceGroupName string, domainName string, operationID string) (result web.Domain, err error)
	GetDomains(ctx context.Context, resourceGroupName string) (result web.DomainCollectionPage, err error)
	UpdateDomain(ctx context.Context, resourceGroupName string, domainName string, domain web.Domain) (result web.Domain, err error)
}

var _ DomainsClientAPI = (*web.DomainsClient)(nil)

// GlobalClientAPI contains the set of methods on the GlobalClient type.
type GlobalClientAPI interface {
	CheckNameAvailability(ctx context.Context, request web.ResourceNameAvailabilityRequest) (result web.ResourceNameAvailability, err error)
	GetAllCertificates(ctx context.Context) (result web.CertificateCollectionPage, err error)
	GetAllClassicMobileServices(ctx context.Context) (result web.ClassicMobileServiceCollectionPage, err error)
	GetAllHostingEnvironments(ctx context.Context) (result web.HostingEnvironmentCollectionPage, err error)
	GetAllManagedHostingEnvironments(ctx context.Context) (result web.ManagedHostingEnvironmentCollectionPage, err error)
	GetAllServerFarms(ctx context.Context, detailed *bool) (result web.ServerFarmCollectionPage, err error)
	GetAllSites(ctx context.Context) (result web.SiteCollectionPage, err error)
	GetSubscriptionGeoRegions(ctx context.Context, sku string, linuxWorkersEnabled *bool) (result web.GeoRegionCollectionPage, err error)
	GetSubscriptionPublishingCredentials(ctx context.Context) (result web.User, err error)
	IsHostingEnvironmentNameAvailable(ctx context.Context, name string) (result web.SetObject, err error)
	IsHostingEnvironmentWithLegacyNameAvailable(ctx context.Context, name string) (result web.SetObject, err error)
	ListPremierAddOnOffers(ctx context.Context) (result web.SetObject, err error)
	UpdateSubscriptionPublishingCredentials(ctx context.Context, requestMessage web.User) (result web.User, err error)
}

var _ GlobalClientAPI = (*web.GlobalClient)(nil)

// GlobalCertificateOrderClientAPI contains the set of methods on the GlobalCertificateOrderClient type.
type GlobalCertificateOrderClientAPI interface {
	GetAllCertificateOrders(ctx context.Context) (result web.CertificateOrderCollectionPage, err error)
	ValidateCertificatePurchaseInformation(ctx context.Context, certificateOrder web.CertificateOrder) (result web.SetObject, err error)
}

var _ GlobalCertificateOrderClientAPI = (*web.GlobalCertificateOrderClient)(nil)

// GlobalDomainRegistrationClientAPI contains the set of methods on the GlobalDomainRegistrationClient type.
type GlobalDomainRegistrationClientAPI interface {
	CheckDomainAvailability(ctx context.Context, identifier web.NameIdentifier) (result web.DomainAvailablilityCheckResult, err error)
	GetAllDomains(ctx context.Context) (result web.DomainCollectionPage, err error)
	GetDomainControlCenterSsoRequest(ctx context.Context) (result web.DomainControlCenterSsoRequest, err error)
	ListDomainRecommendations(ctx context.Context, parameters web.DomainRecommendationSearchParameters) (result web.NameIdentifierCollectionPage, err error)
	ValidateDomainPurchaseInformation(ctx context.Context, domainRegistrationInput web.DomainRegistrationInput) (result web.SetObject, err error)
}

var _ GlobalDomainRegistrationClientAPI = (*web.GlobalDomainRegistrationClient)(nil)

// GlobalResourceGroupsClientAPI contains the set of methods on the GlobalResourceGroupsClient type.
type GlobalResourceGroupsClientAPI interface {
	MoveResources(ctx context.Context, resourceGroupName string, moveResourceEnvelope web.CsmMoveResourceEnvelope) (result autorest.Response, err error)
}

var _ GlobalResourceGroupsClientAPI = (*web.GlobalResourceGroupsClient)(nil)

// HostingEnvironmentsClientAPI contains the set of methods on the HostingEnvironmentsClient type.
type HostingEnvironmentsClientAPI interface {
	CreateOrUpdateHostingEnvironment(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope web.HostingEnvironment) (result web.HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture, err error)
	CreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope web.WorkerPool) (result web.HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error)
	CreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope web.WorkerPool) (result web.HostingEnvironmentsCreateOrUpdateWorkerPoolFuture, err error)
	DeleteHostingEnvironment(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result web.HostingEnvironmentsDeleteHostingEnvironmentFuture, err error)
	GetHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result web.HostingEnvironment, err error)
	GetHostingEnvironmentCapacities(ctx context.Context, resourceGroupName string, name string) (result web.StampCapacityCollectionPage, err error)
	GetHostingEnvironmentDiagnostics(ctx context.Context, resourceGroupName string, name string) (result web.ListHostingEnvironmentDiagnostics, err error)
	GetHostingEnvironmentDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (result web.HostingEnvironmentDiagnostics, err error)
	GetHostingEnvironmentMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.MetricDefinition, err error)
	GetHostingEnvironmentMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetHostingEnvironmentMultiRoleMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.MetricDefinitionCollectionPage, err error)
	GetHostingEnvironmentMultiRoleMetrics(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetHostingEnvironmentMultiRoleUsages(ctx context.Context, resourceGroupName string, name string) (result web.UsageCollectionPage, err error)
	GetHostingEnvironmentOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.SetObject, err error)
	GetHostingEnvironmentOperations(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetHostingEnvironments(ctx context.Context, resourceGroupName string) (result web.HostingEnvironmentCollectionPage, err error)
	GetHostingEnvironmentServerFarms(ctx context.Context, resourceGroupName string, name string) (result web.ServerFarmCollectionPage, err error)
	GetHostingEnvironmentSites(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.SiteCollectionPage, err error)
	GetHostingEnvironmentUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	GetHostingEnvironmentVips(ctx context.Context, resourceGroupName string, name string) (result web.AddressResponse, err error)
	GetHostingEnvironmentWebHostingPlans(ctx context.Context, resourceGroupName string, name string) (result web.ServerFarmCollectionPage, err error)
	GetHostingEnvironmentWebWorkerMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.MetricDefinitionCollectionPage, err error)
	GetHostingEnvironmentWebWorkerMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetHostingEnvironmentWebWorkerUsages(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.UsageCollectionPage, err error)
	GetMultiRolePool(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPool, err error)
	GetMultiRolePoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, instance string) (result web.SetObject, err error)
	GetMultiRolePoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (result web.SetObject, err error)
	GetMultiRolePools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	GetMultiRolePoolSkus(ctx context.Context, resourceGroupName string, name string) (result web.SkuInfoCollectionPage, err error)
	GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.WorkerPool, err error)
	GetWorkerPoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result web.SetObject, err error)
	GetWorkerPoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result web.SetObject, err error)
	GetWorkerPools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	GetWorkerPoolSkus(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.SkuInfoCollectionPage, err error)
	RebootHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	ResumeHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result web.HostingEnvironmentsResumeHostingEnvironmentFuture, err error)
	SuspendHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result web.HostingEnvironmentsSuspendHostingEnvironmentFuture, err error)
}

var _ HostingEnvironmentsClientAPI = (*web.HostingEnvironmentsClient)(nil)

// ManagedHostingEnvironmentsClientAPI contains the set of methods on the ManagedHostingEnvironmentsClient type.
type ManagedHostingEnvironmentsClientAPI interface {
	CreateOrUpdateManagedHostingEnvironment(ctx context.Context, resourceGroupName string, name string, managedHostingEnvironmentEnvelope web.HostingEnvironment) (result web.ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture, err error)
	DeleteManagedHostingEnvironment(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result web.ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture, err error)
	GetManagedHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result web.ManagedHostingEnvironment, err error)
	GetManagedHostingEnvironmentOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.SetObject, err error)
	GetManagedHostingEnvironments(ctx context.Context, resourceGroupName string) (result web.HostingEnvironmentCollectionPage, err error)
	GetManagedHostingEnvironmentServerFarms(ctx context.Context, resourceGroupName string, name string) (result web.ServerFarmCollectionPage, err error)
	GetManagedHostingEnvironmentSites(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.SiteCollectionPage, err error)
	GetManagedHostingEnvironmentVips(ctx context.Context, resourceGroupName string, name string) (result web.AddressResponse, err error)
	GetManagedHostingEnvironmentWebHostingPlans(ctx context.Context, resourceGroupName string, name string) (result web.ServerFarmCollectionPage, err error)
}

var _ ManagedHostingEnvironmentsClientAPI = (*web.ManagedHostingEnvironmentsClient)(nil)

// ProviderClientAPI contains the set of methods on the ProviderClient type.
type ProviderClientAPI interface {
	GetPublishingUser(ctx context.Context) (result web.User, err error)
	GetSourceControl(ctx context.Context, sourceControlType string) (result web.SourceControl, err error)
	GetSourceControls(ctx context.Context) (result web.SourceControlCollectionPage, err error)
	UpdatePublishingUser(ctx context.Context, requestMessage web.User) (result web.User, err error)
	UpdateSourceControl(ctx context.Context, sourceControlType string, requestMessage web.SourceControl) (result web.SourceControl, err error)
}

var _ ProviderClientAPI = (*web.ProviderClient)(nil)

// RecommendationsClientAPI contains the set of methods on the RecommendationsClient type.
type RecommendationsClientAPI interface {
	GetRecommendationBySubscription(ctx context.Context, featured *bool, filter string) (result web.ListRecommendation, err error)
	GetRecommendationHistoryForSite(ctx context.Context, resourceGroupName string, siteName string, startTime string, endTime string) (result web.ListRecommendation, err error)
	GetRecommendedRulesForSite(ctx context.Context, resourceGroupName string, siteName string, featured *bool, siteSku string, numSlots *int32) (result web.ListRecommendation, err error)
	GetRuleDetailsBySiteName(ctx context.Context, resourceGroupName string, siteName string, name string) (result web.RecommendationRule, err error)
}

var _ RecommendationsClientAPI = (*web.RecommendationsClient)(nil)

// ServerFarmsClientAPI contains the set of methods on the ServerFarmsClient type.
type ServerFarmsClientAPI interface {
	CreateOrUpdateServerFarm(ctx context.Context, resourceGroupName string, name string, serverFarmEnvelope web.ServerFarmWithRichSku, allowPendingState *bool) (result web.ServerFarmsCreateOrUpdateServerFarmFuture, err error)
	CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
	DeleteServerFarm(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result web.SetObject, err error)
	GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result web.ListVnetRoute, err error)
	GetRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.ListVnetRoute, err error)
	GetServerFarm(ctx context.Context, resourceGroupName string, name string) (result web.ServerFarmWithRichSku, err error)
	GetServerFarmMetricDefintions(ctx context.Context, resourceGroupName string, name string) (result web.MetricDefinitionCollectionPage, err error)
	GetServerFarmMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetServerFarmOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ServerFarmWithRichSku, err error)
	GetServerFarms(ctx context.Context, resourceGroupName string) (result web.ServerFarmCollectionPage, err error)
	GetServerFarmSites(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result web.SiteCollectionPage, err error)
	GetServerFarmVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.VnetGateway, err error)
	GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetVnetsForServerFarm(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	RebootWorkerForServerFarm(ctx context.Context, resourceGroupName string, name string, workerName string) (result web.SetObject, err error)
	RestartSitesForServerFarm(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (result web.SetObject, err error)
	UpdateServerFarmVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
}

var _ ServerFarmsClientAPI = (*web.ServerFarmsClient)(nil)

// SitesClientAPI contains the set of methods on the SitesClient type.
type SitesClientAPI interface {
	AddSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnRequest) (result web.SetObject, err error)
	AddSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnRequest, slot string) (result web.SetObject, err error)
	ApplySlotConfigSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SetObject, err error)
	ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SetObject, err error)
	BackupSite(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupItem, err error)
	BackupSiteSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	CreateDeployment(ctx context.Context, resourceGroupName string, name string, ID string, deployment web.Deployment) (result web.Deployment, err error)
	CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment web.Deployment) (result web.Deployment, err error)
	CreateInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string, deployment web.Deployment) (result web.Deployment, err error)
	CreateInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string, deployment web.Deployment) (result web.Deployment, err error)
	CreateOrUpdateSite(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (result web.SitesCreateOrUpdateSiteFuture, err error)
	CreateOrUpdateSiteConfig(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfig) (result web.SiteConfig, err error)
	CreateOrUpdateSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfig, slot string) (result web.SiteConfig, err error)
	CreateOrUpdateSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding) (result web.HostNameBinding, err error)
	CreateOrUpdateSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding, slot string) (result web.HostNameBinding, err error)
	CreateOrUpdateSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateSiteSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site, slot string, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (result web.SitesCreateOrUpdateSiteSlotFuture, err error)
	CreateOrUpdateSiteSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.SiteSourceControl, err error)
	CreateOrUpdateSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.SiteSourceControl, err error)
	CreateOrUpdateSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	CreateOrUpdateSiteVNETConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	CreateOrUpdateSiteVNETConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	CreateOrUpdateSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
	DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string) (result web.BackupItem, err error)
	DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result web.BackupItem, err error)
	DeleteDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result web.SetObject, err error)
	DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.SetObject, err error)
	DeleteInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (result web.SetObject, err error)
	DeleteInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (result web.SetObject, err error)
	DeleteSite(ctx context.Context, resourceGroupName string, name string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result web.SetObject, err error)
	DeleteSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.SetObject, err error)
	DeleteSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.SetObject, err error)
	DeleteSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result web.SetObject, err error)
	DeleteSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result web.SetObject, err error)
	DeleteSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result web.SetObject, err error)
	DeleteSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result web.SetObject, err error)
	DeleteSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result web.SetObject, err error)
	DeleteSiteSourceControl(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	DeleteSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	DeleteSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.SetObject, err error)
	DeleteSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result web.SetObject, err error)
	DiscoverSiteRestore(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest) (result web.RestoreRequest, err error)
	DiscoverSiteRestoreSlot(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest, slot string) (result web.RestoreRequest, err error)
	GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	GetDeletedSites(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (result web.DeletedSiteCollectionPage, err error)
	GetDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result web.Deployment, err error)
	GetDeployments(ctx context.Context, resourceGroupName string, name string) (result web.DeploymentCollectionPage, err error)
	GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.Deployment, err error)
	GetDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.DeploymentCollectionPage, err error)
	GetInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (result web.Deployment, err error)
	GetInstanceDeployments(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.DeploymentCollectionPage, err error)
	GetInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (result web.Deployment, err error)
	GetInstanceDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.DeploymentCollectionPage, err error)
	GetSite(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.Site, err error)
	GetSiteBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.BackupRequest, err error)
	GetSiteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupRequest, err error)
	GetSiteBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string) (result web.BackupItem, err error)
	GetSiteBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest) (result web.BackupItem, err error)
	GetSiteBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	GetSiteBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result web.BackupItem, err error)
	GetSiteConfig(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfig, err error)
	GetSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfig, err error)
	GetSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.HostNameBinding, err error)
	GetSiteHostNameBindings(ctx context.Context, resourceGroupName string, name string) (result web.HostNameBindingCollectionPage, err error)
	GetSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.HostNameBinding, err error)
	GetSiteHostNameBindingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HostNameBindingCollectionPage, err error)
	GetSiteInstanceIdentifiers(ctx context.Context, resourceGroupName string, name string) (result web.SiteInstanceCollectionPage, err error)
	GetSiteInstanceIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteInstanceCollectionPage, err error)
	GetSiteLogsConfig(ctx context.Context, resourceGroupName string, name string) (result web.SiteLogsConfig, err error)
	GetSiteLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteLogsConfig, err error)
	GetSiteMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.MetricDefinitionCollectionPage, err error)
	GetSiteMetricDefinitionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MetricDefinitionCollectionPage, err error)
	GetSiteMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetSiteMetricsSlot(ctx context.Context, resourceGroupName string, name string, slot string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	GetSiteNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string) (result web.NetworkFeatures, err error)
	GetSiteNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string) (result web.NetworkFeatures, err error)
	GetSiteOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.SetObject, err error)
	GetSiteOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.SetObject, err error)
	GetSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result web.SetObject, err error)
	GetSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result web.SetObject, err error)
	GetSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result web.RelayServiceConnectionEntity, err error)
	GetSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result web.RelayServiceConnectionEntity, err error)
	GetSites(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (result web.SiteCollectionPage, err error)
	GetSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, propertiesToInclude string) (result web.Site, err error)
	GetSiteSlots(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.SiteCollectionPage, err error)
	GetSiteSnapshots(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetSiteSnapshotsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	GetSiteSourceControl(ctx context.Context, resourceGroupName string, name string) (result web.SiteSourceControl, err error)
	GetSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteSourceControl, err error)
	GetSiteUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	GetSiteUsagesSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	GetSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetSiteVNETConnections(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	GetSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result web.VnetInfo, err error)
	GetSiteVNETConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ListVnetInfo, err error)
	GetSiteVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.SetObject, err error)
	GetSiteVnetGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result web.SetObject, err error)
	GetSlotConfigNames(ctx context.Context, resourceGroupName string, name string) (result web.SlotConfigNamesResource, err error)
	GetSlotsDifferencesFromProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SlotDifferenceCollectionPage, err error)
	GetSlotsDifferencesSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SlotDifferenceCollectionPage, err error)
	IsSiteCloneable(ctx context.Context, resourceGroupName string, name string) (result web.SiteCloneability, err error)
	IsSiteCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteCloneability, err error)
	ListSiteAppSettings(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListSiteAppSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListSiteAuthSettings(ctx context.Context, resourceGroupName string, name string) (result web.SiteAuthSettings, err error)
	ListSiteAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteAuthSettings, err error)
	ListSiteBackups(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionPage, err error)
	ListSiteBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionPage, err error)
	ListSiteConnectionStrings(ctx context.Context, resourceGroupName string, name string) (result web.ConnectionStringDictionary, err error)
	ListSiteConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ConnectionStringDictionary, err error)
	ListSiteMetadata(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListSiteMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListSitePremierAddOns(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	ListSitePremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	ListSitePublishingCredentials(ctx context.Context, resourceGroupName string, name string) (result web.SitesListSitePublishingCredentialsFuture, err error)
	ListSitePublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SitesListSitePublishingCredentialsSlotFuture, err error)
	ListSitePublishingProfileXML(ctx context.Context, resourceGroupName string, name string, options web.CsmPublishingProfileOptions) (result web.ReadCloser, err error)
	ListSitePublishingProfileXMLSlot(ctx context.Context, resourceGroupName string, name string, options web.CsmPublishingProfileOptions, slot string) (result web.ReadCloser, err error)
	ListSiteRelayServiceConnections(ctx context.Context, resourceGroupName string, name string) (result web.RelayServiceConnectionEntity, err error)
	ListSiteRelayServiceConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.RelayServiceConnectionEntity, err error)
	RecoverSite(ctx context.Context, resourceGroupName string, name string, recoveryEntity web.CsmSiteRecoveryEntity) (result web.SitesRecoverSiteFuture, err error)
	RecoverSiteSlot(ctx context.Context, resourceGroupName string, name string, recoveryEntity web.CsmSiteRecoveryEntity, slot string) (result web.SitesRecoverSiteSlotFuture, err error)
	ResetProductionSlotConfig(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	ResetSlotConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	RestartSite(ctx context.Context, resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result web.SetObject, err error)
	RestartSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result web.SetObject, err error)
	RestoreSite(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest) (result web.SitesRestoreSiteFuture, err error)
	RestoreSiteSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest, slot string) (result web.SitesRestoreSiteSlotFuture, err error)
	StartSite(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	StartSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	StopSite(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	StopSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	SwapSlotsSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SitesSwapSlotsSlotFuture, err error)
	SwapSlotWithProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SitesSwapSlotWithProductionFuture, err error)
	SyncSiteRepository(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	SyncSiteRepositorySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SetObject, err error)
	UpdateSiteAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	UpdateSiteAppSettingsSlot(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdateSiteAuthSettings(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings) (result web.SiteAuthSettings, err error)
	UpdateSiteAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings, slot string) (result web.SiteAuthSettings, err error)
	UpdateSiteBackupConfiguration(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupRequest, err error)
	UpdateSiteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupRequest, err error)
	UpdateSiteConfig(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfig) (result web.SiteConfig, err error)
	UpdateSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfig, slot string) (result web.SiteConfig, err error)
	UpdateSiteConnectionStrings(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary) (result web.ConnectionStringDictionary, err error)
	UpdateSiteConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary, slot string) (result web.ConnectionStringDictionary, err error)
	UpdateSiteLogsConfig(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig) (result web.SiteLogsConfig, err error)
	UpdateSiteLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig, slot string) (result web.SiteLogsConfig, err error)
	UpdateSiteMetadata(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary) (result web.StringDictionary, err error)
	UpdateSiteMetadataSlot(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdateSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	UpdateSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	UpdateSiteSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.SiteSourceControl, err error)
	UpdateSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.SiteSourceControl, err error)
	UpdateSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	UpdateSiteVNETConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateSiteVNETConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	UpdateSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
	UpdateSlotConfigNames(ctx context.Context, resourceGroupName string, name string, slotConfigNames web.SlotConfigNamesResource) (result web.SlotConfigNamesResource, err error)
}

var _ SitesClientAPI = (*web.SitesClient)(nil)

// TopLevelDomainsClientAPI contains the set of methods on the TopLevelDomainsClient type.
type TopLevelDomainsClientAPI interface {
	GetGetTopLevelDomains(ctx context.Context) (result web.TopLevelDomainCollectionPage, err error)
	GetTopLevelDomain(ctx context.Context, name string) (result web.TopLevelDomain, err error)
	ListTopLevelDomainAgreements(ctx context.Context, name string, agreementOption web.TopLevelDomainAgreementOption) (result web.TldLegalAgreementCollectionPage, err error)
}

var _ TopLevelDomainsClientAPI = (*web.TopLevelDomainsClient)(nil)

// UsageClientAPI contains the set of methods on the UsageClient type.
type UsageClientAPI interface {
	GetUsage(ctx context.Context, resourceGroupName string, environmentName string, lastID string, batchSize int32) (result web.SetObject, err error)
}

var _ UsageClientAPI = (*web.UsageClient)(nil)

// ManagedApisClientAPI contains the set of methods on the ManagedApisClient type.
type ManagedApisClientAPI interface {
	Get(ctx context.Context, location string, APIName string, export *bool) (result web.APIEntity, err error)
	List(ctx context.Context, location string) (result web.ApisCollectionPage, err error)
}

var _ ManagedApisClientAPI = (*web.ManagedApisClient)(nil)

// ConnectionsClientAPI contains the set of methods on the ConnectionsClient type.
type ConnectionsClientAPI interface {
	ConfirmConsentCode(ctx context.Context, resourceGroupName string, connectionName string, content web.ConfirmConsentCodeInput) (result web.Connection, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, connectionName string, connection web.Connection) (result web.Connection, err error)
	Delete(ctx context.Context, resourceGroupName string, connectionName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, connectionName string) (result web.Connection, err error)
	List(ctx context.Context, resourceGroupName string, top *int32, filter string) (result web.ConnectionCollectionPage, err error)
	ListConnectionKeys(ctx context.Context, resourceGroupName string, connectionName string, content web.ListConnectionKeysInput) (result web.ConnectionSecrets, err error)
	ListConsentLinks(ctx context.Context, resourceGroupName string, connectionName string, content web.ConsentLinkInput) (result web.ConsentLinkPayload, err error)
}

var _ ConnectionsClientAPI = (*web.ConnectionsClient)(nil)
