; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define float @fdiv_constant_fold() {
; CHECK-LABEL: @fdiv_constant_fold(
; CHECK-NEXT:    ret float 1.500000e+00
;
  %f = fdiv float 3.0, 2.0
  ret float %f
}

define float @frem_constant_fold() {
; CHECK-LABEL: @frem_constant_fold(
; CHECK-NEXT:    ret float 1.000000e+00
;
  %f = frem float 3.0, 2.0
  ret float %f
}

define double @fmul_fdiv_common_operand(double %x, double %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %m = fmul double %x, %y
  %d = fdiv reassoc nnan double %m, %y
  ret double %d
}

; Negative test - the fdiv must be reassociative and not allow NaNs.

define double @fmul_fdiv_common_operand_too_strict(double %x, double %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand_too_strict(
; CHECK-NEXT:    [[M:%.*]] = fmul fast double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = fdiv reassoc double [[M]], [[Y]]
; CHECK-NEXT:    ret double [[D]]
;
  %m = fmul fast double %x, %y
  %d = fdiv reassoc double %m, %y
  ret double %d
}

; Commute the fmul operands. Use a vector type to verify that works too.

define <2 x float> @fmul_fdiv_common_operand_commute_vec(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand_commute_vec(
; CHECK-NEXT:    ret <2 x float> [[X:%.*]]
;
  %m = fmul <2 x float> %y, %x
  %d = fdiv fast <2 x float> %m, %y
  ret <2 x float> %d
}

; The constant expression version of this used to crash llvm-as.
define <2 x i1> @pr6096() {
; CHECK-LABEL: @pr6096(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %fdiv = fdiv <2 x float> undef, <float 1.000000e+00, float 1.000000e+00>
  %fcmp = fcmp ole <2 x float> %fdiv, zeroinitializer
  ret <2 x i1> %fcmp
}


; https://alive2.llvm.org/ce/z/JxX5in
define float @fdiv_nnan_ninf_by_zero_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_zero_f32(
; CHECK-NEXT:    ret float poison
;
  %fdiv = fdiv nnan ninf float %x, 0.0
  ret float %fdiv
}

define float @fdiv_nnan_ninf_by_negzero_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_negzero_f32(
; CHECK-NEXT:    ret float poison
;
  %fdiv = fdiv nnan ninf float %x, -0.0
  ret float %fdiv
}

define float @fdiv_nnan_ninf_by_undef_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_undef_f32(
; CHECK-NEXT:    ret float poison
;
  %fdiv = fdiv nnan ninf float %x, undef
  ret float %fdiv
}

define float @fdiv_nnan_ninf_by_poison_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_poison_f32(
; CHECK-NEXT:    ret float poison
;
  %fdiv = fdiv nnan ninf float %x, poison
  ret float %fdiv
}

define <2 x float> @fdiv_nnan_ninf_by_zero_v2f32(<2 x float> %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_zero_v2f32(
; CHECK-NEXT:    ret <2 x float> poison
;
  %fdiv = fdiv nnan ninf <2 x float> %x, zeroinitializer
  ret <2 x float> %fdiv
}

define <2 x float> @fdiv_nnan_ninf_by_undef_v2f32(<2 x float> %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_undef_v2f32(
; CHECK-NEXT:    ret <2 x float> poison
;
  %fdiv = fdiv nnan ninf <2 x float> %x, undef
  ret <2 x float> %fdiv
}

define <2 x float> @fdiv_nnan_ninf_by_zero_poison_v2f32(<2 x float> %x) {
; CHECK-LABEL: @fdiv_nnan_ninf_by_zero_poison_v2f32(
; CHECK-NEXT:    ret <2 x float> poison
;
  %fdiv = fdiv nnan ninf <2 x float> %x, <float 0.0, float poison>
  ret <2 x float> %fdiv
}

; https://alive2.llvm.org/ce/z/wRV28p
define float @fdiv_nnan_nsz_ninf_by_zero_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_nsz_ninf_by_zero_f32(
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv nnan nsz float [[X:%.*]], 0.000000e+00
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv nnan nsz float %x, 0.0
  ret float %fdiv
}

define float @fdiv_nnan_nsz_ninf_by_negzero_f32(float %x) {
; CHECK-LABEL: @fdiv_nnan_nsz_ninf_by_negzero_f32(
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv nnan nsz float [[X:%.*]], -0.000000e+00
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv nnan nsz float %x, -0.0
  ret float %fdiv
}

define <2 x float> @fdiv_nnan_nsz_ninf_by_zero_v2f32(<2 x float> %x) {
; CHECK-LABEL: @fdiv_nnan_nsz_ninf_by_zero_v2f32(
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv nnan nsz <2 x float> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x float> [[FDIV]]
;
  %fdiv = fdiv nnan nsz <2 x float> %x, zeroinitializer
  ret <2 x float> %fdiv
}

define <2 x float> @fdiv_nnan_nsz_ninf_by_negzero_v2f32(<2 x float> %x) {
; CHECK-LABEL: @fdiv_nnan_nsz_ninf_by_negzero_v2f32(
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv nnan nsz <2 x float> [[X:%.*]], <float -0.000000e+00, float -0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[FDIV]]
;
  %fdiv = fdiv nnan nsz <2 x float> %x, <float -0.0, float -0.0>
  ret <2 x float> %fdiv
}
