; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=riscv32 -mattr=+m -mattr=+xcvalu -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

declare i32 @llvm.abs.i32(i32, i1)
declare i32 @llvm.smin.i32(i32, i32)
declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.umin.i32(i32, i32)
declare i32 @llvm.umax.i32(i32, i32)

define i32 @abs(i32 %a) {
; CHECK-LABEL: abs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.abs a0, a0
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.abs.i32(i32 %a, i1 false)
  ret i32 %1
}

define i1 @slet(i32 %a, i32 %b) {
; CHECK-LABEL: slet:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.slet a0, a0, a1
; CHECK-NEXT:    ret
  %1 = icmp sle i32 %a, %b
  ret i1 %1
}

define i1 @sletu(i32 %a, i32 %b) {
; CHECK-LABEL: sletu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sletu a0, a0, a1
; CHECK-NEXT:    ret
  %1 = icmp ule i32 %a, %b
  ret i1 %1
}

define i32 @smin(i32 %a, i32 %b) {
; CHECK-LABEL: smin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.min a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.smin.i32(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @umin(i32 %a, i32 %b) {
; CHECK-LABEL: umin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.minu a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.umin.i32(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @smax(i32 %a, i32 %b) {
; CHECK-LABEL: smax:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.max a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.smax.i32(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @umax(i32 %a, i32 %b) {
; CHECK-LABEL: umax:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.maxu a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.umax.i32(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @exths(i16 %a) {
; CHECK-LABEL: exths:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $x11 killed $x10
; CHECK-NEXT:    cv.exths a0, a0
; CHECK-NEXT:    ret
  %1 = sext i16 %a to i32
  ret i32 %1
}

define i32 @exthz(i16 %a) {
; CHECK-LABEL: exthz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $x11 killed $x10
; CHECK-NEXT:    cv.exthz a0, a0
; CHECK-NEXT:    ret
  %1 = zext i16 %a to i32
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.clip(i32, i32)

define i32 @test.cv.alu.clip.case.a(i32 %a) {
; CHECK-LABEL: test.cv.alu.clip.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.clip a0, a0, 5
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.clip(i32 %a, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.clip.case.b(i32 %a) {
; CHECK-LABEL: test.cv.alu.clip.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 10
; CHECK-NEXT:    cv.clipr a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.clip(i32 %a, i32 10)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.clipu(i32, i32)

define i32 @test.cv.alu.clipu.case.a(i32 %a) {
; CHECK-LABEL: test.cv.alu.clipu.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.clipu a0, a0, 9
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.clipu(i32 %a, i32 255)
  ret i32 %1
}

define i32 @test.cv.alu.clipu.case.b(i32 %a) {
; CHECK-LABEL: test.cv.alu.clipu.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 200
; CHECK-NEXT:    cv.clipur a0, a0, a1
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.clipu(i32 %a, i32 200)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.addn(i32, i32, i32)

define i32 @test.cv.alu.addn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.addn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.addn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.addnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.addun(i32, i32, i32)

define i32 @test.cv.alu.addun.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addun.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.addun a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addun(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.addun.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addun.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.addunr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addun(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.addrn(i32, i32, i32)

define i32 @test.cv.alu.addrn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addrn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.addrn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addrn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.addrn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addrn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.addrnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addrn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.addurn(i32, i32, i32)

define i32 @test.cv.alu.addurn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addurn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.addurn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addurn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.addurn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.addurn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.addurnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.addurn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.subn(i32, i32, i32)

define i32 @test.cv.alu.subn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.subn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.subn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.subnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.subun(i32, i32, i32)

define i32 @test.cv.alu.subun.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subun.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.subun a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subun(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.subun.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subun.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.subunr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subun(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.subrn(i32, i32, i32)

define i32 @test.cv.alu.subrn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subrn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.subrn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subrn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.subrn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.subrn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.subrnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.subrn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}

declare i32 @llvm.riscv.cv.alu.suburn(i32, i32, i32)

define i32 @test.cv.alu.suburn.case.a(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.suburn.case.a:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.suburn a0, a0, a1, 15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.suburn(i32 %a, i32 %b, i32 15)
  ret i32 %1
}

define i32 @test.cv.alu.suburn.case.b(i32 %a, i32 %b) {
; CHECK-LABEL: test.cv.alu.suburn.case.b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    cv.suburnr a0, a1, a2
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.riscv.cv.alu.suburn(i32 %a, i32 %b, i32 32)
  ret i32 %1
}
