; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv6-none-eabi -float-abi=soft %s -o - | FileCheck %s --check-prefixes=SOFT
; RUN: llc -mtriple=thumbv7-none-eabi -mattr=+vfp2 %s -o - | FileCheck %s --check-prefixes=VFP,VFP2
; RUN: llc -mtriple=thumbv8.1m.main-eabi -mattr=+fullfp16,+fp64 %s -o - | FileCheck %s --check-prefixes=VFP,FP16

;
; 32-bit float to signed integer
;

declare   i1 @llvm.fptoui.sat.i1.f32  (float)
declare   i8 @llvm.fptoui.sat.i8.f32  (float)
declare  i13 @llvm.fptoui.sat.i13.f32 (float)
declare  i16 @llvm.fptoui.sat.i16.f32 (float)
declare  i19 @llvm.fptoui.sat.i19.f32 (float)
declare  i32 @llvm.fptoui.sat.i32.f32 (float)
declare  i50 @llvm.fptoui.sat.i50.f32 (float)
declare  i64 @llvm.fptoui.sat.i64.f32 (float)
declare i100 @llvm.fptoui.sat.i100.f32(float)
declare i128 @llvm.fptoui.sat.i128.f32(float)

define i1 @test_signed_i1_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i1_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r0, #127
; SOFT-NEXT:    lsls r1, r0, #23
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB0_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB0_4
; SOFT-NEXT:  .LBB0_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB0_3:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB0_2
; SOFT-NEXT:  .LBB0_4:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: test_signed_i1_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s2, r0
; VFP2-NEXT:    vmov.f32 s0, #1.000000e+00
; VFP2-NEXT:    vcvt.u32.f32 s4, s2
; VFP2-NEXT:    vcmp.f32 s2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #1
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i1_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI0_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vmov.f32 s4, #1.000000e+00
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI0_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i1 @llvm.fptoui.sat.i1.f32(float %f)
    ret i1 %x
}

define i8 @test_signed_i8_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i8_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI1_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB1_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB1_4
; SOFT-NEXT:  .LBB1_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB1_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB1_2
; SOFT-NEXT:  .LBB1_4:
; SOFT-NEXT:    movs r0, #255
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI1_0:
; SOFT-NEXT:    .long 1132396544 @ 0x437f0000
;
; VFP2-LABEL: test_signed_i8_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI1_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #255
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI1_0:
; VFP2-NEXT:    .long 0x437f0000 @ float 255
;
; FP16-LABEL: test_signed_i8_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI1_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI1_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI1_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
; FP16-NEXT:  .LCPI1_1:
; FP16-NEXT:    .long 0x437f0000 @ float 255
    %x = call i8 @llvm.fptoui.sat.i8.f32(float %f)
    ret i8 %x
}

define i13 @test_signed_i13_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i13_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI2_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB2_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB2_4
; SOFT-NEXT:  .LBB2_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB2_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB2_2
; SOFT-NEXT:  .LBB2_4:
; SOFT-NEXT:    ldr r0, .LCPI2_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI2_0:
; SOFT-NEXT:    .long 1174403072 @ 0x45fff800
; SOFT-NEXT:  .LCPI2_1:
; SOFT-NEXT:    .long 8191 @ 0x1fff
;
; VFP2-LABEL: test_signed_i13_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI2_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #8191
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI2_0:
; VFP2-NEXT:    .long 0x45fff800 @ float 8191
;
; FP16-LABEL: test_signed_i13_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI2_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI2_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI2_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
; FP16-NEXT:  .LCPI2_1:
; FP16-NEXT:    .long 0x45fff800 @ float 8191
    %x = call i13 @llvm.fptoui.sat.i13.f32(float %f)
    ret i13 %x
}

define i16 @test_signed_i16_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i16_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI3_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB3_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB3_4
; SOFT-NEXT:  .LBB3_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB3_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB3_2
; SOFT-NEXT:  .LBB3_4:
; SOFT-NEXT:    ldr r0, .LCPI3_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI3_0:
; SOFT-NEXT:    .long 1199570688 @ 0x477fff00
; SOFT-NEXT:  .LCPI3_1:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: test_signed_i16_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI3_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI3_0:
; VFP2-NEXT:    .long 0x477fff00 @ float 65535
;
; FP16-LABEL: test_signed_i16_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI3_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI3_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI3_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
; FP16-NEXT:  .LCPI3_1:
; FP16-NEXT:    .long 0x477fff00 @ float 65535
    %x = call i16 @llvm.fptoui.sat.i16.f32(float %f)
    ret i16 %x
}

define i19 @test_signed_i19_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i19_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI4_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB4_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB4_4
; SOFT-NEXT:  .LBB4_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB4_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB4_2
; SOFT-NEXT:  .LBB4_4:
; SOFT-NEXT:    ldr r0, .LCPI4_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI4_0:
; SOFT-NEXT:    .long 1224736736 @ 0x48ffffe0
; SOFT-NEXT:  .LCPI4_1:
; SOFT-NEXT:    .long 524287 @ 0x7ffff
;
; VFP2-LABEL: test_signed_i19_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI4_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #7
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI4_0:
; VFP2-NEXT:    .long 0x48ffffe0 @ float 524287
;
; FP16-LABEL: test_signed_i19_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI4_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI4_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI4_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
; FP16-NEXT:  .LCPI4_1:
; FP16-NEXT:    .long 0x48ffffe0 @ float 524287
    %x = call i19 @llvm.fptoui.sat.i19.f32(float %f)
    ret i19 %x
}

define i32 @test_signed_i32_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i32_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI5_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB5_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB5_4
; SOFT-NEXT:  .LBB5_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB5_3:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB5_2
; SOFT-NEXT:  .LBB5_4:
; SOFT-NEXT:    mvns r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI5_0:
; SOFT-NEXT:    .long 1333788671 @ 0x4f7fffff
;
; VFP-LABEL: test_signed_i32_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    vmov s0, r0
; VFP-NEXT:    vcvt.u32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
    %x = call i32 @llvm.fptoui.sat.i32.f32(float %f)
    ret i32 %x
}

define i50 @test_signed_i50_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i50_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI6_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB6_5
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB6_6
; SOFT-NEXT:  .LBB6_2:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB6_7
; SOFT-NEXT:  .LBB6_3:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB6_8
; SOFT-NEXT:  .LBB6_4:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB6_5:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB6_2
; SOFT-NEXT:  .LBB6_6:
; SOFT-NEXT:    mvns r0, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB6_3
; SOFT-NEXT:  .LBB6_7:
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB6_4
; SOFT-NEXT:  .LBB6_8:
; SOFT-NEXT:    ldr r1, .LCPI6_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI6_0:
; SOFT-NEXT:    .long 1484783615 @ 0x587fffff
; SOFT-NEXT:  .LCPI6_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP-LABEL: test_signed_i50_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    .vsave {d8}
; VFP-NEXT:    vpush {d8}
; VFP-NEXT:    vmov s16, r0
; VFP-NEXT:    bl __aeabi_f2ulz
; VFP-NEXT:    vldr s0, .LCPI6_0
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itt lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    ittt gt
; VFP-NEXT:    movwgt r1, #65535
; VFP-NEXT:    movtgt r1, #3
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vpop {d8}
; VFP-NEXT:    pop {r7, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI6_0:
; VFP-NEXT:    .long 0x587fffff @ float 1.12589984E+15
    %x = call i50 @llvm.fptoui.sat.i50.f32(float %f)
    ret i50 %x
}

define i64 @test_signed_i64_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i64_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI7_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB7_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:  .LBB7_2:
; SOFT-NEXT:    mvns r2, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    beq .LBB7_7
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB7_8
; SOFT-NEXT:  .LBB7_4:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB7_6
; SOFT-NEXT:  .LBB7_5:
; SOFT-NEXT:    mov r2, r1
; SOFT-NEXT:  .LBB7_6:
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB7_7:
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB7_4
; SOFT-NEXT:  .LBB7_8:
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB7_5
; SOFT-NEXT:    b .LBB7_6
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI7_0:
; SOFT-NEXT:    .long 1602224127 @ 0x5f7fffff
;
; VFP-LABEL: test_signed_i64_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    .vsave {d8}
; VFP-NEXT:    vpush {d8}
; VFP-NEXT:    vmov s16, r0
; VFP-NEXT:    bl __aeabi_f2ulz
; VFP-NEXT:    vldr s0, .LCPI7_0
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r1, #-1
; VFP-NEXT:    vpop {d8}
; VFP-NEXT:    pop {r7, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI7_0:
; VFP-NEXT:    .long 0x5f7fffff @ float 1.8446743E+19
    %x = call i64 @llvm.fptoui.sat.i64.f32(float %f)
    ret i64 %x
}

define i100 @test_signed_i100_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i100_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI8_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    str r2, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB8_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB8_2:
; SOFT-NEXT:    mvns r2, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r6, r2
; SOFT-NEXT:    bne .LBB8_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:  .LBB8_4:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB8_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:  .LBB8_6:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    beq .LBB8_13
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB8_14
; SOFT-NEXT:  .LBB8_8:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB8_15
; SOFT-NEXT:  .LBB8_9:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB8_16
; SOFT-NEXT:  .LBB8_10:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB8_12
; SOFT-NEXT:  .LBB8_11:
; SOFT-NEXT:    movs r3, #15
; SOFT-NEXT:  .LBB8_12:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB8_13:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB8_8
; SOFT-NEXT:  .LBB8_14:
; SOFT-NEXT:    str r5, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB8_9
; SOFT-NEXT:  .LBB8_15:
; SOFT-NEXT:    ldr r2, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB8_10
; SOFT-NEXT:  .LBB8_16:
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB8_11
; SOFT-NEXT:    b .LBB8_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI8_0:
; SOFT-NEXT:    .long 1904214015 @ 0x717fffff
;
; VFP-LABEL: test_signed_i100_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    .vsave {d8}
; VFP-NEXT:    vpush {d8}
; VFP-NEXT:    vmov s16, r0
; VFP-NEXT:    bl __fixunssfti
; VFP-NEXT:    vldr s0, .LCPI8_0
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r1, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r2, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r2, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r3, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt r3, #15
; VFP-NEXT:    vpop {d8}
; VFP-NEXT:    pop {r7, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI8_0:
; VFP-NEXT:    .long 0x717fffff @ float 1.26765052E+30
    %x = call i100 @llvm.fptoui.sat.i100.f32(float %f)
    ret i100 %x
}

define i128 @test_signed_i128_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i128_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI9_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    str r3, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB9_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB9_2:
; SOFT-NEXT:    mvns r6, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bne .LBB9_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:  .LBB9_4:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB9_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:  .LBB9_6:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB9_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:  .LBB9_8:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB9_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:  .LBB9_10:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:    beq .LBB9_15
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB9_16
; SOFT-NEXT:  .LBB9_12:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB9_14
; SOFT-NEXT:  .LBB9_13:
; SOFT-NEXT:    ldr r6, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB9_14:
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB9_15:
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB9_12
; SOFT-NEXT:  .LBB9_16:
; SOFT-NEXT:    str r5, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB9_13
; SOFT-NEXT:    b .LBB9_14
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI9_0:
; SOFT-NEXT:    .long 2139095039 @ 0x7f7fffff
;
; VFP-LABEL: test_signed_i128_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    .vsave {d8}
; VFP-NEXT:    vpush {d8}
; VFP-NEXT:    vmov s16, r0
; VFP-NEXT:    bl __fixunssfti
; VFP-NEXT:    vldr s0, .LCPI9_0
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r1, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r2, #0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    vcmp.f32 s16, #0
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r2, #-1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it lt
; VFP-NEXT:    movlt r3, #0
; VFP-NEXT:    vcmp.f32 s16, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r3, #-1
; VFP-NEXT:    vpop {d8}
; VFP-NEXT:    pop {r7, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI9_0:
; VFP-NEXT:    .long 0x7f7fffff @ float 3.40282347E+38
    %x = call i128 @llvm.fptoui.sat.i128.f32(float %f)
    ret i128 %x
}

;
; 64-bit float to signed integer
;

declare   i1 @llvm.fptoui.sat.i1.f64  (double)
declare   i8 @llvm.fptoui.sat.i8.f64  (double)
declare  i13 @llvm.fptoui.sat.i13.f64 (double)
declare  i16 @llvm.fptoui.sat.i16.f64 (double)
declare  i19 @llvm.fptoui.sat.i19.f64 (double)
declare  i32 @llvm.fptoui.sat.i32.f64 (double)
declare  i50 @llvm.fptoui.sat.i50.f64 (double)
declare  i64 @llvm.fptoui.sat.i64.f64 (double)
declare i100 @llvm.fptoui.sat.i100.f64(double)
declare i128 @llvm.fptoui.sat.i128.f64(double)

define i1 @test_signed_i1_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i1_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    ldr r3, .LCPI10_0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB10_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB10_4
; SOFT-NEXT:  .LBB10_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB10_3:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB10_2
; SOFT-NEXT:  .LBB10_4:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI10_0:
; SOFT-NEXT:    .long 1072693248 @ 0x3ff00000
;
; VFP2-LABEL: test_signed_i1_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmov.f64 d17, #1.000000e+00
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #1
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i1_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f64 d0, #1.000000e+00
; FP16-NEXT:    vldr d1, .LCPI10_0
; FP16-NEXT:    vmov d2, r0, r1
; FP16-NEXT:    vmaxnm.f64 d1, d2, d1
; FP16-NEXT:    vminnm.f64 d0, d1, d0
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI10_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
    %x = call i1 @llvm.fptoui.sat.i1.f64(double %f)
    ret i1 %x
}

define i8 @test_signed_i8_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i8_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    ldr r3, .LCPI11_0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB11_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB11_4
; SOFT-NEXT:  .LBB11_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB11_3:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB11_2
; SOFT-NEXT:  .LBB11_4:
; SOFT-NEXT:    movs r0, #255
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI11_0:
; SOFT-NEXT:    .long 1081073664 @ 0x406fe000
;
; VFP2-LABEL: test_signed_i8_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI11_0
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #255
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI11_0:
; VFP2-NEXT:    .long 0 @ double 255
; VFP2-NEXT:    .long 1081073664
;
; FP16-LABEL: test_signed_i8_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI11_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI11_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI11_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
; FP16-NEXT:  .LCPI11_1:
; FP16-NEXT:    .long 0 @ double 255
; FP16-NEXT:    .long 1081073664
    %x = call i8 @llvm.fptoui.sat.i8.f64(double %f)
    ret i8 %x
}

define i13 @test_signed_i13_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i13_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    ldr r3, .LCPI12_0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB12_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB12_4
; SOFT-NEXT:  .LBB12_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB12_3:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB12_2
; SOFT-NEXT:  .LBB12_4:
; SOFT-NEXT:    ldr r0, .LCPI12_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI12_0:
; SOFT-NEXT:    .long 1086324480 @ 0x40bfff00
; SOFT-NEXT:  .LCPI12_1:
; SOFT-NEXT:    .long 8191 @ 0x1fff
;
; VFP2-LABEL: test_signed_i13_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI12_0
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #8191
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI12_0:
; VFP2-NEXT:    .long 0 @ double 8191
; VFP2-NEXT:    .long 1086324480
;
; FP16-LABEL: test_signed_i13_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI12_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI12_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI12_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
; FP16-NEXT:  .LCPI12_1:
; FP16-NEXT:    .long 0 @ double 8191
; FP16-NEXT:    .long 1086324480
    %x = call i13 @llvm.fptoui.sat.i13.f64(double %f)
    ret i13 %x
}

define i16 @test_signed_i16_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i16_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    ldr r3, .LCPI13_0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB13_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB13_4
; SOFT-NEXT:  .LBB13_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB13_3:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB13_2
; SOFT-NEXT:  .LBB13_4:
; SOFT-NEXT:    ldr r0, .LCPI13_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI13_0:
; SOFT-NEXT:    .long 1089470432 @ 0x40efffe0
; SOFT-NEXT:  .LCPI13_1:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: test_signed_i16_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI13_0
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI13_0:
; VFP2-NEXT:    .long 0 @ double 65535
; VFP2-NEXT:    .long 1089470432
;
; FP16-LABEL: test_signed_i16_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI13_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI13_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI13_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
; FP16-NEXT:  .LCPI13_1:
; FP16-NEXT:    .long 0 @ double 65535
; FP16-NEXT:    .long 1089470432
    %x = call i16 @llvm.fptoui.sat.i16.f64(double %f)
    ret i16 %x
}

define i19 @test_signed_i19_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i19_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    ldr r3, .LCPI14_0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB14_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB14_4
; SOFT-NEXT:  .LBB14_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB14_3:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB14_2
; SOFT-NEXT:  .LBB14_4:
; SOFT-NEXT:    ldr r0, .LCPI14_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI14_0:
; SOFT-NEXT:    .long 1092616188 @ 0x411ffffc
; SOFT-NEXT:  .LCPI14_1:
; SOFT-NEXT:    .long 524287 @ 0x7ffff
;
; VFP2-LABEL: test_signed_i19_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI14_0
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #7
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI14_0:
; VFP2-NEXT:    .long 0 @ double 524287
; VFP2-NEXT:    .long 1092616188
;
; FP16-LABEL: test_signed_i19_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI14_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI14_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI14_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
; FP16-NEXT:  .LCPI14_1:
; FP16-NEXT:    .long 0 @ double 524287
; FP16-NEXT:    .long 1092616188
    %x = call i19 @llvm.fptoui.sat.i19.f64(double %f)
    ret i19 %x
}

define i32 @test_signed_i32_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i32_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r2, .LCPI15_0
; SOFT-NEXT:    ldr r3, .LCPI15_1
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB15_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:  .LBB15_2:
; SOFT-NEXT:    ldr r1, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB15_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mvns r0, r4
; SOFT-NEXT:  .LBB15_4:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI15_0:
; SOFT-NEXT:    .long 4292870144 @ 0xffe00000
; SOFT-NEXT:  .LCPI15_1:
; SOFT-NEXT:    .long 1106247679 @ 0x41efffff
;
; VFP2-LABEL: test_signed_i32_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vcvt.u32.f64 s0, d16
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i32_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov d0, r0, r1
; FP16-NEXT:    vcvt.u32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
    %x = call i32 @llvm.fptoui.sat.i32.f64(double %f)
    ret i32 %x
}

define i50 @test_signed_i50_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i50_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #7
; SOFT-NEXT:    mvns r2, r0
; SOFT-NEXT:    ldr r3, .LCPI16_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bl __aeabi_d2ulz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB16_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB16_2:
; SOFT-NEXT:    ldr r2, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB16_6
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB16_7
; SOFT-NEXT:  .LBB16_4:
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB16_8
; SOFT-NEXT:  .LBB16_5:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB16_6:
; SOFT-NEXT:    mvns r0, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB16_4
; SOFT-NEXT:  .LBB16_7:
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB16_5
; SOFT-NEXT:  .LBB16_8:
; SOFT-NEXT:    ldr r1, .LCPI16_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI16_0:
; SOFT-NEXT:    .long 1125122047 @ 0x430fffff
; SOFT-NEXT:  .LCPI16_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i50_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    vmov d8, r0, r1
; VFP2-NEXT:    bl __aeabi_d2ulz
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vldr d16, .LCPI16_0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    ittt gt
; VFP2-NEXT:    movwgt r1, #65535
; VFP2-NEXT:    movtgt r1, #3
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI16_0:
; VFP2-NEXT:    .long 4294967288 @ double 1125899906842623
; VFP2-NEXT:    .long 1125122047
;
; FP16-LABEL: test_signed_i50_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    vldr d0, .LCPI16_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI16_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vmov r0, r1, d0
; FP16-NEXT:    bl __aeabi_d2ulz
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI16_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
; FP16-NEXT:  .LCPI16_1:
; FP16-NEXT:    .long 4294967288 @ double 1125899906842623
; FP16-NEXT:    .long 1125122047
    %x = call i50 @llvm.fptoui.sat.i50.f64(double %f)
    ret i50 %x
}

define i64 @test_signed_i64_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i64_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r4, r6
; SOFT-NEXT:    ldr r3, .LCPI17_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bl __aeabi_d2ulz
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB17_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB17_2:
; SOFT-NEXT:    ldr r3, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB17_7
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB17_8
; SOFT-NEXT:  .LBB17_4:
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB17_6
; SOFT-NEXT:  .LBB17_5:
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:  .LBB17_6:
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB17_7:
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB17_4
; SOFT-NEXT:  .LBB17_8:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB17_5
; SOFT-NEXT:    b .LBB17_6
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI17_0:
; SOFT-NEXT:    .long 1139802111 @ 0x43efffff
;
; VFP2-LABEL: test_signed_i64_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    vmov d8, r0, r1
; VFP2-NEXT:    bl __aeabi_d2ulz
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vldr d16, .LCPI17_0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI17_0:
; VFP2-NEXT:    .long 4294967295 @ double 1.844674407370955E+19
; VFP2-NEXT:    .long 1139802111
;
; FP16-LABEL: test_signed_i64_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov d8, r0, r1
; FP16-NEXT:    bl __aeabi_d2ulz
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vldr d0, .LCPI17_0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI17_0:
; FP16-NEXT:    .long 4294967295 @ double 1.844674407370955E+19
; FP16-NEXT:    .long 1139802111
    %x = call i64 @llvm.fptoui.sat.i64.f64(double %f)
    ret i64 %x
}

define i100 @test_signed_i100_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i100_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r2, r6
; SOFT-NEXT:    ldr r3, .LCPI18_0
; SOFT-NEXT:    str r2, [sp] @ 4-byte Spill
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bl __fixunsdfti
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB18_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB18_2:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    ldr r0, [sp] @ 4-byte Reload
; SOFT-NEXT:    bne .LBB18_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB18_4:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB18_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:  .LBB18_6:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    ldr r4, [sp] @ 4-byte Reload
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    beq .LBB18_13
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB18_14
; SOFT-NEXT:  .LBB18_8:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB18_15
; SOFT-NEXT:  .LBB18_9:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB18_16
; SOFT-NEXT:  .LBB18_10:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB18_12
; SOFT-NEXT:  .LBB18_11:
; SOFT-NEXT:    movs r3, #15
; SOFT-NEXT:  .LBB18_12:
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB18_13:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB18_8
; SOFT-NEXT:  .LBB18_14:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB18_9
; SOFT-NEXT:  .LBB18_15:
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB18_10
; SOFT-NEXT:  .LBB18_16:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB18_11
; SOFT-NEXT:    b .LBB18_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI18_0:
; SOFT-NEXT:    .long 1177550847 @ 0x462fffff
;
; VFP2-LABEL: test_signed_i100_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    vmov d8, r0, r1
; VFP2-NEXT:    bl __fixunsdfti
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vldr d16, .LCPI18_0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r3, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r3, #15
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI18_0:
; VFP2-NEXT:    .long 4294967295 @ double 1.2676506002282293E+30
; VFP2-NEXT:    .long 1177550847
;
; FP16-LABEL: test_signed_i100_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov d8, r0, r1
; FP16-NEXT:    bl __fixunsdfti
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vldr d0, .LCPI18_0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r3, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt r3, #15
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI18_0:
; FP16-NEXT:    .long 4294967295 @ double 1.2676506002282293E+30
; FP16-NEXT:    .long 1177550847
    %x = call i100 @llvm.fptoui.sat.i100.f64(double %f)
    ret i100 %x
}

define i128 @test_signed_i128_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i128_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r4, r6
; SOFT-NEXT:    ldr r3, .LCPI19_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bl __fixunsdfti
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB19_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:  .LBB19_2:
; SOFT-NEXT:    ldr r0, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bne .LBB19_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB19_4:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB19_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:  .LBB19_6:
; SOFT-NEXT:    ldr r1, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bne .LBB19_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:  .LBB19_8:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB19_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB19_10:
; SOFT-NEXT:    ldr r5, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r5, r4
; SOFT-NEXT:    bne .LBB19_12
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    mov r5, r2
; SOFT-NEXT:  .LBB19_12:
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB19_14
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB19_14:
; SOFT-NEXT:    ldr r2, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB19_16
; SOFT-NEXT:  @ %bb.15:
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:  .LBB19_16:
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI19_0:
; SOFT-NEXT:    .long 1206910975 @ 0x47efffff
;
; VFP2-LABEL: test_signed_i128_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    vmov d8, r0, r1
; VFP2-NEXT:    bl __fixunsdfti
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vldr d16, .LCPI19_0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    vcmp.f64 d8, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r3, #0
; VFP2-NEXT:    vcmp.f64 d8, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r3, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI19_0:
; VFP2-NEXT:    .long 4294967295 @ double 3.4028236692093843E+38
; VFP2-NEXT:    .long 1206910975
;
; FP16-LABEL: test_signed_i128_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov d8, r0, r1
; FP16-NEXT:    bl __fixunsdfti
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vldr d0, .LCPI19_0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    vcmp.f64 d8, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r3, #0
; FP16-NEXT:    vcmp.f64 d8, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r3, #-1
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI19_0:
; FP16-NEXT:    .long 4294967295 @ double 3.4028236692093843E+38
; FP16-NEXT:    .long 1206910975
    %x = call i128 @llvm.fptoui.sat.i128.f64(double %f)
    ret i128 %x
}

;
; 16-bit float to signed integer
;

declare   i1 @llvm.fptoui.sat.i1.f16  (half)
declare   i8 @llvm.fptoui.sat.i8.f16  (half)
declare  i13 @llvm.fptoui.sat.i13.f16 (half)
declare  i16 @llvm.fptoui.sat.i16.f16 (half)
declare  i19 @llvm.fptoui.sat.i19.f16 (half)
declare  i32 @llvm.fptoui.sat.i32.f16 (half)
declare  i50 @llvm.fptoui.sat.i50.f16 (half)
declare  i64 @llvm.fptoui.sat.i64.f16 (half)
declare i100 @llvm.fptoui.sat.i100.f16(half)
declare i128 @llvm.fptoui.sat.i128.f16(half)

define i1 @test_signed_i1_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i1_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r0, #127
; SOFT-NEXT:    lsls r1, r0, #23
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB20_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB20_4
; SOFT-NEXT:  .LBB20_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB20_3:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB20_2
; SOFT-NEXT:  .LBB20_4:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: test_signed_i1_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s2, r0
; VFP2-NEXT:    vmov.f32 s0, #1.000000e+00
; VFP2-NEXT:    vcvt.u32.f32 s4, s2
; VFP2-NEXT:    vcmp.f32 s2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #1
; VFP2-NEXT:    pop {r7, pc}
;
; FP16-LABEL: test_signed_i1_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI20_0
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vmov.f32 s2, #1.000000e+00
; FP16-NEXT:    vmaxnm.f32 s0, s0, s4
; FP16-NEXT:    vminnm.f32 s0, s0, s2
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI20_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i1 @llvm.fptoui.sat.i1.f16(half %f)
    ret i1 %x
}

define i8 @test_signed_i8_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i8_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI21_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB21_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB21_4
; SOFT-NEXT:  .LBB21_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB21_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB21_2
; SOFT-NEXT:  .LBB21_4:
; SOFT-NEXT:    movs r0, #255
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI21_0:
; SOFT-NEXT:    .long 1132396544 @ 0x437f0000
;
; VFP2-LABEL: test_signed_i8_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI21_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #255
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI21_0:
; VFP2-NEXT:    .long 0x437f0000 @ float 255
;
; FP16-LABEL: test_signed_i8_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI21_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI21_0
; FP16-NEXT:    vmaxnm.f32 s0, s0, s4
; FP16-NEXT:    vminnm.f32 s0, s0, s2
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI21_0:
; FP16-NEXT:    .long 0x437f0000 @ float 255
; FP16-NEXT:  .LCPI21_1:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i8 @llvm.fptoui.sat.i8.f16(half %f)
    ret i8 %x
}

define i13 @test_signed_i13_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i13_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI22_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB22_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB22_4
; SOFT-NEXT:  .LBB22_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB22_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB22_2
; SOFT-NEXT:  .LBB22_4:
; SOFT-NEXT:    ldr r0, .LCPI22_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI22_0:
; SOFT-NEXT:    .long 1174403072 @ 0x45fff800
; SOFT-NEXT:  .LCPI22_1:
; SOFT-NEXT:    .long 8191 @ 0x1fff
;
; VFP2-LABEL: test_signed_i13_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI22_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #8191
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI22_0:
; VFP2-NEXT:    .long 0x45fff800 @ float 8191
;
; FP16-LABEL: test_signed_i13_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI22_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI22_0
; FP16-NEXT:    vmaxnm.f32 s0, s0, s4
; FP16-NEXT:    vminnm.f32 s0, s0, s2
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI22_0:
; FP16-NEXT:    .long 0x45fff800 @ float 8191
; FP16-NEXT:  .LCPI22_1:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i13 @llvm.fptoui.sat.i13.f16(half %f)
    ret i13 %x
}

define i16 @test_signed_i16_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i16_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI23_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB23_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB23_4
; SOFT-NEXT:  .LBB23_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB23_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB23_2
; SOFT-NEXT:  .LBB23_4:
; SOFT-NEXT:    ldr r0, .LCPI23_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI23_0:
; SOFT-NEXT:    .long 1199570688 @ 0x477fff00
; SOFT-NEXT:  .LCPI23_1:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: test_signed_i16_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI23_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI23_0:
; VFP2-NEXT:    .long 0x477fff00 @ float 65535
;
; FP16-LABEL: test_signed_i16_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI23_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI23_0
; FP16-NEXT:    vmaxnm.f32 s0, s0, s4
; FP16-NEXT:    vminnm.f32 s0, s0, s2
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI23_0:
; FP16-NEXT:    .long 0x477fff00 @ float 65535
; FP16-NEXT:  .LCPI23_1:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i16 @llvm.fptoui.sat.i16.f16(half %f)
    ret i16 %x
}

define i19 @test_signed_i19_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i19_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    ldr r1, .LCPI24_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB24_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB24_4
; SOFT-NEXT:  .LBB24_2:
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB24_3:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB24_2
; SOFT-NEXT:  .LBB24_4:
; SOFT-NEXT:    ldr r0, .LCPI24_1
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI24_0:
; SOFT-NEXT:    .long 1224736736 @ 0x48ffffe0
; SOFT-NEXT:  .LCPI24_1:
; SOFT-NEXT:    .long 524287 @ 0x7ffff
;
; VFP2-LABEL: test_signed_i19_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s4, .LCPI24_0
; VFP2-NEXT:    vcvt.u32.f32 s2, s0
; VFP2-NEXT:    vcmp.f32 s0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s4
; VFP2-NEXT:    vmov r0, s2
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #7
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI24_0:
; VFP2-NEXT:    .long 0x48ffffe0 @ float 524287
;
; FP16-LABEL: test_signed_i19_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI24_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI24_0
; FP16-NEXT:    vmaxnm.f32 s0, s0, s4
; FP16-NEXT:    vminnm.f32 s0, s0, s2
; FP16-NEXT:    vcvt.u32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI24_0:
; FP16-NEXT:    .long 0x48ffffe0 @ float 524287
; FP16-NEXT:  .LCPI24_1:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i19 @llvm.fptoui.sat.i19.f16(half %f)
    ret i19 %x
}

define i32 @test_signed_i32_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i32_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI25_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB25_3
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB25_4
; SOFT-NEXT:  .LBB25_2:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB25_3:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB25_2
; SOFT-NEXT:  .LBB25_4:
; SOFT-NEXT:    mvns r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI25_0:
; SOFT-NEXT:    .long 1333788671 @ 0x4f7fffff
;
; VFP2-LABEL: test_signed_i32_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FP16-LABEL: test_signed_i32_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvt.u32.f16 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
    %x = call i32 @llvm.fptoui.sat.i32.f16(half %f)
    ret i32 %x
}

define i50 @test_signed_i50_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i50_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI26_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB26_5
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB26_6
; SOFT-NEXT:  .LBB26_2:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB26_7
; SOFT-NEXT:  .LBB26_3:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB26_8
; SOFT-NEXT:  .LBB26_4:
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB26_5:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB26_2
; SOFT-NEXT:  .LBB26_6:
; SOFT-NEXT:    mvns r0, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB26_3
; SOFT-NEXT:  .LBB26_7:
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB26_4
; SOFT-NEXT:  .LBB26_8:
; SOFT-NEXT:    ldr r1, .LCPI26_1
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI26_0:
; SOFT-NEXT:    .long 1484783615 @ 0x587fffff
; SOFT-NEXT:  .LCPI26_1:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i50_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s16, r0
; VFP2-NEXT:    bl __aeabi_f2ulz
; VFP2-NEXT:    vldr s0, .LCPI26_0
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    ittt gt
; VFP2-NEXT:    movwgt r1, #65535
; VFP2-NEXT:    movtgt r1, #3
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI26_0:
; VFP2-NEXT:    .long 0x587fffff @ float 1.12589984E+15
;
; FP16-LABEL: test_signed_i50_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __aeabi_f2ulz
; FP16-NEXT:    vldr s0, .LCPI26_0
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    ittt gt
; FP16-NEXT:    movwgt r1, #65535
; FP16-NEXT:    movtgt r1, #3
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI26_0:
; FP16-NEXT:    .long 0x587fffff @ float 1.12589984E+15
    %x = call i50 @llvm.fptoui.sat.i50.f16(half %f)
    ret i50 %x
}

define i64 @test_signed_i64_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i64_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI27_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB27_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:  .LBB27_2:
; SOFT-NEXT:    mvns r2, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    beq .LBB27_7
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB27_8
; SOFT-NEXT:  .LBB27_4:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB27_6
; SOFT-NEXT:  .LBB27_5:
; SOFT-NEXT:    mov r2, r1
; SOFT-NEXT:  .LBB27_6:
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB27_7:
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB27_4
; SOFT-NEXT:  .LBB27_8:
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB27_5
; SOFT-NEXT:    b .LBB27_6
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI27_0:
; SOFT-NEXT:    .long 1602224127 @ 0x5f7fffff
;
; VFP2-LABEL: test_signed_i64_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s16, r0
; VFP2-NEXT:    bl __aeabi_f2ulz
; VFP2-NEXT:    vldr s0, .LCPI27_0
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI27_0:
; VFP2-NEXT:    .long 0x5f7fffff @ float 1.8446743E+19
;
; FP16-LABEL: test_signed_i64_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __aeabi_f2ulz
; FP16-NEXT:    vldr s0, .LCPI27_0
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI27_0:
; FP16-NEXT:    .long 0x5f7fffff @ float 1.8446743E+19
    %x = call i64 @llvm.fptoui.sat.i64.f16(half %f)
    ret i64 %x
}

define i100 @test_signed_i100_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i100_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI28_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    str r2, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB28_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB28_2:
; SOFT-NEXT:    mvns r2, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r6, r2
; SOFT-NEXT:    bne .LBB28_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:  .LBB28_4:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB28_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:  .LBB28_6:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    beq .LBB28_13
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB28_14
; SOFT-NEXT:  .LBB28_8:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB28_15
; SOFT-NEXT:  .LBB28_9:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB28_16
; SOFT-NEXT:  .LBB28_10:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB28_12
; SOFT-NEXT:  .LBB28_11:
; SOFT-NEXT:    movs r3, #15
; SOFT-NEXT:  .LBB28_12:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB28_13:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB28_8
; SOFT-NEXT:  .LBB28_14:
; SOFT-NEXT:    str r5, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB28_9
; SOFT-NEXT:  .LBB28_15:
; SOFT-NEXT:    ldr r2, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB28_10
; SOFT-NEXT:  .LBB28_16:
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB28_11
; SOFT-NEXT:    b .LBB28_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI28_0:
; SOFT-NEXT:    .long 1904214015 @ 0x717fffff
;
; VFP2-LABEL: test_signed_i100_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s16, r0
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    vldr s0, .LCPI28_0
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r3, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r3, #15
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI28_0:
; VFP2-NEXT:    .long 0x717fffff @ float 1.26765052E+30
;
; FP16-LABEL: test_signed_i100_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __fixunssfti
; FP16-NEXT:    vldr s0, .LCPI28_0
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r3, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt r3, #15
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI28_0:
; FP16-NEXT:    .long 0x717fffff @ float 1.26765052E+30
    %x = call i100 @llvm.fptoui.sat.i100.f16(half %f)
    ret i100 %x
}

define i128 @test_signed_i128_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i128_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r1, .LCPI29_0
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    str r3, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB29_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB29_2:
; SOFT-NEXT:    mvns r6, r6
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    bne .LBB29_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:  .LBB29_4:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB29_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:  .LBB29_6:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB29_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:  .LBB29_8:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB29_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:  .LBB29_10:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:    beq .LBB29_15
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB29_16
; SOFT-NEXT:  .LBB29_12:
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB29_14
; SOFT-NEXT:  .LBB29_13:
; SOFT-NEXT:    ldr r6, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB29_14:
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB29_15:
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB29_12
; SOFT-NEXT:  .LBB29_16:
; SOFT-NEXT:    str r5, [sp] @ 4-byte Spill
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB29_13
; SOFT-NEXT:    b .LBB29_14
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI29_0:
; SOFT-NEXT:    .long 2139095039 @ 0x7f7fffff
;
; VFP2-LABEL: test_signed_i128_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    .vsave {d8}
; VFP2-NEXT:    vpush {d8}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s16, r0
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    vldr s0, .LCPI29_0
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s16, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r3, #0
; VFP2-NEXT:    vcmp.f32 s16, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r3, #-1
; VFP2-NEXT:    vpop {d8}
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI29_0:
; VFP2-NEXT:    .long 0x7f7fffff @ float 3.40282347E+38
;
; FP16-LABEL: test_signed_i128_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __fixunssfti
; FP16-NEXT:    vldr s0, .LCPI29_0
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcmp.f32 s16, #0
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it lt
; FP16-NEXT:    movlt r3, #0
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r3, #-1
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI29_0:
; FP16-NEXT:    .long 0x7f7fffff @ float 3.40282347E+38
    %x = call i128 @llvm.fptoui.sat.i128.f16(half %f)
    ret i128 %x
}
