; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <1 x float> @llvm.fma.v1f32(<1 x float>, <1 x float>, <1 x float>)

define <1 x float> @vfwmacc_vv_v1f32(<1 x float> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %vc to <1 x float>
  %vf = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %ve, <1 x float> %va)
  ret <1 x float> %vf
}

define <1 x float> @vfwmacc_vf_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %ve, <1 x float> %va)
  ret <1 x float> %vf
}

define <1 x float> @vfwnmacc_vv_v1f32(<1 x float> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %vc to <1 x float>
  %vf = fneg <1 x float> %va
  %vg = fneg <1 x float> %vd
  %vh = call <1 x float> @llvm.fma.v1f32(<1 x float> %vg, <1 x float> %ve, <1 x float> %vf)
  ret <1 x float> %vh
}

define <1 x float> @vfwnmacc_vf_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = fneg <1 x float> %va
  %vg = fneg <1 x float> %vd
  %vh = call <1 x float> @llvm.fma.v1f32(<1 x float> %vg, <1 x float> %ve, <1 x float> %vf)
  ret <1 x float> %vh
}

define <1 x float> @vfwnmacc_fv_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = fneg <1 x float> %va
  %vg = fneg <1 x float> %ve
  %vh = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %vg, <1 x float> %vf)
  ret <1 x float> %vh
}

define <1 x float> @vfwmsac_vv_v1f32(<1 x float> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %vc to <1 x float>
  %vf = fneg <1 x float> %va
  %vg = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %ve, <1 x float> %vf)
  ret <1 x float> %vg
}

define <1 x float> @vfwmsac_vf_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = fneg <1 x float> %va
  %vg = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %ve, <1 x float> %vf)
  ret <1 x float> %vg
}

define <1 x float> @vfwnmsac_vv_v1f32(<1 x float> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %vc to <1 x float>
  %vf = fneg <1 x float> %vd
  %vg = call <1 x float> @llvm.fma.v1f32(<1 x float> %vf, <1 x float> %ve, <1 x float> %va)
  ret <1 x float> %vg
}

define <1 x float> @vfwnmsac_vf_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = fneg <1 x float> %vd
  %vg = call <1 x float> @llvm.fma.v1f32(<1 x float> %vf, <1 x float> %ve, <1 x float> %va)
  ret <1 x float> %vg
}

define <1 x float> @vfwnmsac_fv_v1f32(<1 x float> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x float>
  %ve = fpext <1 x half> %splat to <1 x float>
  %vf = fneg <1 x float> %ve
  %vg = call <1 x float> @llvm.fma.v1f32(<1 x float> %vd, <1 x float> %vf, <1 x float> %va)
  ret <1 x float> %vg
}

declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)

define <2 x float> @vfwmacc_vv_v2f32(<2 x float> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %vc to <2 x float>
  %vf = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %ve, <2 x float> %va)
  ret <2 x float> %vf
}

define <2 x float> @vfwmacc_vf_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %ve, <2 x float> %va)
  ret <2 x float> %vf
}

define <2 x float> @vfwnmacc_vv_v2f32(<2 x float> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %vc to <2 x float>
  %vf = fneg <2 x float> %va
  %vg = fneg <2 x float> %vd
  %vh = call <2 x float> @llvm.fma.v2f32(<2 x float> %vg, <2 x float> %ve, <2 x float> %vf)
  ret <2 x float> %vh
}

define <2 x float> @vfwnmacc_vf_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = fneg <2 x float> %va
  %vg = fneg <2 x float> %vd
  %vh = call <2 x float> @llvm.fma.v2f32(<2 x float> %vg, <2 x float> %ve, <2 x float> %vf)
  ret <2 x float> %vh
}

define <2 x float> @vfwnmacc_fv_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = fneg <2 x float> %va
  %vg = fneg <2 x float> %ve
  %vh = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %vg, <2 x float> %vf)
  ret <2 x float> %vh
}

define <2 x float> @vfwmsac_vv_v2f32(<2 x float> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %vc to <2 x float>
  %vf = fneg <2 x float> %va
  %vg = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %ve, <2 x float> %vf)
  ret <2 x float> %vg
}

define <2 x float> @vfwmsac_vf_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = fneg <2 x float> %va
  %vg = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %ve, <2 x float> %vf)
  ret <2 x float> %vg
}

define <2 x float> @vfwnmsac_vv_v2f32(<2 x float> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %vc to <2 x float>
  %vf = fneg <2 x float> %vd
  %vg = call <2 x float> @llvm.fma.v2f32(<2 x float> %vf, <2 x float> %ve, <2 x float> %va)
  ret <2 x float> %vg
}

define <2 x float> @vfwnmsac_vf_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = fneg <2 x float> %vd
  %vg = call <2 x float> @llvm.fma.v2f32(<2 x float> %vf, <2 x float> %ve, <2 x float> %va)
  ret <2 x float> %vg
}

define <2 x float> @vfwnmsac_fv_v2f32(<2 x float> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x float>
  %ve = fpext <2 x half> %splat to <2 x float>
  %vf = fneg <2 x float> %ve
  %vg = call <2 x float> @llvm.fma.v2f32(<2 x float> %vd, <2 x float> %vf, <2 x float> %va)
  ret <2 x float> %vg
}


declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)

define <4 x float> @vfwmacc_vv_v4f32(<4 x float> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %vc to <4 x float>
  %vf = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %ve, <4 x float> %va)
  ret <4 x float> %vf
}

define <4 x float> @vfwmacc_vf_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %ve, <4 x float> %va)
  ret <4 x float> %vf
}

define <4 x float> @vfwnmacc_vv_v4f32(<4 x float> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %vc to <4 x float>
  %vf = fneg <4 x float> %va
  %vg = fneg <4 x float> %vd
  %vh = call <4 x float> @llvm.fma.v4f32(<4 x float> %vg, <4 x float> %ve, <4 x float> %vf)
  ret <4 x float> %vh
}

define <4 x float> @vfwnmacc_vf_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = fneg <4 x float> %va
  %vg = fneg <4 x float> %vd
  %vh = call <4 x float> @llvm.fma.v4f32(<4 x float> %vg, <4 x float> %ve, <4 x float> %vf)
  ret <4 x float> %vh
}

define <4 x float> @vfwnmacc_fv_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = fneg <4 x float> %va
  %vg = fneg <4 x float> %ve
  %vh = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %vg, <4 x float> %vf)
  ret <4 x float> %vh
}

define <4 x float> @vfwmsac_vv_v4f32(<4 x float> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %vc to <4 x float>
  %vf = fneg <4 x float> %va
  %vg = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %ve, <4 x float> %vf)
  ret <4 x float> %vg
}

define <4 x float> @vfwmsac_vf_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = fneg <4 x float> %va
  %vg = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %ve, <4 x float> %vf)
  ret <4 x float> %vg
}

define <4 x float> @vfwnmsac_vv_v4f32(<4 x float> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %vc to <4 x float>
  %vf = fneg <4 x float> %vd
  %vg = call <4 x float> @llvm.fma.v4f32(<4 x float> %vf, <4 x float> %ve, <4 x float> %va)
  ret <4 x float> %vg
}

define <4 x float> @vfwnmsac_vf_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = fneg <4 x float> %vd
  %vg = call <4 x float> @llvm.fma.v4f32(<4 x float> %vf, <4 x float> %ve, <4 x float> %va)
  ret <4 x float> %vg
}

define <4 x float> @vfwnmsac_fv_v4f32(<4 x float> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x float>
  %ve = fpext <4 x half> %splat to <4 x float>
  %vf = fneg <4 x float> %ve
  %vg = call <4 x float> @llvm.fma.v4f32(<4 x float> %vd, <4 x float> %vf, <4 x float> %va)
  ret <4 x float> %vg
}

declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)

define <8 x float> @vfwmacc_vv_v8f32(<8 x float> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %vc to <8 x float>
  %vf = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %ve, <8 x float> %va)
  ret <8 x float> %vf
}

define <8 x float> @vfwmacc_vf_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %ve, <8 x float> %va)
  ret <8 x float> %vf
}

define <8 x float> @vfwnmacc_vv_v8f32(<8 x float> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %vc to <8 x float>
  %vf = fneg <8 x float> %va
  %vg = fneg <8 x float> %vd
  %vh = call <8 x float> @llvm.fma.v8f32(<8 x float> %vg, <8 x float> %ve, <8 x float> %vf)
  ret <8 x float> %vh
}

define <8 x float> @vfwnmacc_vf_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = fneg <8 x float> %va
  %vg = fneg <8 x float> %vd
  %vh = call <8 x float> @llvm.fma.v8f32(<8 x float> %vg, <8 x float> %ve, <8 x float> %vf)
  ret <8 x float> %vh
}

define <8 x float> @vfwnmacc_fv_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = fneg <8 x float> %va
  %vg = fneg <8 x float> %ve
  %vh = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %vg, <8 x float> %vf)
  ret <8 x float> %vh
}

define <8 x float> @vfwmsac_vv_v8f32(<8 x float> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %vc to <8 x float>
  %vf = fneg <8 x float> %va
  %vg = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %ve, <8 x float> %vf)
  ret <8 x float> %vg
}

define <8 x float> @vfwmsac_vf_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = fneg <8 x float> %va
  %vg = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %ve, <8 x float> %vf)
  ret <8 x float> %vg
}

define <8 x float> @vfwnmsac_vv_v8f32(<8 x float> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %vc to <8 x float>
  %vf = fneg <8 x float> %vd
  %vg = call <8 x float> @llvm.fma.v8f32(<8 x float> %vf, <8 x float> %ve, <8 x float> %va)
  ret <8 x float> %vg
}

define <8 x float> @vfwnmsac_vf_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = fneg <8 x float> %vd
  %vg = call <8 x float> @llvm.fma.v8f32(<8 x float> %vf, <8 x float> %ve, <8 x float> %va)
  ret <8 x float> %vg
}

define <8 x float> @vfwnmsac_fv_v8f32(<8 x float> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x float>
  %ve = fpext <8 x half> %splat to <8 x float>
  %vf = fneg <8 x float> %ve
  %vg = call <8 x float> @llvm.fma.v8f32(<8 x float> %vd, <8 x float> %vf, <8 x float> %va)
  ret <8 x float> %vg
}

declare <16 x float> @llvm.fma.v16f32(<16 x float>, <16 x float>, <16 x float>)

define <16 x float> @vfwmacc_vv_v16f32(<16 x float> %va, <16 x half> %vb, <16 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %vc to <16 x float>
  %vf = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %ve, <16 x float> %va)
  ret <16 x float> %vf
}

define <16 x float> @vfwmacc_vf_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %ve, <16 x float> %va)
  ret <16 x float> %vf
}

define <16 x float> @vfwnmacc_vv_v16f32(<16 x float> %va, <16 x half> %vb, <16 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %vc to <16 x float>
  %vf = fneg <16 x float> %va
  %vg = fneg <16 x float> %vd
  %vh = call <16 x float> @llvm.fma.v16f32(<16 x float> %vg, <16 x float> %ve, <16 x float> %vf)
  ret <16 x float> %vh
}

define <16 x float> @vfwnmacc_vf_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = fneg <16 x float> %va
  %vg = fneg <16 x float> %vd
  %vh = call <16 x float> @llvm.fma.v16f32(<16 x float> %vg, <16 x float> %ve, <16 x float> %vf)
  ret <16 x float> %vh
}

define <16 x float> @vfwnmacc_fv_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = fneg <16 x float> %va
  %vg = fneg <16 x float> %ve
  %vh = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %vg, <16 x float> %vf)
  ret <16 x float> %vh
}

define <16 x float> @vfwmsac_vv_v16f32(<16 x float> %va, <16 x half> %vb, <16 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %vc to <16 x float>
  %vf = fneg <16 x float> %va
  %vg = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %ve, <16 x float> %vf)
  ret <16 x float> %vg
}

define <16 x float> @vfwmsac_vf_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = fneg <16 x float> %va
  %vg = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %ve, <16 x float> %vf)
  ret <16 x float> %vg
}

define <16 x float> @vfwnmsac_vv_v16f32(<16 x float> %va, <16 x half> %vb, <16 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %vc to <16 x float>
  %vf = fneg <16 x float> %vd
  %vg = call <16 x float> @llvm.fma.v16f32(<16 x float> %vf, <16 x float> %ve, <16 x float> %va)
  ret <16 x float> %vg
}

define <16 x float> @vfwnmsac_vf_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = fneg <16 x float> %vd
  %vg = call <16 x float> @llvm.fma.v16f32(<16 x float> %vf, <16 x float> %ve, <16 x float> %va)
  ret <16 x float> %vg
}

define <16 x float> @vfwnmsac_fv_v16f32(<16 x float> %va, <16 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %c, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vd = fpext <16 x half> %vb to <16 x float>
  %ve = fpext <16 x half> %splat to <16 x float>
  %vf = fneg <16 x float> %ve
  %vg = call <16 x float> @llvm.fma.v16f32(<16 x float> %vd, <16 x float> %vf, <16 x float> %va)
  ret <16 x float> %vg
}

declare <1 x double> @llvm.fma.v1f64(<1 x double>, <1 x double>, <1 x double>)

define <1 x double> @vfwmacc_vv_v1f64(<1 x double> %va, <1 x float> %vb, <1 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %vc to <1 x double>
  %vf = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vf
}

define <1 x double> @vfwmacc_vf_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vf
}

define <1 x double> @vfwnmacc_vv_v1f64(<1 x double> %va, <1 x float> %vb, <1 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %vc to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %vd
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vg, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwnmacc_vf_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %vd
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vg, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwnmacc_fv_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %ve
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %vg, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwmsac_vv_v1f64(<1 x double> %va, <1 x float> %vb, <1 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %vc to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vg
}

define <1 x double> @vfwmsac_vf_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_vv_v1f64(<1 x double> %va, <1 x float> %vb, <1 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %vc to <1 x double>
  %vf = fneg <1 x double> %vd
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vf, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_vf_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = fneg <1 x double> %vd
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vf, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_fv_v1f64(<1 x double> %va, <1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %c, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x float> %vb to <1 x double>
  %ve = fpext <1 x float> %splat to <1 x double>
  %vf = fneg <1 x double> %ve
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %vf, <1 x double> %va)
  ret <1 x double> %vg
}

declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)

define <2 x double> @vfwmacc_vv_v2f64(<2 x double> %va, <2 x float> %vb, <2 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %vc to <2 x double>
  %vf = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vf
}

define <2 x double> @vfwmacc_vf_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vf
}

define <2 x double> @vfwnmacc_vv_v2f64(<2 x double> %va, <2 x float> %vb, <2 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %vc to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %vd
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vg, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwnmacc_vf_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %vd
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vg, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwnmacc_fv_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %ve
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %vg, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwmsac_vv_v2f64(<2 x double> %va, <2 x float> %vb, <2 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %vc to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vg
}

define <2 x double> @vfwmsac_vf_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_vv_v2f64(<2 x double> %va, <2 x float> %vb, <2 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %vc to <2 x double>
  %vf = fneg <2 x double> %vd
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vf, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_vf_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = fneg <2 x double> %vd
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vf, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_fv_v2f64(<2 x double> %va, <2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %c, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x float> %vb to <2 x double>
  %ve = fpext <2 x float> %splat to <2 x double>
  %vf = fneg <2 x double> %ve
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %vf, <2 x double> %va)
  ret <2 x double> %vg
}


declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)

define <4 x double> @vfwmacc_vv_v4f64(<4 x double> %va, <4 x float> %vb, <4 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %vc to <4 x double>
  %vf = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vf
}

define <4 x double> @vfwmacc_vf_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vf
}

define <4 x double> @vfwnmacc_vv_v4f64(<4 x double> %va, <4 x float> %vb, <4 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %vc to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %vd
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vg, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwnmacc_vf_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %vd
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vg, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwnmacc_fv_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %ve
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %vg, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwmsac_vv_v4f64(<4 x double> %va, <4 x float> %vb, <4 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %vc to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vg
}

define <4 x double> @vfwmsac_vf_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_vv_v4f64(<4 x double> %va, <4 x float> %vb, <4 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %vc to <4 x double>
  %vf = fneg <4 x double> %vd
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vf, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_vf_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = fneg <4 x double> %vd
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vf, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_fv_v4f64(<4 x double> %va, <4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %c, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x float> %vb to <4 x double>
  %ve = fpext <4 x float> %splat to <4 x double>
  %vf = fneg <4 x double> %ve
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %vf, <4 x double> %va)
  ret <4 x double> %vg
}

declare <8 x double> @llvm.fma.v8f64(<8 x double>, <8 x double>, <8 x double>)

define <8 x double> @vfwmacc_vv_v8f64(<8 x double> %va, <8 x float> %vb, <8 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %vc to <8 x double>
  %vf = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vf
}

define <8 x double> @vfwmacc_vf_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vf
}

define <8 x double> @vfwnmacc_vv_v8f64(<8 x double> %va, <8 x float> %vb, <8 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %vc to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %vd
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vg, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwnmacc_vf_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %vd
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vg, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwnmacc_fv_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %ve
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %vg, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwmsac_vv_v8f64(<8 x double> %va, <8 x float> %vb, <8 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %vc to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vg
}

define <8 x double> @vfwmsac_vf_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_vv_v8f64(<8 x double> %va, <8 x float> %vb, <8 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %vc to <8 x double>
  %vf = fneg <8 x double> %vd
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vf, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_vf_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = fneg <8 x double> %vd
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vf, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_fv_v8f64(<8 x double> %va, <8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %c, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x float> %vb to <8 x double>
  %ve = fpext <8 x float> %splat to <8 x double>
  %vf = fneg <8 x double> %ve
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %vf, <8 x double> %va)
  ret <8 x double> %vg
}

define <1 x double> @vfwmacc_vv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %vc to <1 x double>
  %vf = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vf
}

define <1 x double> @vfwmacc_vf_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vf
}

define <1 x double> @vfwnmacc_vv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %vc to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %vd
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vg, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwnmacc_vf_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %vd
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vg, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwnmacc_fv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = fneg <1 x double> %ve
  %vh = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %vg, <1 x double> %vf)
  ret <1 x double> %vh
}

define <1 x double> @vfwmsac_vv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %vc to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vg
}

define <1 x double> @vfwmsac_vf_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = fneg <1 x double> %va
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %ve, <1 x double> %vf)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_vv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, <1 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %vc to <1 x double>
  %vf = fneg <1 x double> %vd
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vf, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_vf_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = fneg <1 x double> %vd
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vf, <1 x double> %ve, <1 x double> %va)
  ret <1 x double> %vg
}

define <1 x double> @vfwnmsac_fv_v1f64_v1f16(<1 x double> %va, <1 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v1f64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %c, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %vd = fpext <1 x half> %vb to <1 x double>
  %ve = fpext <1 x half> %splat to <1 x double>
  %vf = fneg <1 x double> %ve
  %vg = call <1 x double> @llvm.fma.v1f64(<1 x double> %vd, <1 x double> %vf, <1 x double> %va)
  ret <1 x double> %vg
}

define <2 x double> @vfwmacc_vv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %vc to <2 x double>
  %vf = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vf
}

define <2 x double> @vfwmacc_vf_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vf
}

define <2 x double> @vfwnmacc_vv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %vc to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %vd
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vg, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwnmacc_vf_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %vd
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vg, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwnmacc_fv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = fneg <2 x double> %ve
  %vh = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %vg, <2 x double> %vf)
  ret <2 x double> %vh
}

define <2 x double> @vfwmsac_vv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %vc to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vg
}

define <2 x double> @vfwmsac_vf_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = fneg <2 x double> %va
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %ve, <2 x double> %vf)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_vv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, <2 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %vc to <2 x double>
  %vf = fneg <2 x double> %vd
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vf, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_vf_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = fneg <2 x double> %vd
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vf, <2 x double> %ve, <2 x double> %va)
  ret <2 x double> %vg
}

define <2 x double> @vfwnmsac_fv_v2f64_v2f16(<2 x double> %va, <2 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v11, v9
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v11, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %c, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vd = fpext <2 x half> %vb to <2 x double>
  %ve = fpext <2 x half> %splat to <2 x double>
  %vf = fneg <2 x double> %ve
  %vg = call <2 x double> @llvm.fma.v2f64(<2 x double> %vd, <2 x double> %vf, <2 x double> %va)
  ret <2 x double> %vg
}


define <4 x double> @vfwmacc_vv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v12, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %vc to <4 x double>
  %vf = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vf
}

define <4 x double> @vfwmacc_vf_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vf
}

define <4 x double> @vfwnmacc_vv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %vc to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %vd
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vg, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwnmacc_vf_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %vd
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vg, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwnmacc_fv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = fneg <4 x double> %ve
  %vh = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %vg, <4 x double> %vf)
  ret <4 x double> %vh
}

define <4 x double> @vfwmsac_vv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v12, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %vc to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vg
}

define <4 x double> @vfwmsac_vf_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = fneg <4 x double> %va
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %ve, <4 x double> %vf)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_vv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, <4 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v10
; CHECK-NEXT:    ret
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %vc to <4 x double>
  %vf = fneg <4 x double> %vd
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vf, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_vf_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = fneg <4 x double> %vd
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vf, <4 x double> %ve, <4 x double> %va)
  ret <4 x double> %vg
}

define <4 x double> @vfwnmsac_fv_v4f64_v4f16(<4 x double> %va, <4 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v4f64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v11, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v12, v10
; CHECK-NEXT:    vfwcvt.f.f.v v10, v11
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %c, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vd = fpext <4 x half> %vb to <4 x double>
  %ve = fpext <4 x half> %splat to <4 x double>
  %vf = fneg <4 x double> %ve
  %vg = call <4 x double> @llvm.fma.v4f64(<4 x double> %vd, <4 x double> %vf, <4 x double> %va)
  ret <4 x double> %vg
}

define <8 x double> @vfwmacc_vv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwmacc_vv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v14, v16
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %vc to <8 x double>
  %vf = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vf
}

define <8 x double> @vfwmacc_vf_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwmacc_vf_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vf
}

define <8 x double> @vfwnmacc_vv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwnmacc_vv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v14, v16
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %vc to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %vd
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vg, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwnmacc_vf_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_vf_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %vd
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vg, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwnmacc_fv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmacc_fv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = fneg <8 x double> %ve
  %vh = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %vg, <8 x double> %vf)
  ret <8 x double> %vh
}

define <8 x double> @vfwmsac_vv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwmsac_vv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v14, v16
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %vc to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vg
}

define <8 x double> @vfwmsac_vf_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwmsac_vf_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = fneg <8 x double> %va
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %ve, <8 x double> %vf)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_vv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, <8 x half> %vc) {
; CHECK-LABEL: vfwnmsac_vv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v14, v16
; CHECK-NEXT:    ret
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %vc to <8 x double>
  %vf = fneg <8 x double> %vd
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vf, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_vf_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_vf_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = fneg <8 x double> %vd
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vf, <8 x double> %ve, <8 x double> %va)
  ret <8 x double> %vg
}

define <8 x double> @vfwnmsac_fv_v8f64_v8f16(<8 x double> %va, <8 x half> %vb, half %c) {
; CHECK-LABEL: vfwnmsac_fv_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v13, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v14, v12
; CHECK-NEXT:    vfwcvt.f.f.v v16, v13
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v14, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %c, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vd = fpext <8 x half> %vb to <8 x double>
  %ve = fpext <8 x half> %splat to <8 x double>
  %vf = fneg <8 x double> %ve
  %vg = call <8 x double> @llvm.fma.v8f64(<8 x double> %vd, <8 x double> %vf, <8 x double> %va)
  ret <8 x double> %vg
}
