.\"
.\" cupstestppd man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupstestppd 1 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
cupstestppd \- test conformance of ppd files
.SH SYNOPSIS
.B cupstestppd
[
.B \-I
.I category
] [
.B \-R
.I rootdir
] [
.B \-W
.I category
] [
.B \-q
] [
.B \-r
] [
\fB\-v\fR[\fBv\fR]
]
.I filename.ppd[.gz]
[ ...
.I filename.ppd[.gz]
]
.br
.B cupstestppd
[
.B \-R
.I rootdir
] [
.B \-W
.I category
] [
.B \-q
] [
.B \-r
] [
\fB\-v\fR[\fBv\fR]
]
.B \-
.SH DESCRIPTION
\fBcupstestppd\fR tests the conformance of PPD files to the Adobe PostScript Printer Description file format specification version 4.3.
It can also be used to list the supported options and available fonts in a PPD file.
The results of testing and any other output are sent to the standard output.
.LP
The first form of \fBcupstestppd\fR tests one or more PPD files on the command-line.
The second form tests the PPD file provided on the standard input.
.SH OPTIONS
\fBcupstestppd\fR supports the following options:
.TP 5
\fB\-I filename\fR
Ignores all PCFileName warnings.
.TP 5
\fB\-I filters\fR
Ignores all filter errors.
.TP 5
\fB\-I profiles\fR
Ignores all profile errors.
.TP 5
\fB\-R \fIrootdir\fR
Specifies an alternate root directory for the filter, pre-filter, and other support file checks.
.TP 5
\fB\-W constraints\fR
Report all UIConstraint errors as warnings.
.TP 5
\fB\-W defaults\fR
Except for size-related options, report all default option errors as warnings.
.TP 5
\fB\-W filters\fR
Report all filter errors as warnings.
.TP 5
\fB\-W profiles\fR
Report all profile errors as warnings.
.TP 5
\fB\-W sizes\fR
Report all media size errors as warnings.
.TP 5
\fB\-W translations\fR
Report all translation errors as warnings.
.TP 5
\fB\-W all\fR
Report all of the previous errors as warnings.
.TP 5
\fB\-W none\fR
Report all of the previous errors as errors.
.TP 5
.B \-q
Specifies that no information should be displayed.
.TP 5
.B \-r
Relaxes the PPD conformance requirements so that common whitespace, control character, and formatting problems are not treated as hard errors.
.TP 5
.B \-v
Specifies that detailed conformance testing results should be displayed rather than the concise PASS/FAIL/ERROR status.
.TP 5
.B \-vv
Specifies that all information in the PPD file should be displayed in addition to the detailed conformance testing results.
.LP
The \fI-q\fR, \fI-v\fR, and \fI-vv\fR options are mutually exclusive.
.SH EXIT STATUS
\fBcupstestppd\fR returns zero on success and non-zero on error.
The error codes are as follows:
.TP 5
1
Bad command-line arguments or missing PPD filename.
.TP 5
2
Unable to open or read PPD file.
.TP 5
3
The PPD file contains format errors that cannot be skipped.
.TP 5
4
The PPD file does not conform to the Adobe PPD specification.
.SH EXAMPLES
The following command will test all PPD files under the current directory and print the names of each file that does not conform:
.nf

    find . \-name \\*.ppd \\! \-exec cupstestppd \-q '{}' \\; \-print

.fi
The next command tests all PPD files under the current directory and print detailed conformance testing results for the files that do not conform:
.nf

    find . \-name \\*.ppd \\! \-exec cupstestppd \-q '{}' \\; \\
        \-exec cupstestppd \-v '{}' \\;
.fi
.SH SEE ALSO
.BR lpadmin (8),
CUPS Online Help (http://localhost:631/help),
Adobe PostScript Printer Description File Format Specification, Version 4.3.
.SH COPYRIGHT
Copyright \[co] 2007-2017 by Apple Inc.
