(function() {
    var type_impls = Object.fromEntries([["core",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#1647-1658\">Source</a><a href=\"#impl-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast_uninit\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#1655-1657\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.cast_uninit\" class=\"fn\">cast_uninit</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"union\" href=\"core/mem/union.MaybeUninit.html\" title=\"union core::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>cast_maybe_uninit</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/145036\">#145036</a>)</span></div></span></summary><div class=\"docblock\"><p>Casts from a type to its maybe-uninitialized version.</p>\n<p>This is always safe, since UB can only occur if the pointer is read\nbefore being initialized.</p>\n</div></details></div></details>",0,"core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#1951-1958\">Source</a><a href=\"#impl-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#1955-1957\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.cast_array\" class=\"fn\">cast_array</a>&lt;const N: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt;(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"primitive\" href=\"core/primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_cast_array</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/144514\">#144514</a>)</span></div></span></summary><div class=\"docblock\"><p>Casts from a pointer-to-<code>T</code> to a pointer-to-<code>[T; N]</code>.</p>\n</div></details></div></details>",0,"core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#8-1645\">Source</a><a href=\"#impl-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_null\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.84.0\">1.0.0 (const: 1.84.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#22-24\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.is_null\" class=\"fn\">is_null</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the pointer is null.</p>\n<p>Note that unsized types have many possible null pointers, as only the\nraw data pointer is considered, not their length, vtable, etc.\nTherefore, two pointers that are null may still not compare equal to\neach other.</p>\n<h5 id=\"panics-during-const-evaluation\"><a class=\"doc-anchor\" href=\"#panics-during-const-evaluation\">§</a>Panics during const evaluation</h5>\n<p>If this method is used during const evaluation, and <code>self</code> is a pointer\nthat is offset beyond the bounds of the memory it initially pointed to,\nthen there might not be enough information to determine whether the\npointer is null. This is because the absolute address in memory is not\nknown at compile time. If the nullness of the pointer cannot be\ndetermined, this method will panic.</p>\n<p>In-bounds pointers are never null, so the method will never panic for\nsuch pointers.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"macro\">assert!</span>(!ptr.is_null());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s+=+%5B1,+2,+3%5D;%0A++++let+ptr:+*mut+u32+=+s.as_mut_ptr();%0A++++assert!(!ptr.is_null());%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.38.0, const since 1.38.0\">1.38.0 (const: 1.38.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#31-33\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.cast\" class=\"fn\">cast</a>&lt;U&gt;(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a></h4></section></summary><div class=\"docblock\"><p>Casts to a pointer of another type.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_cast_aligned\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#57-59\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.try_cast_aligned\" class=\"fn\">try_cast_aligned</a>&lt;U&gt;(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>pointer_try_cast_aligned</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/141221\">#141221</a>)</span></div></span></summary><div class=\"docblock\"><p>Try to cast to a pointer of another type by checking alignment.</p>\n<p>If the pointer is properly aligned to the target type, it will be\ncast to the target type. Otherwise, <code>None</code> is returned.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_try_cast_aligned)]\n\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x = <span class=\"number\">0u64</span>;\n\n<span class=\"kw\">let </span>aligned: <span class=\"kw-2\">*mut </span>u64 = <span class=\"kw-2\">&amp;mut </span>x;\n<span class=\"kw\">let </span>unaligned = <span class=\"kw\">unsafe </span>{ aligned.byte_add(<span class=\"number\">1</span>) };\n\n<span class=\"macro\">assert!</span>(aligned.try_cast_aligned::&lt;u32&gt;().is_some());\n<span class=\"macro\">assert!</span>(unaligned.try_cast_aligned::&lt;u32&gt;().is_none());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_try_cast_aligned)%5D%0A%0A%0Afn+main()+%7B%0A++++let+mut+x+=+0u64;%0A++++%0A++++let+aligned:+*mut+u64+=+%26mut+x;%0A++++let+unaligned+=+unsafe+%7B+aligned.byte_add(1)+%7D;%0A++++%0A++++assert!(aligned.try_cast_aligned::%3Cu32%3E().is_some());%0A++++assert!(unaligned.try_cast_aligned::%3Cu32%3E().is_none());%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_metadata_of\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#113-118\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.with_metadata_of\" class=\"fn\">with_metadata_of</a>&lt;U&gt;(self, meta: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const U</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a><div class=\"where\">where\n    U: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>set_ptr_value</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75091\">#75091</a>)</span></div></span></summary><div class=\"docblock\"><p>Uses the address value in a new pointer of another type.</p>\n<p>This operation will ignore the address part of its <code>meta</code> operand and discard existing\nmetadata of <code>self</code>. For pointers to a sized types (thin pointers), this has the same effect\nas a simple cast. For pointers to an unsized type (fat pointers) this recombines the address\nwith new metadata such as slice lengths or <code>dyn</code>-vtable.</p>\n<p>The resulting pointer will have provenance of <code>self</code>. This operation is semantically the\nsame as creating a new pointer with the data pointer value of <code>self</code> but the metadata of\n<code>meta</code>, being fat or thin depending on the <code>meta</code> operand.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<p>This function is primarily useful for enabling pointer arithmetic on potentially fat\npointers. The pointer is cast to a sized pointee to utilize offset operations and then\nrecombined with its own original metadata.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(set_ptr_value)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>arr: [i32; <span class=\"number\">3</span>] = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr = arr.as_mut_ptr() <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span><span class=\"kw\">dyn </span>Debug;\n<span class=\"kw\">let </span>thin = ptr <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n<span class=\"kw\">unsafe </span>{\n    ptr = thin.add(<span class=\"number\">8</span>).with_metadata_of(ptr);\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{:?}\"</span>, <span class=\"kw-2\">&amp;*</span>ptr); <span class=\"comment\">// will print \"3\"\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(set_ptr_value)%5D%0A%0A%23%5Ballow(unused_extern_crates)%5D%0Aextern+crate+r%23core;%0Afn+main()+%7B%0A++++use+core::fmt::Debug;%0A++++let+mut+arr:+%5Bi32;+3%5D+=+%5B1,+2,+3%5D;%0A++++let+mut+ptr+=+arr.as_mut_ptr()+as+*mut+dyn+Debug;%0A++++let+thin+=+ptr+as+*mut+u8;%0A++++unsafe+%7B%0A++++++++ptr+=+thin.add(8).with_metadata_of(ptr);%0A++++assert_eq!(*(ptr+as+*mut+i32),+3);%0A++++++++println!(%22%7B:?%7D%22,+%26*ptr);+//+will+print+%223%22%0A++++%7D%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div><h5 id=\"incorrect-usage\"><a class=\"doc-anchor\" href=\"#incorrect-usage\">§</a><em>Incorrect</em> usage</h5>\n<p>The provenance from pointers is <em>not</em> combined. The result must only be used to refer to the\naddress allowed by <code>self</code>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(set_ptr_value)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x = <span class=\"number\">0u32</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>y = <span class=\"number\">1u32</span>;\n\n<span class=\"kw\">let </span>x = (<span class=\"kw-2\">&amp;mut </span>x) <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u32;\n<span class=\"kw\">let </span>y = (<span class=\"kw-2\">&amp;mut </span>y) <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u32;\n\n<span class=\"kw\">let </span>offset = (x <span class=\"kw\">as </span>usize - y <span class=\"kw\">as </span>usize) / <span class=\"number\">4</span>;\n<span class=\"kw\">let </span>bad = x.wrapping_add(offset).with_metadata_of(y);\n\n<span class=\"comment\">// This dereference is UB. The pointer only has provenance for `x` but points to `y`.\n</span><span class=\"macro\">println!</span>(<span class=\"string\">\"{:?}\"</span>, <span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">&amp;*</span>bad });</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(set_ptr_value)%5D%0A%0Afn+main()+%7B%0A++++let+mut+x+=+0u32;%0A++++let+mut+y+=+1u32;%0A++++%0A++++let+x+=+(%26mut+x)+as+*mut+u32;%0A++++let+y+=+(%26mut+y)+as+*mut+u32;%0A++++%0A++++let+offset+=+(x+as+usize+-+y+as+usize)+/+4;%0A++++let+bad+=+x.wrapping_add(offset).with_metadata_of(y);%0A++++%0A++++//+This+dereference+is+UB.+The+pointer+only+has+provenance+for+%60x%60+but+points+to+%60y%60.%0A++++println!(%22%7B:?%7D%22,+unsafe+%7B+%26*bad+%7D);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast_const\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.65.0, const since 1.65.0\">1.65.0 (const: 1.65.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#134-136\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.cast_const\" class=\"fn\">cast_const</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a></h4></section></summary><div class=\"docblock\"><p>Changes constness without changing the type.</p>\n<p>This is a bit safer than <code>as</code> because it wouldn’t silently change the type if the code is\nrefactored.</p>\n<p>While not strictly required (<code>*mut T</code> coerces to <code>*const T</code>), this is provided for symmetry\nwith <a href=\"core/primitive.pointer.html#method.cast_mut\" title=\"method pointer::cast_mut\"><code>cast_mut</code></a> on <code>*const T</code> and may have documentation value if used instead of implicit\ncoercion.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.addr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.84.0\">1.84.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#144-151\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.addr\" class=\"fn\">addr</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Gets the “address” portion of the pointer.</p>\n<p>This is similar to <code>self as usize</code>, except that the <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">provenance</a> of\nthe pointer is discarded and not <a href=\"core/ptr/index.html#exposed-provenance\" title=\"mod core::ptr\">exposed</a>. This means that\ncasting the returned address back to a pointer yields a <a href=\"core/ptr/fn.without_provenance_mut.html\" title=\"fn core::ptr::without_provenance_mut\">pointer without\nprovenance</a>, which is undefined behavior to dereference. To properly\nrestore the lost information and obtain a dereferenceable pointer, use\n<a href=\"core/primitive.pointer.html#method.with_addr\" title=\"method pointer::with_addr\"><code>with_addr</code></a> or <a href=\"core/primitive.pointer.html#method.map_addr\" title=\"method pointer::map_addr\"><code>map_addr</code></a>.</p>\n<p>If using those APIs is not possible because there is no way to preserve a pointer with the\nrequired provenance, then Strict Provenance might not be for you. Use pointer-integer casts\nor <a href=\"core/primitive.pointer.html#method.expose_provenance\" title=\"method pointer::expose_provenance\"><code>expose_provenance</code></a> and <a href=\"core/ptr/fn.with_exposed_provenance.html\" title=\"fn core::ptr::with_exposed_provenance\"><code>with_exposed_provenance</code></a>\ninstead. However, note that this makes your code less portable and less amenable to tools\nthat check for compliance with the Rust memory model.</p>\n<p>On most platforms this will produce a value with the same bytes as the original\npointer, because all the bytes are dedicated to describing the address.\nPlatforms which need to store additional information in the pointer may\nperform a change of representation to produce a value containing only the address\nportion of the pointer. What that means is up to the platform to define.</p>\n<p>This is a <a href=\"core/ptr/index.html#strict-provenance\" title=\"mod core::ptr\">Strict Provenance</a> API.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expose_provenance\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.84.0\">1.84.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#177-179\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.expose_provenance\" class=\"fn\">expose_provenance</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Exposes the <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">“provenance”</a> part of the pointer for future use in\n<a href=\"core/ptr/fn.with_exposed_provenance_mut.html\" title=\"fn core::ptr::with_exposed_provenance_mut\"><code>with_exposed_provenance_mut</code></a> and returns the “address” portion.</p>\n<p>This is equivalent to <code>self as usize</code>, which semantically discards provenance information.\nFurthermore, this (like the <code>as</code> cast) has the implicit side-effect of marking the\nprovenance as ‘exposed’, so on platforms that support it you can later call\n<a href=\"core/ptr/fn.with_exposed_provenance_mut.html\" title=\"fn core::ptr::with_exposed_provenance_mut\"><code>with_exposed_provenance_mut</code></a> to reconstitute the original pointer including its provenance.</p>\n<p>Due to its inherent ambiguity, <a href=\"core/ptr/fn.with_exposed_provenance_mut.html\" title=\"fn core::ptr::with_exposed_provenance_mut\"><code>with_exposed_provenance_mut</code></a> may not be supported by tools\nthat help you to stay conformant with the Rust memory model. It is recommended to use\n<a href=\"core/ptr/index.html#strict-provenance\" title=\"mod core::ptr\">Strict Provenance</a> APIs such as <a href=\"core/primitive.pointer.html#method.with_addr\" title=\"method pointer::with_addr\"><code>with_addr</code></a>\nwherever possible, in which case <a href=\"core/primitive.pointer.html#method.addr\" title=\"method pointer::addr\"><code>addr</code></a> should be used instead of <code>expose_provenance</code>.</p>\n<p>On most platforms this will produce a value with the same bytes as the original pointer,\nbecause all the bytes are dedicated to describing the address. Platforms which need to store\nadditional information in the pointer may not support this operation, since the ‘expose’\nside-effect which is required for <a href=\"core/ptr/fn.with_exposed_provenance_mut.html\" title=\"fn core::ptr::with_exposed_provenance_mut\"><code>with_exposed_provenance_mut</code></a> to work is typically not\navailable.</p>\n<p>This is an <a href=\"core/ptr/index.html#exposed-provenance\" title=\"mod core::ptr\">Exposed Provenance</a> API.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_addr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.84.0\">1.84.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#195-203\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.with_addr\" class=\"fn\">with_addr</a>(self, addr: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a new pointer with the given address and the <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">provenance</a> of\n<code>self</code>.</p>\n<p>This is similar to a <code>addr as *mut T</code> cast, but copies\nthe <em>provenance</em> of <code>self</code> to the new pointer.\nThis avoids the inherent ambiguity of the unary cast.</p>\n<p>This is equivalent to using <a href=\"core/primitive.pointer.html#method.wrapping_offset\" title=\"method pointer::wrapping_offset\"><code>wrapping_offset</code></a> to offset\n<code>self</code> to the given address, and therefore has all the same capabilities and restrictions.</p>\n<p>This is a <a href=\"core/ptr/index.html#strict-provenance\" title=\"mod core::ptr\">Strict Provenance</a> API.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_addr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.84.0\">1.84.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#214-216\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.map_addr\" class=\"fn\">map_addr</a>(self, f: impl <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a new pointer by mapping <code>self</code>’s address to a new one, preserving the original\npointer’s <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">provenance</a>.</p>\n<p>This is a convenience for <a href=\"core/primitive.pointer.html#method.with_addr\" title=\"method pointer::with_addr\"><code>with_addr</code></a>, see that method for details.</p>\n<p>This is a <a href=\"core/ptr/index.html#strict-provenance\" title=\"mod core::ptr\">Strict Provenance</a> API.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_raw_parts\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#223-225\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.to_raw_parts\" class=\"fn\">to_raw_parts</a>(self) -&gt; (<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, &lt;T as <a class=\"trait\" href=\"core/ptr/trait.Pointee.html\" title=\"trait core::ptr::Pointee\">Pointee</a>&gt;::<a class=\"associatedtype\" href=\"core/ptr/trait.Pointee.html#associatedtype.Metadata\" title=\"type core::ptr::Pointee::Metadata\">Metadata</a>)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_metadata</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/81513\">#81513</a>)</span></div></span></summary><div class=\"docblock\"><p>Decompose a (possibly wide) pointer into its data pointer and metadata components.</p>\n<p>The pointer can be later reconstructed with <a href=\"core/ptr/fn.from_raw_parts_mut.html\" title=\"fn core::ptr::from_raw_parts_mut\"><code>from_raw_parts_mut</code></a>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0, const since 1.84.0\">1.9.0 (const: 1.84.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#261-265\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_ref\" class=\"fn\">as_ref</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a shared reference to\nthe value wrapped in <code>Some</code>. If the value may be uninitialized, <a href=\"core/primitive.pointer.html#method.as_uninit_ref-1\" title=\"primitive pointer\"><code>as_uninit_ref</code></a>\nmust be used instead.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nthe pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.</p>\n<h5 id=\"panics-during-const-evaluation-1\"><a class=\"doc-anchor\" href=\"#panics-during-const-evaluation-1\">§</a>Panics during const evaluation</h5>\n<p>This method will panic during const evaluation if the pointer cannot be\ndetermined to be null or not. See <a href=\"#method.is_null-1\"><code>is_null</code></a> for more information.</p>\n<h5 id=\"null-unchecked-version\"><a class=\"doc-anchor\" href=\"#null-unchecked-version\">§</a>Null-unchecked version</h5>\n<p>If you are sure the pointer can never be null and are looking for some kind of\n<code>as_ref_unchecked</code> that returns the <code>&amp;T</code> instead of <code>Option&lt;&amp;T&gt;</code>, know that you can\ndereference the pointer directly.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>val_back = <span class=\"kw-2\">&amp;*</span>ptr;\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {val_back}!\"</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A++++%0A++++unsafe+%7B%0A++++++++let+val_back+=+%26*ptr;%0A++++++++println!(%22We+got+back+the+value:+%7Bval_back%7D!%22);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div><h5 id=\"examples-3\"><a class=\"doc-anchor\" href=\"#examples-3\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(val_back) = ptr.as_ref() {\n        <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {val_back}!\"</span>);\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A++++%0A++++unsafe+%7B%0A++++++++if+let+Some(val_back)+=+ptr.as_ref()+%7B%0A++++++++++++println!(%22We+got+back+the+value:+%7Bval_back%7D!%22);%0A++++++++%7D%0A++++%7D%0A%7D&amp;edition=2024\"></a></div><h5 id=\"see-also\"><a class=\"doc-anchor\" href=\"#see-also\">§</a>See Also</h5>\n<p>For the mutable counterpart see <a href=\"#method.as_mut\"><code>as_mut</code></a>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#295-298\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_ref_unchecked\" class=\"fn\">as_ref_unchecked</a>&lt;'a&gt;(self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_ref_unchecked</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/122034\">#122034</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns a shared reference to the value behind the pointer.\nIf the pointer may be null or the value may be uninitialized, <a href=\"#method.as_uninit_ref\"><code>as_uninit_ref</code></a> must be used instead.\nIf the pointer may be null, but the value is known to have been initialized, <a href=\"#method.as_ref\"><code>as_ref</code></a> must be used instead.</p>\n<p>For the mutable counterpart see <a href=\"#method.as_mut_unchecked\"><code>as_mut_unchecked</code></a>.</p>\n<h5 id=\"safety-1\"><a class=\"doc-anchor\" href=\"#safety-1\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that the pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.</p>\n<h5 id=\"examples-4\"><a class=\"doc-anchor\" href=\"#examples-4\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_as_ref_unchecked)]\n</span><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {}!\"</span>, ptr.as_ref_unchecked());\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_as_ref_unchecked)%5D%0A%0Afn+main()+%7B%0A++++let+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A++++%0A++++unsafe+%7B%0A++++++++println!(%22We+got+back+the+value:+%7B%7D!%22,+ptr.as_ref_unchecked());%0A++++%7D%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_uninit_ref\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#325-332\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_uninit_ref\" class=\"fn\">as_uninit_ref</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;&amp;'a <a class=\"union\" href=\"core/mem/union.MaybeUninit.html\" title=\"union core::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_uninit</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75402\">#75402</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a shared reference to\nthe value wrapped in <code>Some</code>. In contrast to <a href=\"core/primitive.pointer.html#method.as_ref-1\" title=\"primitive pointer\"><code>as_ref</code></a>, this does not require\nthat the value has to be initialized.</p>\n<h5 id=\"safety-2\"><a class=\"doc-anchor\" href=\"#safety-2\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nthe pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.\nNote that because the created reference is to <code>MaybeUninit&lt;T&gt;</code>, the\nsource pointer can point to uninitialized memory.</p>\n<h5 id=\"panics-during-const-evaluation-2\"><a class=\"doc-anchor\" href=\"#panics-during-const-evaluation-2\">§</a>Panics during const evaluation</h5>\n<p>This method will panic during const evaluation if the pointer cannot be\ndetermined to be null or not. See <a href=\"#method.is_null-1\"><code>is_null</code></a> for more information.</p>\n<h5 id=\"see-also-1\"><a class=\"doc-anchor\" href=\"#see-also-1\">§</a>See Also</h5>\n<p>For the mutable counterpart see <a href=\"#method.as_uninit_mut\"><code>as_uninit_mut</code></a>.</p>\n<h5 id=\"examples-5\"><a class=\"doc-anchor\" href=\"#examples-5\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_as_uninit)]\n\n</span><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(val_back) = ptr.as_uninit_ref() {\n        <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {}!\"</span>, val_back.assume_init());\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_as_uninit)%5D%0A%0A%0Afn+main()+%7B%0A++++let+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A++++%0A++++unsafe+%7B%0A++++++++if+let+Some(val_back)+=+ptr.as_uninit_ref()+%7B%0A++++++++++++println!(%22We+got+back+the+value:+%7B%7D!%22,+val_back.assume_init());%0A++++++++%7D%0A++++%7D%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.61.0\">1.0.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#352-390\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.offset\" class=\"fn\">offset</a>(self, count: <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Adds a signed offset to a pointer.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-3\"><a class=\"doc-anchor\" href=\"#safety-3\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined Behavior:</p>\n<ul>\n<li>\n<p>The offset in bytes, <code>count * size_of::&lt;T&gt;()</code>, computed on mathematical integers (without\n“wrapping around”), must fit in an <code>isize</code>.</p>\n</li>\n<li>\n<p>If the computed offset is non-zero, then <code>self</code> must be <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">derived from</a> a pointer to some\n<a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a>, and the entire memory range between <code>self</code> and the result must be in\nbounds of that allocation. In particular, this range must not “wrap around” the edge\nof the address space. Note that “range” here refers to a half-open range as usual in Rust,\ni.e., <code>self..result</code> for non-negative offsets and <code>result..self</code> for negative offsets.</p>\n</li>\n</ul>\n<p>Allocations can never be larger than <code>isize::MAX</code> bytes, so if the computed offset\nstays in bounds of the allocation, it is guaranteed to satisfy the first requirement.\nThis implies, for instance, that <code>vec.as_ptr().add(vec.len())</code> (for <code>vec: Vec&lt;T&gt;</code>) is always\nsafe.</p>\n<p>Consider using <a href=\"#method.wrapping_offset\"><code>wrapping_offset</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-6\"><a class=\"doc-anchor\" href=\"#examples-6\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">assert_eq!</span>(<span class=\"number\">2</span>, <span class=\"kw-2\">*</span>ptr.offset(<span class=\"number\">1</span>));\n    <span class=\"macro\">assert_eq!</span>(<span class=\"number\">3</span>, <span class=\"kw-2\">*</span>ptr.offset(<span class=\"number\">2</span>));\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s+=+%5B1,+2,+3%5D;%0A++++let+ptr:+*mut+u32+=+s.as_mut_ptr();%0A++++%0A++++unsafe+%7B%0A++++++++assert_eq!(2,+*ptr.offset(1));%0A++++++++assert_eq!(3,+*ptr.offset(2));%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#407-410\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.byte_offset\" class=\"fn\">byte_offset</a>(self, count: <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Adds a signed offset in bytes to a pointer.</p>\n<p><code>count</code> is in units of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.offset\" title=\"method pointer::offset\">offset</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0, const since 1.61.0\">1.16.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#465-471\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_offset\" class=\"fn\">wrapping_offset</a>(self, count: <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Adds a signed offset to a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-4\"><a class=\"doc-anchor\" href=\"#safety-4\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a> that <code>self</code> points to\n(this is called “<a href=\"ptr/index.html#provenance\">Provenance</a>”).\nThe pointer must not be used to read or write other allocations.</p>\n<p>In other words, <code>let z = x.wrapping_offset((y as isize) - (x as isize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocation.</p>\n<p>Compared to <a href=\"#method.offset\"><code>offset</code></a>, this method basically delays the requirement of staying within the\nsame allocation: <a href=\"#method.offset\"><code>offset</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_offset</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.offset\"><code>offset</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_offset(o).wrapping_offset(o.wrapping_neg())</code> is always the same as <code>x</code>. In other\nwords, leaving the allocation and then re-entering it later is permitted.</p>\n<h5 id=\"examples-7\"><a class=\"doc-anchor\" href=\"#examples-7\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*mut </span>u8 = data.as_mut_ptr();\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>end_rounded_up = ptr.wrapping_offset(<span class=\"number\">6</span>);\n\n<span class=\"kw\">while </span><span class=\"macro\">ptr !</span>= end_rounded_up {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"kw-2\">*</span>ptr = <span class=\"number\">0</span>;\n    }\n    ptr = ptr.wrapping_offset(step);\n}\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>data, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">2</span>, <span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++//+Iterate+using+a+raw+pointer+in+increments+of+two+elements%0A++++let+mut+data+=+%5B1u8,+2,+3,+4,+5%5D;%0A++++let+mut+ptr:+*mut+u8+=+data.as_mut_ptr();%0A++++let+step+=+2;%0A++++let+end_rounded_up+=+ptr.wrapping_offset(6);%0A++++%0A++++while+ptr+!=+end_rounded_up+%7B%0A++++++++unsafe+%7B%0A++++++++++++*ptr+=+0;%0A++++++++%7D%0A++++++++ptr+=+ptr.wrapping_offset(step);%0A++++%7D%0A++++assert_eq!(%26data,+%26%5B0,+2,+0,+4,+0%5D);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#487-489\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_byte_offset\" class=\"fn\">wrapping_byte_offset</a>(self, count: <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Adds a signed offset in bytes to a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.wrapping_offset\" title=\"method pointer::wrapping_offset\">wrapping_offset</a> on it. See that method\nfor documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mask\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#528-530\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.mask\" class=\"fn\">mask</a>(self, mask: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_mask</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/98290\">#98290</a>)</span></div></span></summary><div class=\"docblock\"><p>Masks out bits of the pointer according to a mask.</p>\n<p>This is convenience for <code>ptr.map_addr(|a| a &amp; mask)</code>.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n<h6 id=\"examples-8\"><a class=\"doc-anchor\" href=\"#examples-8\">§</a>Examples</h6>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_mask)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"number\">17_u32</span>;\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = <span class=\"kw-2\">&amp;mut </span>v;\n\n<span class=\"comment\">// `u32` is 4 bytes aligned,\n// which means that lower 2 bits are always 0.\n</span><span class=\"kw\">let </span>tag_mask = <span class=\"number\">0b11</span>;\n<span class=\"kw\">let </span>ptr_mask = !tag_mask;\n\n<span class=\"comment\">// We can store something in these lower bits\n</span><span class=\"kw\">let </span>tagged_ptr = ptr.map_addr(|a| a | <span class=\"number\">0b10</span>);\n\n<span class=\"comment\">// Get the \"tag\" back\n</span><span class=\"kw\">let </span>tag = tagged_ptr.addr() &amp; tag_mask;\n<span class=\"macro\">assert_eq!</span>(tag, <span class=\"number\">0b10</span>);\n\n<span class=\"comment\">// Note that `tagged_ptr` is unaligned, it's UB to read from/write to it.\n// To get original pointer `mask` can be used:\n</span><span class=\"kw\">let </span>masked_ptr = tagged_ptr.mask(ptr_mask);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">*</span>masked_ptr }, <span class=\"number\">17</span>);\n\n<span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">*</span>masked_ptr = <span class=\"number\">0 </span>};\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_mask)%5D%0A%0Afn+main()+%7B%0A++++let+mut+v+=+17_u32;%0A++++let+ptr:+*mut+u32+=+%26mut+v;%0A++++%0A++++//+%60u32%60+is+4+bytes+aligned,%0A++++//+which+means+that+lower+2+bits+are+always+0.%0A++++let+tag_mask+=+0b11;%0A++++let+ptr_mask+=+!tag_mask;%0A++++%0A++++//+We+can+store+something+in+these+lower+bits%0A++++let+tagged_ptr+=+ptr.map_addr(%7Ca%7C+a+%7C+0b10);%0A++++%0A++++//+Get+the+%22tag%22+back%0A++++let+tag+=+tagged_ptr.addr()+%26+tag_mask;%0A++++assert_eq!(tag,+0b10);%0A++++%0A++++//+Note+that+%60tagged_ptr%60+is+unaligned,+it's+UB+to+read+from/write+to+it.%0A++++//+To+get+original+pointer+%60mask%60+can+be+used:%0A++++let+masked_ptr+=+tagged_ptr.mask(ptr_mask);%0A++++assert_eq!(unsafe+%7B+*masked_ptr+%7D,+17);%0A++++%0A++++unsafe+%7B+*masked_ptr+=+0+%7D;%0A++++assert_eq!(v,+0);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0, const since 1.84.0\">1.9.0 (const: 1.84.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#582-586\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_mut\" class=\"fn\">as_mut</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a unique reference to\nthe value wrapped in <code>Some</code>. If the value may be uninitialized, <a href=\"#method.as_uninit_mut\"><code>as_uninit_mut</code></a>\nmust be used instead.</p>\n<p>For the shared counterpart see <a href=\"core/primitive.pointer.html#method.as_ref-1\" title=\"primitive pointer\"><code>as_ref</code></a>.</p>\n<h5 id=\"safety-5\"><a class=\"doc-anchor\" href=\"#safety-5\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em>\nthe pointer is null <em>or</em>\nthe pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.</p>\n<h5 id=\"panics-during-const-evaluation-3\"><a class=\"doc-anchor\" href=\"#panics-during-const-evaluation-3\">§</a>Panics during const evaluation</h5>\n<p>This method will panic during const evaluation if the pointer cannot be\ndetermined to be null or not. See <a href=\"#method.is_null-1\"><code>is_null</code></a> for more information.</p>\n<h5 id=\"examples-9\"><a class=\"doc-anchor\" href=\"#examples-9\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"kw\">let </span>first_value = <span class=\"kw\">unsafe </span>{ ptr.as_mut().unwrap() };\n<span class=\"kw-2\">*</span>first_value = <span class=\"number\">4</span>;\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s:?}\"</span>); <span class=\"comment\">// It'll print: \"[4, 2, 3]\".</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s+=+%5B1,+2,+3%5D;%0A++++let+ptr:+*mut+u32+=+s.as_mut_ptr();%0A++++let+first_value+=+unsafe+%7B+ptr.as_mut().unwrap()+%7D;%0A++++*first_value+=+4;%0A++++assert_eq!(s,+%5B4,+2,+3%5D);%0A++++println!(%22%7Bs:?%7D%22);%0A%7D&amp;edition=2024\"></a></div><h5 id=\"null-unchecked-version-1\"><a class=\"doc-anchor\" href=\"#null-unchecked-version-1\">§</a>Null-unchecked version</h5>\n<p>If you are sure the pointer can never be null and are looking for some kind of\n<code>as_mut_unchecked</code> that returns the <code>&amp;mut T</code> instead of <code>Option&lt;&amp;mut T&gt;</code>, know that\nyou can dereference the pointer directly.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"kw\">let </span>first_value = <span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">&amp;mut *</span>ptr };\n<span class=\"kw-2\">*</span>first_value = <span class=\"number\">4</span>;\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s:?}\"</span>); <span class=\"comment\">// It'll print: \"[4, 2, 3]\".</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s+=+%5B1,+2,+3%5D;%0A++++let+ptr:+*mut+u32+=+s.as_mut_ptr();%0A++++let+first_value+=+unsafe+%7B+%26mut+*ptr+%7D;%0A++++*first_value+=+4;%0A++++assert_eq!(s,+%5B4,+2,+3%5D);%0A++++println!(%22%7Bs:?%7D%22);%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#618-621\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_mut_unchecked\" class=\"fn\">as_mut_unchecked</a>&lt;'a&gt;(self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_ref_unchecked</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/122034\">#122034</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns a unique reference to the value behind the pointer.\nIf the pointer may be null or the value may be uninitialized, <a href=\"#method.as_uninit_mut\"><code>as_uninit_mut</code></a> must be used instead.\nIf the pointer may be null, but the value is known to have been initialized, <a href=\"#method.as_mut\"><code>as_mut</code></a> must be used instead.</p>\n<p>For the shared counterpart see <a href=\"#method.as_mut_unchecked\"><code>as_ref_unchecked</code></a>.</p>\n<h5 id=\"safety-6\"><a class=\"doc-anchor\" href=\"#safety-6\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that\nthe pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.</p>\n<h5 id=\"examples-10\"><a class=\"doc-anchor\" href=\"#examples-10\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_as_ref_unchecked)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"kw\">let </span>first_value = <span class=\"kw\">unsafe </span>{ ptr.as_mut_unchecked() };\n<span class=\"kw-2\">*</span>first_value = <span class=\"number\">4</span>;\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s:?}\"</span>); <span class=\"comment\">// It'll print: \"[4, 2, 3]\".</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_as_ref_unchecked)%5D%0A%0Afn+main()+%7B%0A++++let+mut+s+=+%5B1,+2,+3%5D;%0A++++let+ptr:+*mut+u32+=+s.as_mut_ptr();%0A++++let+first_value+=+unsafe+%7B+ptr.as_mut_unchecked()+%7D;%0A++++*first_value+=+4;%0A++++assert_eq!(s,+%5B4,+2,+3%5D);%0A++++println!(%22%7Bs:?%7D%22);%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_uninit_mut\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#645-652\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.as_uninit_mut\" class=\"fn\">as_uninit_mut</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;&amp;'a mut <a class=\"union\" href=\"core/mem/union.MaybeUninit.html\" title=\"union core::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_uninit</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75402\">#75402</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a unique reference to\nthe value wrapped in <code>Some</code>. In contrast to <a href=\"#method.as_mut\"><code>as_mut</code></a>, this does not require\nthat the value has to be initialized.</p>\n<p>For the shared counterpart see <a href=\"core/primitive.pointer.html#method.as_uninit_ref-1\" title=\"primitive pointer\"><code>as_uninit_ref</code></a>.</p>\n<h5 id=\"safety-7\"><a class=\"doc-anchor\" href=\"#safety-7\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nthe pointer is <a href=\"core/ptr/index.html#pointer-to-reference-conversion\" title=\"mod core::ptr\">convertible to a reference</a>.</p>\n<h5 id=\"panics-during-const-evaluation-4\"><a class=\"doc-anchor\" href=\"#panics-during-const-evaluation-4\">§</a>Panics during const evaluation</h5>\n<p>This method will panic during const evaluation if the pointer cannot be\ndetermined to be null or not. See <a href=\"#method.is_null-1\"><code>is_null</code></a> for more information.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.guaranteed_eq\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#674-679\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.guaranteed_eq\" class=\"fn\">guaranteed_eq</a>(self, other: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a>&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>const_raw_ptr_comparison</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/53020\">#53020</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether two pointers are guaranteed to be equal.</p>\n<p>At runtime this function behaves like <code>Some(self == other)</code>.\nHowever, in some contexts (e.g., compile-time evaluation),\nit is not always possible to determine equality of two pointers, so this function may\nspuriously return <code>None</code> for pointers that later actually turn out to have its equality known.\nBut when it returns <code>Some</code>, the pointers’ equality is guaranteed to be known.</p>\n<p>The return value may change from <code>Some</code> to <code>None</code> and vice versa depending on the compiler\nversion and unsafe code must not\nrely on the result of this function for soundness. It is suggested to only use this function\nfor performance optimizations where spurious <code>None</code> return values by this function do not\naffect the outcome, but just the performance.\nThe consequences of using this method to make runtime and compile-time code behave\ndifferently have not been explored. This method should not be used to introduce such\ndifferences, and it should also not be stabilized before we have a better understanding\nof this issue.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.guaranteed_ne\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#701-706\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"#method.guaranteed_ne\" class=\"fn\">guaranteed_ne</a>(self, other: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a>&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>const_raw_ptr_comparison</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/53020\">#53020</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether two pointers are guaranteed to be inequal.</p>\n<p>At runtime this function behaves like <code>Some(self != other)</code>.\nHowever, in some contexts (e.g., compile-time evaluation),\nit is not always possible to determine inequality of two pointers, so this function may\nspuriously return <code>None</code> for pointers that later actually turn out to have its inequality known.\nBut when it returns <code>Some</code>, the pointers’ inequality is guaranteed to be known.</p>\n<p>The return value may change from <code>Some</code> to <code>None</code> and vice versa depending on the compiler\nversion and unsafe code must not\nrely on the result of this function for soundness. It is suggested to only use this function\nfor performance optimizations where spurious <code>None</code> return values by this function do not\naffect the outcome, but just the performance.\nThe consequences of using this method to make runtime and compile-time code behave\ndifferently have not been explored. This method should not be used to introduce such\ndifferences, and it should also not be stabilized before we have a better understanding\nof this issue.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.offset_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0, const since 1.65.0\">1.47.0 (const: 1.65.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#793-799\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.offset_from\" class=\"fn\">offset_from</a>(self, origin: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers within the same allocation. The returned value is in\nunits of T: the distance in bytes divided by <code>size_of::&lt;T&gt;()</code>.</p>\n<p>This is equivalent to <code>(self as isize - origin as isize) / (size_of::&lt;T&gt;() as isize)</code>,\nexcept that it has a lot more opportunities for UB, in exchange for the compiler\nbetter understanding what you are doing.</p>\n<p>The primary motivation of this method is for computing the <code>len</code> of an array/slice\nof <code>T</code> that you are currently representing as a “start” and “end” pointer\n(and “end” is “one past the end” of the array).\nIn that case, <code>end.offset_from(start)</code> gets you the length of the array.</p>\n<p>All of the following safety requirements are trivially satisfied for this usecase.</p>\n<h5 id=\"safety-8\"><a class=\"doc-anchor\" href=\"#safety-8\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined Behavior:</p>\n<ul>\n<li>\n<p><code>self</code> and <code>origin</code> must either</p>\n<ul>\n<li>point to the same address, or</li>\n<li>both be <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">derived from</a> a pointer to the same <a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a>, and the memory range between\nthe two pointers must be in bounds of that object. (See below for an example.)</li>\n</ul>\n</li>\n<li>\n<p>The distance between the pointers, in bytes, must be an exact multiple\nof the size of <code>T</code>.</p>\n</li>\n</ul>\n<p>As a consequence, the absolute distance between the pointers, in bytes, computed on\nmathematical integers (without “wrapping around”), cannot overflow an <code>isize</code>. This is\nimplied by the in-bounds requirement, and the fact that no allocation can be larger\nthan <code>isize::MAX</code> bytes.</p>\n<p>The requirement for pointers to be derived from the same allocation is primarily\nneeded for <code>const</code>-compatibility: the distance between pointers into <em>different</em> allocated\nobjects is not known at compile-time. However, the requirement also exists at\nruntime and may be exploited by optimizations. If you wish to compute the difference between\npointers that are not guaranteed to be from the same allocation, use <code>(self as isize - origin as isize) / size_of::&lt;T&gt;()</code>.</p>\n<h5 id=\"panics\"><a class=\"doc-anchor\" href=\"#panics\">§</a>Panics</h5>\n<p>This function panics if <code>T</code> is a Zero-Sized Type (“ZST”).</p>\n<h5 id=\"examples-11\"><a class=\"doc-anchor\" href=\"#examples-11\">§</a>Examples</h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>a = [<span class=\"number\">0</span>; <span class=\"number\">5</span>];\n<span class=\"kw\">let </span>ptr1: <span class=\"kw-2\">*mut </span>i32 = <span class=\"kw-2\">&amp;mut </span>a[<span class=\"number\">1</span>];\n<span class=\"kw\">let </span>ptr2: <span class=\"kw-2\">*mut </span>i32 = <span class=\"kw-2\">&amp;mut </span>a[<span class=\"number\">3</span>];\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset_from(ptr1), <span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.offset_from(ptr2), -<span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.offset(<span class=\"number\">2</span>), ptr2);\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset(-<span class=\"number\">2</span>), ptr1);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+a+=+%5B0;+5%5D;%0A++++let+ptr1:+*mut+i32+=+%26mut+a%5B1%5D;%0A++++let+ptr2:+*mut+i32+=+%26mut+a%5B3%5D;%0A++++unsafe+%7B%0A++++++++assert_eq!(ptr2.offset_from(ptr1),+2);%0A++++++++assert_eq!(ptr1.offset_from(ptr2),+-2);%0A++++++++assert_eq!(ptr1.offset(2),+ptr2);%0A++++++++assert_eq!(ptr2.offset(-2),+ptr1);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div>\n<p><em>Incorrect</em> usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr1 = Box::into_raw(Box::new(<span class=\"number\">0u8</span>));\n<span class=\"kw\">let </span>ptr2 = Box::into_raw(Box::new(<span class=\"number\">1u8</span>));\n<span class=\"kw\">let </span>diff = (ptr2 <span class=\"kw\">as </span>isize).wrapping_sub(ptr1 <span class=\"kw\">as </span>isize);\n<span class=\"comment\">// Make ptr2_other an \"alias\" of ptr2.add(1), but derived from ptr1.\n</span><span class=\"kw\">let </span>ptr2_other = (ptr1 <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8).wrapping_offset(diff).wrapping_offset(<span class=\"number\">1</span>);\n<span class=\"macro\">assert_eq!</span>(ptr2 <span class=\"kw\">as </span>usize, ptr2_other <span class=\"kw\">as </span>usize);\n<span class=\"comment\">// Since ptr2_other and ptr2 are derived from pointers to different objects,\n// computing their offset is undefined behavior, even though\n// they point to addresses that are in-bounds of the same object!\n</span><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>one = ptr2_other.offset_from(ptr2); <span class=\"comment\">// Undefined Behavior! ⚠️\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+ptr1+=+Box::into_raw(Box::new(0u8));%0A++++let+ptr2+=+Box::into_raw(Box::new(1u8));%0A++++let+diff+=+(ptr2+as+isize).wrapping_sub(ptr1+as+isize);%0A++++//+Make+ptr2_other+an+%22alias%22+of+ptr2.add(1),+but+derived+from+ptr1.%0A++++let+ptr2_other+=+(ptr1+as+*mut+u8).wrapping_offset(diff).wrapping_offset(1);%0A++++assert_eq!(ptr2+as+usize,+ptr2_other+as+usize);%0A++++//+Since+ptr2_other+and+ptr2+are+derived+from+pointers+to+different+objects,%0A++++//+computing+their+offset+is+undefined+behavior,+even+though%0A++++//+they+point+to+addresses+that+are+in-bounds+of+the+same+object!%0A++++unsafe+%7B%0A++++++++let+one+=+ptr2_other.offset_from(ptr2);+//+Undefined+Behavior!+%E2%9A%A0%EF%B8%8F%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_offset_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#814-817\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.byte_offset_from\" class=\"fn\">byte_offset_from</a>&lt;U: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>&gt;(self, origin: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const U</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers within the same allocation. The returned value is in\nunits of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.offset_from\" title=\"method pointer::offset_from\"><code>offset_from</code></a> on it. See that method for\ndocumentation and safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation considers only the data pointers,\nignoring the metadata.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.offset_from_unsigned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.87.0, const since 1.87.0\">1.87.0 (const: 1.87.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#882-888\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.offset_from_unsigned\" class=\"fn\">offset_from_unsigned</a>(self, origin: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers within the same allocation, <em>where it’s known that\n<code>self</code> is equal to or greater than <code>origin</code></em>. The returned value is in\nunits of T: the distance in bytes is divided by <code>size_of::&lt;T&gt;()</code>.</p>\n<p>This computes the same value that <a href=\"#method.offset_from\"><code>offset_from</code></a>\nwould compute, but with the added precondition that the offset is\nguaranteed to be non-negative.  This method is equivalent to\n<code>usize::try_from(self.offset_from(origin)).unwrap_unchecked()</code>,\nbut it provides slightly more information to the optimizer, which can\nsometimes allow it to optimize slightly better with some backends.</p>\n<p>This method can be thought of as recovering the <code>count</code> that was passed\nto <a href=\"#method.add\"><code>add</code></a> (or, with the parameters in the other order,\nto <a href=\"#method.sub\"><code>sub</code></a>).  The following are all equivalent, assuming\nthat their safety preconditions are met:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>ptr.offset_from_unsigned(origin) == count\norigin.add(count) == ptr\nptr.sub(count) == origin</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++unsafe+fn+blah(ptr:+*mut+i32,+origin:+*mut+i32,+count:+usize)+-%3E+bool+%7B+unsafe+%7B%0A++++ptr.offset_from_unsigned(origin)+==+count%0A++++%26%26%0A++++origin.add(count)+==+ptr%0A++++%26%26%0A++++ptr.sub(count)+==+origin%0A++++%7D+%7D%0A%7D&amp;edition=2024\"></a></div><h5 id=\"safety-9\"><a class=\"doc-anchor\" href=\"#safety-9\">§</a>Safety</h5>\n<ul>\n<li>\n<p>The distance between the pointers must be non-negative (<code>self &gt;= origin</code>)</p>\n</li>\n<li>\n<p><em>All</em> the safety conditions of <a href=\"#method.offset_from\"><code>offset_from</code></a>\napply to this method as well; see it for the full details.</p>\n</li>\n</ul>\n<p>Importantly, despite the return type of this method being able to represent\na larger offset, it’s still <em>not permitted</em> to pass pointers which differ\nby more than <code>isize::MAX</code> <em>bytes</em>.  As such, the result of this method will\nalways be less than or equal to <code>isize::MAX as usize</code>.</p>\n<h5 id=\"panics-1\"><a class=\"doc-anchor\" href=\"#panics-1\">§</a>Panics</h5>\n<p>This function panics if <code>T</code> is a Zero-Sized Type (“ZST”).</p>\n<h5 id=\"examples-12\"><a class=\"doc-anchor\" href=\"#examples-12\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>a = [<span class=\"number\">0</span>; <span class=\"number\">5</span>];\n<span class=\"kw\">let </span>p: <span class=\"kw-2\">*mut </span>i32 = a.as_mut_ptr();\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>ptr1: <span class=\"kw-2\">*mut </span>i32 = p.add(<span class=\"number\">1</span>);\n    <span class=\"kw\">let </span>ptr2: <span class=\"kw-2\">*mut </span>i32 = p.add(<span class=\"number\">3</span>);\n\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset_from_unsigned(ptr1), <span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.add(<span class=\"number\">2</span>), ptr2);\n    <span class=\"macro\">assert_eq!</span>(ptr2.sub(<span class=\"number\">2</span>), ptr1);\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset_from_unsigned(ptr2), <span class=\"number\">0</span>);\n}\n\n<span class=\"comment\">// This would be incorrect, as the pointers are not correctly ordered:\n// ptr1.offset_from(ptr2)</span></code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+a+=+%5B0;+5%5D;%0A++++let+p:+*mut+i32+=+a.as_mut_ptr();%0A++++unsafe+%7B%0A++++++++let+ptr1:+*mut+i32+=+p.add(1);%0A++++++++let+ptr2:+*mut+i32+=+p.add(3);%0A++++%0A++++++++assert_eq!(ptr2.offset_from_unsigned(ptr1),+2);%0A++++++++assert_eq!(ptr1.add(2),+ptr2);%0A++++++++assert_eq!(ptr2.sub(2),+ptr1);%0A++++++++assert_eq!(ptr2.offset_from_unsigned(ptr2),+0);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_offset_from_unsigned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.87.0, const since 1.87.0\">1.87.0 (const: 1.87.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#904-907\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.byte_offset_from_unsigned\" class=\"fn\">byte_offset_from_unsigned</a>&lt;U: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>&gt;(\n    self,\n    origin: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a>,\n) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers within the same allocation, <em>where it’s known that\n<code>self</code> is equal to or greater than <code>origin</code></em>. The returned value is in\nunits of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.offset_from_unsigned\" title=\"method pointer::offset_from_unsigned\"><code>offset_from_unsigned</code></a> on it.\nSee that method for documentation and safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation considers only the data pointers,\nignoring the metadata.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#927-962\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.add\" class=\"fn\">add</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Adds an unsigned offset to a pointer.</p>\n<p>This can only move the pointer forward (or not move it). If you need to move forward or\nbackward depending on the value, then you might want <a href=\"#method.offset\"><code>offset</code></a> instead\nwhich takes a signed offset.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-10\"><a class=\"doc-anchor\" href=\"#safety-10\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined Behavior:</p>\n<ul>\n<li>\n<p>The offset in bytes, <code>count * size_of::&lt;T&gt;()</code>, computed on mathematical integers (without\n“wrapping around”), must fit in an <code>isize</code>.</p>\n</li>\n<li>\n<p>If the computed offset is non-zero, then <code>self</code> must be <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">derived from</a> a pointer to some\n<a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a>, and the entire memory range between <code>self</code> and the result must be in\nbounds of that allocation. In particular, this range must not “wrap around” the edge\nof the address space.</p>\n</li>\n</ul>\n<p>Allocations can never be larger than <code>isize::MAX</code> bytes, so if the computed offset\nstays in bounds of the allocation, it is guaranteed to satisfy the first requirement.\nThis implies, for instance, that <code>vec.as_ptr().add(vec.len())</code> (for <code>vec: Vec&lt;T&gt;</code>) is always\nsafe.</p>\n<p>Consider using <a href=\"#method.wrapping_add\"><code>wrapping_add</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-13\"><a class=\"doc-anchor\" href=\"#examples-13\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s: String = <span class=\"string\">\"123\"</span>.to_string();\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = s.as_mut_ptr();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">assert_eq!</span>(<span class=\"string\">'2'</span>, <span class=\"kw-2\">*</span>ptr.add(<span class=\"number\">1</span>) <span class=\"kw\">as </span>char);\n    <span class=\"macro\">assert_eq!</span>(<span class=\"string\">'3'</span>, <span class=\"kw-2\">*</span>ptr.add(<span class=\"number\">2</span>) <span class=\"kw\">as </span>char);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+mut+s:+String+=+%22123%22.to_string();%0A++++let+ptr:+*mut+u8+=+s.as_mut_ptr();%0A++++%0A++++unsafe+%7B%0A++++++++assert_eq!('2',+*ptr.add(1)+as+char);%0A++++++++assert_eq!('3',+*ptr.add(2)+as+char);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#979-982\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.byte_add\" class=\"fn\">byte_add</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Adds an unsigned offset in bytes to a pointer.</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.add\" title=\"method pointer::add\">add</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1033-1074\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.sub\" class=\"fn\">sub</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Subtracts an unsigned offset from a pointer.</p>\n<p>This can only move the pointer backward (or not move it). If you need to move forward or\nbackward depending on the value, then you might want <a href=\"#method.offset\"><code>offset</code></a> instead\nwhich takes a signed offset.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-11\"><a class=\"doc-anchor\" href=\"#safety-11\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined Behavior:</p>\n<ul>\n<li>\n<p>The offset in bytes, <code>count * size_of::&lt;T&gt;()</code>, computed on mathematical integers (without\n“wrapping around”), must fit in an <code>isize</code>.</p>\n</li>\n<li>\n<p>If the computed offset is non-zero, then <code>self</code> must be <a href=\"core/ptr/index.html#provenance\" title=\"mod core::ptr\">derived from</a> a pointer to some\n<a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a>, and the entire memory range between <code>self</code> and the result must be in\nbounds of that allocation. In particular, this range must not “wrap around” the edge\nof the address space.</p>\n</li>\n</ul>\n<p>Allocations can never be larger than <code>isize::MAX</code> bytes, so if the computed offset\nstays in bounds of the allocation, it is guaranteed to satisfy the first requirement.\nThis implies, for instance, that <code>vec.as_ptr().add(vec.len())</code> (for <code>vec: Vec&lt;T&gt;</code>) is always\nsafe.</p>\n<p>Consider using <a href=\"#method.wrapping_sub\"><code>wrapping_sub</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-14\"><a class=\"doc-anchor\" href=\"#examples-14\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>s: <span class=\"kw-2\">&amp;</span>str = <span class=\"string\">\"123\"</span>;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>end: <span class=\"kw-2\">*const </span>u8 = s.as_ptr().add(<span class=\"number\">3</span>);\n    <span class=\"macro\">assert_eq!</span>(<span class=\"string\">'3'</span>, <span class=\"kw-2\">*</span>end.sub(<span class=\"number\">1</span>) <span class=\"kw\">as </span>char);\n    <span class=\"macro\">assert_eq!</span>(<span class=\"string\">'2'</span>, <span class=\"kw-2\">*</span>end.sub(<span class=\"number\">2</span>) <span class=\"kw\">as </span>char);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++let+s:+%26str+=+%22123%22;%0A++++%0A++++unsafe+%7B%0A++++++++let+end:+*const+u8+=+s.as_ptr().add(3);%0A++++++++assert_eq!('3',+*end.sub(1)+as+char);%0A++++++++assert_eq!('2',+*end.sub(2)+as+char);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1091-1094\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.byte_sub\" class=\"fn\">byte_sub</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Subtracts an unsigned offset in bytes from a pointer.</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.sub\" title=\"method pointer::sub\">sub</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1148-1153\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_add\" class=\"fn\">wrapping_add</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Adds an unsigned offset to a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-12\"><a class=\"doc-anchor\" href=\"#safety-12\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a> that <code>self</code> points to; it must not\nbe used to read or write other allocations.</p>\n<p>In other words, <code>let z = x.wrapping_add((y as usize) - (x as usize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocation.</p>\n<p>Compared to <a href=\"#method.add\"><code>add</code></a>, this method basically delays the requirement of staying within the\nsame allocation: <a href=\"#method.add\"><code>add</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_add</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.add\"><code>add</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_add(o).wrapping_sub(o)</code> is always the same as <code>x</code>. In other words, leaving the\nallocation and then re-entering it later is permitted.</p>\n<h5 id=\"examples-15\"><a class=\"doc-anchor\" href=\"#examples-15\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements\n</span><span class=\"kw\">let </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*const </span>u8 = data.as_ptr();\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>end_rounded_up = ptr.wrapping_add(<span class=\"number\">6</span>);\n\n<span class=\"comment\">// This loop prints \"1, 3, 5, \"\n</span><span class=\"kw\">while </span><span class=\"macro\">ptr !</span>= end_rounded_up {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"macro\">print!</span>(<span class=\"string\">\"{}, \"</span>, <span class=\"kw-2\">*</span>ptr);\n    }\n    ptr = ptr.wrapping_add(step);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++//+Iterate+using+a+raw+pointer+in+increments+of+two+elements%0A++++let+data+=+%5B1u8,+2,+3,+4,+5%5D;%0A++++let+mut+ptr:+*const+u8+=+data.as_ptr();%0A++++let+step+=+2;%0A++++let+end_rounded_up+=+ptr.wrapping_add(6);%0A++++%0A++++//+This+loop+prints+%221,+3,+5,+%22%0A++++while+ptr+!=+end_rounded_up+%7B%0A++++++++unsafe+%7B%0A++++++++++++print!(%22%7B%7D,+%22,+*ptr);%0A++++++++%7D%0A++++++++ptr+=+ptr.wrapping_add(step);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1168-1170\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_byte_add\" class=\"fn\">wrapping_byte_add</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Adds an unsigned offset in bytes to a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.wrapping_add\" title=\"method pointer::wrapping_add\">wrapping_add</a> on it. See that method for documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1224-1229\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_sub\" class=\"fn\">wrapping_sub</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Subtracts an unsigned offset from a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-13\"><a class=\"doc-anchor\" href=\"#safety-13\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"core/ptr/index.html#allocation\" title=\"mod core::ptr\">allocation</a> that <code>self</code> points to; it must not\nbe used to read or write other allocations.</p>\n<p>In other words, <code>let z = x.wrapping_sub((x as usize) - (y as usize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocation.</p>\n<p>Compared to <a href=\"#method.sub\"><code>sub</code></a>, this method basically delays the requirement of staying within the\nsame allocation: <a href=\"#method.sub\"><code>sub</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_sub</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.sub\"><code>sub</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_add(o).wrapping_sub(o)</code> is always the same as <code>x</code>. In other words, leaving the\nallocation and then re-entering it later is permitted.</p>\n<h5 id=\"examples-16\"><a class=\"doc-anchor\" href=\"#examples-16\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements (backwards)\n</span><span class=\"kw\">let </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*const </span>u8 = data.as_ptr();\n<span class=\"kw\">let </span>start_rounded_down = ptr.wrapping_sub(<span class=\"number\">2</span>);\nptr = ptr.wrapping_add(<span class=\"number\">4</span>);\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"comment\">// This loop prints \"5, 3, 1, \"\n</span><span class=\"kw\">while </span><span class=\"macro\">ptr !</span>= start_rounded_down {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"macro\">print!</span>(<span class=\"string\">\"{}, \"</span>, <span class=\"kw-2\">*</span>ptr);\n    }\n    ptr = ptr.wrapping_sub(step);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++//+Iterate+using+a+raw+pointer+in+increments+of+two+elements+(backwards)%0A++++let+data+=+%5B1u8,+2,+3,+4,+5%5D;%0A++++let+mut+ptr:+*const+u8+=+data.as_ptr();%0A++++let+start_rounded_down+=+ptr.wrapping_sub(2);%0A++++ptr+=+ptr.wrapping_add(4);%0A++++let+step+=+2;%0A++++//+This+loop+prints+%225,+3,+1,+%22%0A++++while+ptr+!=+start_rounded_down+%7B%0A++++++++unsafe+%7B%0A++++++++++++print!(%22%7B%7D,+%22,+*ptr);%0A++++++++%7D%0A++++++++ptr+=+ptr.wrapping_sub(step);%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1244-1246\">Source</a></span><h4 class=\"code-header\">pub const fn <a href=\"#method.wrapping_byte_sub\" class=\"fn\">wrapping_byte_sub</a>(self, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Subtracts an unsigned offset in bytes from a pointer using wrapping arithmetic.</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"core/primitive.pointer.html#method.wrapping_sub\" title=\"method pointer::wrapping_sub\">wrapping_sub</a> on it. See that method for documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.71.0\">1.26.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1258-1264\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.read\" class=\"fn\">read</a>(self) -&gt; T<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Reads the value from <code>self</code> without moving it. This leaves the\nmemory in <code>self</code> unchanged.</p>\n<p>See <a href=\"core/ptr/fn.read.html\" title=\"fn core::ptr::read\"><code>ptr::read</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_volatile\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1279-1285\">Source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.read_volatile\" class=\"fn\">read_volatile</a>(self) -&gt; T<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Performs a volatile read of the value from <code>self</code> without moving it. This\nleaves the memory in <code>self</code> unchanged.</p>\n<p>Volatile operations are intended to act on I/O memory, and are guaranteed\nto not be elided or reordered by the compiler across other volatile\noperations.</p>\n<p>See <a href=\"core/ptr/fn.read_volatile.html\" title=\"fn core::ptr::read_volatile\"><code>ptr::read_volatile</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_unaligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.71.0\">1.26.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1299-1305\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.read_unaligned\" class=\"fn\">read_unaligned</a>(self) -&gt; T<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Reads the value from <code>self</code> without moving it. This leaves the\nmemory in <code>self</code> unchanged.</p>\n<p>Unlike <code>read</code>, the pointer may be unaligned.</p>\n<p>See <a href=\"core/ptr/fn.read_unaligned.html\" title=\"fn core::ptr::read_unaligned\"><code>ptr::read_unaligned</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1319-1325\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.copy_to\" class=\"fn\">copy_to</a>(self, dest: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of::&lt;T&gt;()</code> bytes from <code>self</code> to <code>dest</code>. The source\nand destination may overlap.</p>\n<p>NOTE: this has the <em>same</em> argument order as <a href=\"core/ptr/fn.copy.html\" title=\"fn core::ptr::copy\"><code>ptr::copy</code></a>.</p>\n<p>See <a href=\"core/ptr/fn.copy.html\" title=\"fn core::ptr::copy\"><code>ptr::copy</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to_nonoverlapping\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1339-1345\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.copy_to_nonoverlapping\" class=\"fn\">copy_to_nonoverlapping</a>(self, dest: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of::&lt;T&gt;()</code> bytes from <code>self</code> to <code>dest</code>. The source\nand destination may <em>not</em> overlap.</p>\n<p>NOTE: this has the <em>same</em> argument order as <a href=\"core/ptr/fn.copy_nonoverlapping.html\" title=\"fn core::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a>.</p>\n<p>See <a href=\"core/ptr/fn.copy_nonoverlapping.html\" title=\"fn core::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1359-1365\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.copy_from\" class=\"fn\">copy_from</a>(self, src: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a>, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of::&lt;T&gt;()</code> bytes from <code>src</code> to <code>self</code>. The source\nand destination may overlap.</p>\n<p>NOTE: this has the <em>opposite</em> argument order of <a href=\"core/ptr/fn.copy.html\" title=\"fn core::ptr::copy\"><code>ptr::copy</code></a>.</p>\n<p>See <a href=\"core/ptr/fn.copy.html\" title=\"fn core::ptr::copy\"><code>ptr::copy</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_from_nonoverlapping\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1379-1385\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.copy_from_nonoverlapping\" class=\"fn\">copy_from_nonoverlapping</a>(self, src: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a>, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of::&lt;T&gt;()</code> bytes from <code>src</code> to <code>self</code>. The source\nand destination may <em>not</em> overlap.</p>\n<p>NOTE: this has the <em>opposite</em> argument order of <a href=\"core/ptr/fn.copy_nonoverlapping.html\" title=\"fn core::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a>.</p>\n<p>See <a href=\"core/ptr/fn.copy_nonoverlapping.html\" title=\"fn core::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop_in_place\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const unstable\">1.26.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/109342\" title=\"Tracking issue for const_drop_in_place\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1395-1401\">Source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.drop_in_place\" class=\"fn\">drop_in_place</a>(self)<div class=\"where\">where\n    T:,</div></h4></section></summary><div class=\"docblock\"><p>Executes the destructor (if any) of the pointed-to value.</p>\n<p>See <a href=\"core/ptr/fn.drop_in_place.html\" title=\"fn core::ptr::drop_in_place\"><code>ptr::drop_in_place</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1413-1419\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.write\" class=\"fn\">write</a>(self, val: T)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Overwrites a memory location with the given value without reading or\ndropping the old value.</p>\n<p>See <a href=\"core/ptr/fn.write.html\" title=\"fn core::ptr::write\"><code>ptr::write</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1432-1438\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.write_bytes\" class=\"fn\">write_bytes</a>(self, val: <a class=\"primitive\" href=\"core/primitive.u8.html\">u8</a>, count: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Invokes memset on the specified pointer, setting <code>count * size_of::&lt;T&gt;()</code>\nbytes of memory starting at <code>self</code> to <code>val</code>.</p>\n<p>See <a href=\"core/ptr/fn.write_bytes.html\" title=\"fn core::ptr::write_bytes\"><code>ptr::write_bytes</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_volatile\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1453-1459\">Source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.write_volatile\" class=\"fn\">write_volatile</a>(self, val: T)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.</p>\n<p>Volatile operations are intended to act on I/O memory, and are guaranteed\nto not be elided or reordered by the compiler across other volatile\noperations.</p>\n<p>See <a href=\"core/ptr/fn.write_volatile.html\" title=\"fn core::ptr::write_volatile\"><code>ptr::write_volatile</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_unaligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.83.0\">1.26.0 (const: 1.83.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1473-1479\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.write_unaligned\" class=\"fn\">write_unaligned</a>(self, val: T)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Overwrites a memory location with the given value without reading or\ndropping the old value.</p>\n<p>Unlike <code>write</code>, the pointer may be unaligned.</p>\n<p>See <a href=\"core/ptr/fn.write_unaligned.html\" title=\"fn core::ptr::write_unaligned\"><code>ptr::write_unaligned</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.replace\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.88.0\">1.26.0 (const: 1.88.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1490-1496\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.replace\" class=\"fn\">replace</a>(self, src: T) -&gt; T<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Replaces the value at <code>self</code> with <code>src</code>, returning the old\nvalue, without dropping either.</p>\n<p>See <a href=\"core/ptr/fn.replace.html\" title=\"fn core::ptr::replace\"><code>ptr::replace</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.85.0\">1.26.0 (const: 1.85.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1508-1514\">Source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.swap\" class=\"fn\">swap</a>(self, with: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>)<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike <code>mem::swap</code> which is\notherwise equivalent.</p>\n<p>See <a href=\"core/ptr/fn.swap.html\" title=\"fn core::ptr::swap\"><code>ptr::swap</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.align_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.36.0\">1.36.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1557-1578\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.align_offset\" class=\"fn\">align_offset</a>(self, align: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Computes the offset that needs to be applied to the pointer in order to make it aligned to\n<code>align</code>.</p>\n<p>If it is not possible to align the pointer, the implementation returns\n<code>usize::MAX</code>.</p>\n<p>The offset is expressed in number of <code>T</code> elements, and not bytes. The value returned can be\nused with the <code>wrapping_add</code> method.</p>\n<p>There are no guarantees whatsoever that offsetting the pointer will not overflow or go\nbeyond the allocation that the pointer points into. It is up to the caller to ensure that\nthe returned offset is correct in all terms other than alignment.</p>\n<h5 id=\"panics-2\"><a class=\"doc-anchor\" href=\"#panics-2\">§</a>Panics</h5>\n<p>The function panics if <code>align</code> is not a power-of-two.</p>\n<h5 id=\"examples-17\"><a class=\"doc-anchor\" href=\"#examples-17\">§</a>Examples</h5>\n<p>Accessing adjacent <code>u8</code> as <code>u16</code></p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x = [<span class=\"number\">5_u8</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>ptr = x.as_mut_ptr();\n<span class=\"kw\">let </span>offset = ptr.align_offset(align_of::&lt;u16&gt;());\n\n<span class=\"kw\">if </span>offset &lt; x.len() - <span class=\"number\">1 </span>{\n    <span class=\"kw\">let </span>u16_ptr = ptr.add(offset).cast::&lt;u16&gt;();\n    <span class=\"kw-2\">*</span>u16_ptr = <span class=\"number\">0</span>;\n\n    <span class=\"macro\">assert!</span>(x == [<span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>] || x == [<span class=\"number\">5</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>]);\n} <span class=\"kw\">else </span>{\n    <span class=\"comment\">// while the pointer can be aligned via `offset`, it would point\n    // outside the allocation\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++unsafe+%7B%0A++++let+mut+x+=+%5B5_u8,+6,+7,+8,+9%5D;%0A++++let+ptr+=+x.as_mut_ptr();%0A++++let+offset+=+ptr.align_offset(align_of::%3Cu16%3E());%0A++++%0A++++if+offset+%3C+x.len()+-+1+%7B%0A++++++++let+u16_ptr+=+ptr.add(offset).cast::%3Cu16%3E();%0A++++++++*u16_ptr+=+0;%0A++++%0A++++++++assert!(x+==+%5B0,+0,+7,+8,+9%5D+%7C%7C+x+==+%5B5,+0,+0,+8,+9%5D);%0A++++%7D+else+%7B%0A++++++++//+while+the+pointer+can+be+aligned+via+%60offset%60,+it+would+point%0A++++++++//+outside+the+allocation%0A++++%7D%0A++++%7D%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_aligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.79.0\">1.79.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1598-1603\">Source</a></span><h4 class=\"code-header\">pub fn <a href=\"#method.is_aligned\" class=\"fn\">is_aligned</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Returns whether the pointer is properly aligned for <code>T</code>.</p>\n<h5 id=\"examples-18\"><a class=\"doc-anchor\" href=\"#examples-18\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n\n<span class=\"macro\">assert!</span>(ptr.is_aligned());\n<span class=\"macro\">assert!</span>(!ptr.wrapping_byte_add(<span class=\"number\">1</span>).is_aligned());</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0A++++//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0A++++%23%5Brepr(align(4))%5D%0A++++struct+AlignedI32(i32);%0A++++%0A++++let+mut+data+=+AlignedI32(42);%0A++++let+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A++++%0A++++assert!(ptr.is_aligned());%0A++++assert!(!ptr.wrapping_byte_add(1).is_aligned());%0A%7D&amp;edition=2024\"></a></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_aligned_to\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#1638-1644\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.is_aligned_to\" class=\"fn\">is_aligned_to</a>(self, align: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>pointer_is_aligned_to</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/96284\">#96284</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether the pointer is aligned to <code>align</code>.</p>\n<p>For non-<code>Sized</code> pointees this operation considers only the data pointer,\nignoring the metadata.</p>\n<h5 id=\"panics-3\"><a class=\"doc-anchor\" href=\"#panics-3\">§</a>Panics</h5>\n<p>The function panics if <code>align</code> is not a power-of-two (this includes 0).</p>\n<h5 id=\"examples-19\"><a class=\"doc-anchor\" href=\"#examples-19\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned_to)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">1</span>));\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">2</span>));\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">4</span>));\n\n<span class=\"macro\">assert!</span>(ptr.wrapping_byte_add(<span class=\"number\">2</span>).is_aligned_to(<span class=\"number\">2</span>));\n<span class=\"macro\">assert!</span>(!ptr.wrapping_byte_add(<span class=\"number\">2</span>).is_aligned_to(<span class=\"number\">4</span>));\n\n<span class=\"macro\">assert_ne!</span>(ptr.is_aligned_to(<span class=\"number\">8</span>), ptr.wrapping_add(<span class=\"number\">1</span>).is_aligned_to(<span class=\"number\">8</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" title=\"Run code\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned_to)%5D%0A%0A%0A//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0Afn+main()+%7B%0A++++%23%5Brepr(align(4))%5D%0A++++struct+AlignedI32(i32);%0A++++%0A++++let+mut+data+=+AlignedI32(42);%0A++++let+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A++++%0A++++assert!(ptr.is_aligned_to(1));%0A++++assert!(ptr.is_aligned_to(2));%0A++++assert!(ptr.is_aligned_to(4));%0A++++%0A++++assert!(ptr.wrapping_byte_add(2).is_aligned_to(2));%0A++++assert!(!ptr.wrapping_byte_add(2).is_aligned_to(4));%0A++++%0A++++assert_ne!(ptr.is_aligned_to(8),+ptr.wrapping_add(1).is_aligned_to(8));%0A%7D&amp;version=nightly&amp;edition=2024\"></a></div></div></details></div></details>",0,"core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AtomicPrimitive-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/sync/atomic.rs.html#326\">Source</a><a href=\"#impl-AtomicPrimitive-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"core/sync/atomic/trait.AtomicPrimitive.html\" title=\"trait core::sync::atomic::AtomicPrimitive\">AtomicPrimitive</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.AtomicInner\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/sync/atomic.rs.html#326\">Source</a><a href=\"#associatedtype.AtomicInner\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/sync/atomic/trait.AtomicPrimitive.html#associatedtype.AtomicInner\" class=\"associatedtype\">AtomicInner</a> = <a class=\"struct\" href=\"core/sync/atomic/struct.AtomicPtr.html\" title=\"struct core::sync::atomic::AtomicPtr\">AtomicPtr</a>&lt;T&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>atomic_internals</code>)</span></div></span><div class='docblock'>Temporary implementation detail.</div></details></div></details>","AtomicPrimitive","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/142757\" title=\"Tracking issue for const_clone\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/clone.rs.html#664-669\">Source</a></span><a href=\"#impl-Clone-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/clone.rs.html#666-668\">Source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; Self</h4></section></summary><div class='docblock'>Returns a duplicate of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#245-250\">Source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: &amp;Self)<div class=\"where\">where\n    Self:,</div></h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/mod.rs.html#3064-3068\">Source</a></span><a href=\"#impl-Debug-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/mod.rs.html#3065-3067\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Default-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.88.0\">1.88.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2082-2087\">Source</a></span><a href=\"#impl-Default-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"traitalias\" href=\"core/ptr/traitalias.Thin.html\" title=\"traitalias core::ptr::Thin\">Thin</a>&gt; <a class=\"trait\" href=\"core/default/trait.Default.html\" title=\"trait core::default::Default\">Default</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.default\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2084-2086\">Source</a><a href=\"#method.default\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/default/trait.Default.html#tymethod.default\" class=\"fn\">default</a>() -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Returns the default value of <a href=\"core/ptr/fn.null_mut.html\" title=\"fn core::ptr::null_mut\"><code>null_mut()</code></a>.</p>\n</div></details></div></details>","Default","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#966-973\">Source</a></span><a href=\"#impl-Hash-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/hash/mod.rs.html#968-972\">Source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(&amp;self, state: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut H</a>)</h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#235-242\">Source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(data: &amp;[Self], state: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut H</a>)<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2029-2041\">Source</a></span><a href=\"#impl-Ord-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3><div class=\"docblock\"><p>Pointer comparison is by address, as produced by the <a href=\"core/primitive.pointer.html#method.addr\" title=\"method pointer::addr\"><code>&lt;*mut T&gt;::addr</code></a> method.</p>\n</div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2032-2040\">Source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1021-1026\">Source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"core/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1060-1065\">Source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"core/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1086-1098\">Source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"core/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2007-2013\">Source</a></span><a href=\"#impl-PartialEq-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3><div class=\"docblock\"><p>Pointer equality is by address, as produced by the <a href=\"core/primitive.pointer.html#method.addr\" title=\"method pointer::addr\"><code>&lt;*mut T&gt;::addr</code></a> method.</p>\n</div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2010-2012\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264-266\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2049-2079\">Source</a></span><a href=\"#impl-PartialOrd-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3><div class=\"docblock\"><p>Pointer comparison is by address, as produced by the <a href=\"core/primitive.pointer.html#method.addr\" title=\"method pointer::addr\"><code>&lt;*mut T&gt;::addr</code></a> method.</p>\n</div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2052-2054\">Source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2058-2060\">Source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2064-2066\">Source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the\n<code>&lt;=</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2070-2072\">Source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2076-2078\">Source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by\nthe <code>&gt;=</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Pointer-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/mod.rs.html#3035-3039\">Source</a></span><a href=\"#impl-Pointer-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/fmt/trait.Pointer.html\" title=\"trait core::fmt::Pointer\">Pointer</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/mod.rs.html#3036-3038\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Pointer.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Pointer.html#tymethod.fmt\">Read more</a></div></details></div></details>","Pointer","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdElement-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#1226-1231\">Source</a><a href=\"#impl-SimdElement-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"core/simd/trait.SimdElement.html\" title=\"trait core::simd::SimdElement\">SimdElement</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/ptr/trait.Pointee.html\" title=\"trait core::ptr::Pointee\">Pointee</a>&lt;Metadata = <a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#1230\">Source</a><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/simd/trait.SimdElement.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"primitive\" href=\"core/primitive.isize.html\">isize</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask element type corresponding to this element type.</div></details></div></details>","SimdElement","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-CoerceUnsized%3C*const+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#65\">Source</a><a href=\"#impl-CoerceUnsized%3C*const+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a> + <a class=\"trait\" href=\"core/marker/trait.Unsize.html\" title=\"trait core::marker::Unsize\">Unsize</a>&lt;U&gt;, U: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/ops/trait.CoerceUnsized.html\" title=\"trait core::ops::CoerceUnsized\">CoerceUnsized</a>&lt;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*const U</a>&gt; for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","CoerceUnsized<*const U>","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-CoerceUnsized%3C*mut+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#62\">Source</a><a href=\"#impl-CoerceUnsized%3C*mut+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a> + <a class=\"trait\" href=\"core/marker/trait.Unsize.html\" title=\"trait core::marker::Unsize\">Unsize</a>&lt;U&gt;, U: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/ops/trait.CoerceUnsized.html\" title=\"trait core::ops::CoerceUnsized\">CoerceUnsized</a>&lt;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a>&gt; for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","CoerceUnsized<*mut U>","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Copy-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#479-489\">Source</a></span><a href=\"#impl-Copy-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","Copy","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-DispatchFromDyn%3C*mut+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#134\">Source</a><a href=\"#impl-DispatchFromDyn%3C*mut+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a> + <a class=\"trait\" href=\"core/marker/trait.Unsize.html\" title=\"trait core::marker::Unsize\">Unsize</a>&lt;U&gt;, U: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/ops/trait.DispatchFromDyn.html\" title=\"trait core::ops::DispatchFromDyn\">DispatchFromDyn</a>&lt;<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut U</a>&gt; for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","DispatchFromDyn<*mut U>","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Eq-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2021\">Source</a></span><a href=\"#impl-Eq-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3><div class=\"docblock\"><p>Pointer equality is an equivalence relation.</p>\n</div></section>","Eq","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Freeze-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/marker.rs.html#918-926\">Source</a><a href=\"#impl-Freeze-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Freeze.html\" title=\"trait core::marker::Freeze\">Freeze</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","Freeze","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-PinCoerceUnsized-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.33.0\">1.33.0</span> · <a class=\"src\" href=\"src/core/pin.rs.html#1862\">Source</a></span><a href=\"#impl-PinCoerceUnsized-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>&gt; <a class=\"trait\" href=\"core/pin/trait.PinCoerceUnsized.html\" title=\"trait core::pin::PinCoerceUnsized\">PinCoerceUnsized</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","PinCoerceUnsized","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Send-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#102\">Source</a></span><a href=\"#impl-Send-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; !<a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","Send","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Sync-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#682\">Source</a></span><a href=\"#impl-Sync-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; !<a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","Sync","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-Unpin-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.38.0\">1.38.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#1044-1049\">Source</a></span><a href=\"#impl-Unpin-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.PointeeSized.html\" title=\"trait core::marker::PointeeSized\">PointeeSized</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Unpin.html\" title=\"trait core::marker::Unpin\">Unpin</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","Unpin","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-UnwindSafe-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0\">1.9.0</span> · <a class=\"src\" href=\"src/core/panic/unwind_safe.rs.html#187\">Source</a></span><a href=\"#impl-UnwindSafe-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/panic/trait.RefUnwindSafe.html\" title=\"trait core::panic::RefUnwindSafe\">RefUnwindSafe</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>&gt; <a class=\"trait\" href=\"core/panic/trait.UnwindSafe.html\" title=\"trait core::panic::UnwindSafe\">UnwindSafe</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","UnwindSafe","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"],["<section id=\"impl-VaArgSafe-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ffi/va_list.rs.html#238\">Source</a><a href=\"#impl-VaArgSafe-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"core/ffi/va_list/trait.VaArgSafe.html\" title=\"trait core::ffi::va_list::VaArgSafe\">VaArgSafe</a> for <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h3></section>","VaArgSafe","core::os::darwin::objc::Class","core::os::darwin::objc::SEL"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[157869]}