Boost.Core
==========

Boost.Core, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), is a collection of core utilities used by other Boost libraries.
The criteria for inclusion is that the utility component be:

* simple,
* used by other Boost libraries, and
* not dependent on any other Boost modules except Core itself, Config, Assert, Static Assert, or Predef.

### CI Status

Branch   | Travis | Appveyor
---------|--------|---------
Develop  | [![Build Status](https://travis-ci.org/boostorg/core.svg?branch=develop)](https://travis-ci.org/boostorg/core) | [![Build Status](https://ci.appveyor.com/api/projects/status/github/boostorg/core?branch=develop&svg=true)](https://ci.appveyor.com/project/pdimov/core)
Master   | [![Build Status](https://travis-ci.org/boostorg/core.svg?branch=master)](https://travis-ci.org/boostorg/core) | [![Build Status](https://ci.appveyor.com/api/projects/status/github/boostorg/core?branch=master&svg=true)](https://ci.appveyor.com/project/pdimov/core)

### Directories

* **doc** - Documentation of the components
* **include** - Interface headers
* **test** - Unit tests

### More information

* [Documentation](http://boost.org/libs/core)
* [Report bugs](https://svn.boost.org/trac/boost/newticket?component=core;version=Boost%20Release%20Branch). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### License

Distributed under the [Boost Software License, Version 1.0](http://boost.org/LICENSE_1_0.txt).
