; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define i32 @i8_i32(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: i8_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smov w0, v0.b[15]
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 16 x i8> %a, i32 15
  %conv = sext i8 %elt to i32
  ret i32 %conv
}

define i64 @i8_i64(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: i8_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smov x0, v0.b[15]
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 16 x i8> %a, i32 15
  %conv = sext i8 %elt to i64
  ret i64 %conv
}

define i32 @i16_i32(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: i16_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smov w0, v0.h[7]
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 8 x i16> %a, i32 7
  %conv = sext i16 %elt to i32
  ret i32 %conv
}

define i64 @i16_i64(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: i16_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smov x0, v0.h[7]
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 8 x i16> %a, i32 7
  %conv = sext i16 %elt to i64
  ret i64 %conv
}

define i64 @i32_i64(<vscale x 4 x i32> %a) #0 {
; CHECK-LABEL: i32_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    smov x0, v0.s[3]
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 4 x i32> %a, i32 3
  %conv = sext i32 %elt to i64
  ret i64 %conv
}

; NOTE: Testing out-of-range indices

define i32 @i8_i32_oor(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: i8_i32_oor:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, z0.b[16]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    sxtb w0, w8
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 16 x i8> %a, i32 16
  %conv = sext i8 %elt to i32
  ret i32 %conv
}

define i64 @i8_i64_oor(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: i8_i64_oor:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, z0.b[16]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    sxtb x0, w8
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 16 x i8> %a, i32 16
  %conv = sext i8 %elt to i64
  ret i64 %conv
}

define i32 @i16_i32_oor(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: i16_i32_oor:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, z0.h[8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    sxth w0, w8
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 8 x i16> %a, i32 8
  %conv = sext i16 %elt to i32
  ret i32 %conv
}

define i64 @i16_i64_oor(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: i16_i64_oor:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, z0.h[8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    sxth x0, w8
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 8 x i16> %a, i32 8
  %conv = sext i16 %elt to i64
  ret i64 %conv
}

define i64 @i32_i64_oor(<vscale x 4 x i32> %a) #0 {
; CHECK-LABEL: i32_i64_oor:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, z0.s[4]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    sxtw x0, w8
; CHECK-NEXT:    ret
entry:
  %elt = extractelement <vscale x 4 x i32> %a, i32 4
  %conv = sext i32 %elt to i64
  ret i64 %conv
}

attributes #0 = { "target-features"="+sve" }
