; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL %s

; Test splitting flat instruction offsets into the low and high bits
; when the offset doesn't fit in the offset field.

define i8 @flat_inst_valu_offset_1(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 1
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 1
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:2047
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:2047
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 2047
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_12bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_12bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 4095
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:8191
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8191
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_24bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_24bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7ff000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_24bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fffff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_24bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_24bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:8388607
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_24bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fffff, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_24bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fffff, v0
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8388607
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-2048
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -2048
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_12bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-4096
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -4096
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_13bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffe000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffe000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-8192
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -8192
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_24bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_24bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xff800000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_24bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff800000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_neg_24bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff800000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_neg_24bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-8388608
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -8388608
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}


define i8 @flat_inst_valu_offset_2x_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 4095
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_12bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:8191
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8191
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x3000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x3fff, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x3000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:16383
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, 0x3fff, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0x3fff, v0
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 16383
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_24bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfff000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4094
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffffe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4094
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:8388606
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffffe, v0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffffe, v0
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_2x_24bit_max:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffffe, v0
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 16777214
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-4096
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -4096
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_12bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffe000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffe000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-8192
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -8192
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_13bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffc000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffc000, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xffffc000, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-16384
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -16384
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_24bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_24bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xff000001, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_24bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff000001, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_inst_valu_offset_2x_neg_24bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff000001, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_2x_neg_24bit_max:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8388607
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_2x_neg_24bit_max:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, 0xff000001, v0
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -16777215
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits (1ull << 33) | 2047
define i8 @flat_inst_valu_offset_64bit_11bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2047
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2047
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x7ff
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x7ff
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x7ff
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x7ff
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589936639
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits (1ull << 33) | 2048
define i8 @flat_inst_valu_offset_64bit_11bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:2048
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2048
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2048
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x800
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x800
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x800
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x800
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589936640
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits (1ull << 33) | 4095
define i8 @flat_inst_valu_offset_64bit_12bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0xfff
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0xfff
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0xfff
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0xfff
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589938687
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits (1ull << 33) | 4096
define i8 @flat_inst_valu_offset_64bit_12bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4096
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x1000
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x1000
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x1000
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x1000
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589938688
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits (1ull << 33) | 8191
define i8 @flat_inst_valu_offset_64bit_13bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:8191
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x1fff
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x1fff
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x1fff
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x1fff
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589942783
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits (1ull << 33) | 8192
define i8 @flat_inst_valu_offset_64bit_13bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x2000, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x2000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:8192
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x2000
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x2000
; GFX10-GISEL-NEXT:    s_mov_b32 s5, 2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x2000
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x2000
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 8589942784
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2047
define i8 @flat_inst_valu_offset_64bit_11bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7ff, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8386561
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x7ff
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x7ff
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x7ff
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x7ff
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854773761
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2048
define i8 @flat_inst_valu_offset_64bit_11bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x800, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8386560
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x800
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x800
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x800
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x800
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854773760
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4095
define i8 @flat_inst_valu_offset_64bit_12bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfff, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8384513
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0xfff
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0xfff
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0xfff
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0xfff
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854771713
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4096
define i8 @flat_inst_valu_offset_64bit_12bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8384512
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x1000
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x1000
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x1000
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x1000
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854771712
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8191
define i8 @flat_inst_valu_offset_64bit_13bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8380417
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x1fff
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x1fff
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x1fff
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x1fff
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854767617
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8192
define i8 @flat_inst_valu_offset_64bit_13bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x2000, v0
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-SDAG-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x2000, v0
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, v0
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8380416
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_movk_i32 s4, 0x2000
; GFX9-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_movk_i32 s4, 0x2000
; GFX10-GISEL-NEXT:    s_brev_b32 s5, 1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_movk_i32 s0, 0x2000
; GFX11-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_movk_i32 s0, 0x2000
; GFX12-GISEL-NEXT:    s_brev_b32 s1, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1]
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, ptr %p, i64 -9223372036854767616
  %load = load i8, ptr %gep, align 4
  ret i8 %load
}

define amdgpu_kernel void @flat_inst_salu_offset_1(ptr %p) {
; GFX9-LABEL: flat_inst_salu_offset_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 1
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: flat_inst_salu_offset_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 1
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_salu_offset_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: flat_inst_salu_offset_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:2047 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:2047 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 2047
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_12bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_salu_offset_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: flat_inst_salu_offset_12bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 4095
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x1000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:8191 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8191
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_11bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff800
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xfffff800, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-2048 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff800
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff800
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -2048
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_12bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xfffff000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-4096 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -4096
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xffffe000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-8192 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -8192
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_11bit_max(ptr %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 4095
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_12bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x1000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:8191 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8191
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x3000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x3fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x3000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:16383 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x3fff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x3fff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 16383
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_11bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xfffff000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-4096 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -4096
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_12bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xffffe000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-8192 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -8192
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_13bit_max(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffc000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffc000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0xffffc000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, -1, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_u8 v0, v[0:1] offset:-16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffc000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xffffc000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -16384
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 11-bit low-bits (1ull << 33) | 2047
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2047 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2047 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x7ff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589936639
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 11-bit low-bits (1ull << 33) | 2048
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:2048 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x800
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2048 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:2048 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x800
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x800
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x800
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589936640
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 12-bit low-bits (1ull << 33) | 4095
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0xfff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589938687
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 12-bit low-bits (1ull << 33) | 4096
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x1000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4096 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x1000
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589938688
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 13-bit low-bits (1ull << 33) | 8191
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095 glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x1000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:4095 glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:8191 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x1fff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589942783
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 13-bit low-bits (1ull << 33) | 8192
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, s0, 0x2000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, 0, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, 2, s1, s0
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:8192 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x2000
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 8589942784
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2047
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7ff, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7ff, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8386561 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x7ff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854773761
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2048
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x800, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x800
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8386560 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x800
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x800
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x800
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854773760
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4095
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfff, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfff, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8384513 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0xfff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854771713
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4096
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8384512 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x1000
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854771712
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8191
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_neg_high_split0(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x1fff, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8380417 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x1fff
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854767617
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8192
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_neg_high_split1(ptr %p) {
; GFX9-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-SDAG-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-SDAG-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-SDAG-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-SDAG-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    flat_store_byte v[0:1], v0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1] glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x2000, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX11-SDAG-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, 0x800000, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX12-SDAG-NEXT:    flat_load_u8 v0, v[0:1] offset:-8380416 scope:SCOPE_SYS
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    flat_load_ubyte v0, v[0:1] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    flat_store_byte v[0:1], v0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX11-GISEL-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    flat_load_u8 v0, v[0:1] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_u32 s0, s0, 0x2000
; GFX12-GISEL-NEXT:    s_add_co_ci_u32 s1, s1, 0x80000000
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    flat_load_u8 v0, v[0:1] scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b8 v[0:1], v0
; GFX12-GISEL-NEXT:    s_endpgm
  %gep = getelementptr i8, ptr %p, i64 -9223372036854767616
  %load = load volatile i8, ptr %gep, align 1
  store i8 %load, ptr undef
  ret void
}
