; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck %s

; Check for optimizing the passed implicit workitem ID based on the
; required group size. This should avoid a few bit packing operations.

declare hidden void @callee() #0

define amdgpu_kernel void @known_x_0(ptr addrspace(1) %out) !reqd_work_group_size !0 {
; CHECK-LABEL: known_x_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    v_lshlrev_b32_e32 v0, 20, v2
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_lshl_or_b32 v31, v1, 10, v0
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 2

define amdgpu_kernel void @known_y_0(ptr addrspace(1) %out) !reqd_work_group_size !1 {
; CHECK-LABEL: known_y_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_lshl_or_b32 v31, v2, 20, v0
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 2

define amdgpu_kernel void @known_z_0(ptr addrspace(1) %out) !reqd_work_group_size !2 {
; CHECK-LABEL: known_z_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_lshl_or_b32 v31, v1, 10, v0
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 1

define amdgpu_kernel void @known_yz_0(ptr addrspace(1) %out) !reqd_work_group_size !3 {
; CHECK-LABEL: known_yz_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_mov_b32_e32 v31, v0
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 0

define amdgpu_kernel void @known_xz_0(ptr addrspace(1) %out) !reqd_work_group_size !4 {
; CHECK-LABEL: known_xz_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_lshlrev_b32_e32 v31, 10, v1
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 1


define amdgpu_kernel void @known_xyz_0(ptr addrspace(1) %out) !reqd_work_group_size !5 {
; CHECK-LABEL: known_xyz_0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_add_u32 flat_scratch_lo, s10, s15
; CHECK-NEXT:    s_addc_u32 flat_scratch_hi, s11, 0
; CHECK-NEXT:    s_add_u32 s0, s0, s15
; CHECK-NEXT:    s_addc_u32 s1, s1, 0
; CHECK-NEXT:    v_mov_b32_e32 v31, 0
; CHECK-NEXT:    s_mov_b32 s32, 0
; CHECK-NEXT:    s_getpc_b64 s[4:5]
; CHECK-NEXT:    s_add_u32 s4, s4, callee@rel32@lo+4
; CHECK-NEXT:    s_addc_u32 s5, s5, callee@rel32@hi+12
; CHECK-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; CHECK-NEXT:    s_endpgm
  call void @callee()
  ret void
}
; CHECK: .amdhsa_system_vgpr_workitem_id 0

attributes #0 = { "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-implicitarg-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-queue-ptr" "amdgpu-no-workgroup-id-x" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" }

!0 = !{i32 1, i32 64, i32 64}
!1 = !{i32 64, i32 1, i32 64}
!2 = !{i32 64, i32 64, i32 1}
!3 = !{i32 64, i32 1, i32 1}
!4 = !{i32 1, i32 64, i32 1}
!5 = !{i32 1, i32 1, i32 1}
