/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final List<Appender<E>> appenderList = new ArrayList<Appender<E>>();

    @Override
    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Cannot null as an appener");
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.add(newAppender);
        }
    }

    public int appendLoopOnAppenders(E e) {
        int size = 0;
        size = this.appenderList.size();
        int i = 0;
        while (i < size) {
            Appender<E> appender = this.appenderList.get(i);
            appender.doAppend(e);
            ++i;
        }
        return size;
    }

    @Override
    public Iterator iteratorForAppenders() {
        return this.appenderList.iterator();
    }

    @Override
    public Appender<E> getAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        int i = 0;
        while (i < size) {
            Appender<E> appender = this.appenderList.get(i);
            if (name.equals(appender.getName())) {
                return appender;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        int size = this.appenderList.size();
        int i = 0;
        while (i < size) {
            Appender<E> a = this.appenderList.get(i);
            if (a == appender) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void detachAndStopAllAppenders() {
        int len = this.appenderList.size();
        int i = 0;
        while (i < len) {
            Appender<E> a = this.appenderList.get(i);
            a.stop();
            ++i;
        }
        this.appenderList.clear();
    }

    @Override
    public boolean detachAppender(Appender appender) {
        if (appender == null) {
            return false;
        }
        return this.appenderList.remove(appender);
    }

    @Override
    public Appender<E> detachAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        int i = 0;
        while (i < size) {
            if (name.equals(this.appenderList.get(i).getName())) {
                return this.appenderList.remove(i);
            }
            ++i;
        }
        return null;
    }
}

