/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.util.ReflectHelper;

public abstract class EntityType
extends AbstractType {
    private final Class persistentClass;
    private final boolean niceEquals;

    public final boolean isEntityType() {
        return true;
    }

    public final Class getPersistentClass() {
        return this.persistentClass;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    protected EntityType(Class persistentClass) {
        this.persistentClass = persistentClass;
        this.niceEquals = !ReflectHelper.overridesEquals(persistentClass);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public final Class getReturnedClass() {
        return this.persistentClass;
    }

    protected final Serializable getIdentifier(Object value, SessionImplementor session) throws HibernateException {
        return session.getEntityIdentifierIfNotUnsaved(value);
    }

    public String toXML(Object value, SessionFactoryImplementor factory) throws HibernateException {
        ClassPersister persister = factory.getPersister(this.persistentClass);
        return value == null ? null : persister.getIdentifierType().toXML(persister.getIdentifier(value), factory);
    }

    public String getName() {
        return this.persistentClass.getName();
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public abstract boolean isOneToOne();

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getEntityIdentifier(value);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id");
        }
        return id;
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolveIdentifier(oid, session, owner);
    }

    public boolean hasNiceEquals() {
        return this.niceEquals;
    }

    public boolean isAssociationType() {
        return true;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, names, session, owner), session, owner);
    }

    public abstract Object hydrate(ResultSet var1, String[] var2, SessionImplementor var3, Object var4) throws HibernateException, SQLException;

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (this.equals(old, current)) {
            return false;
        }
        Serializable oldid = this.getIdentifier(old, session);
        Serializable newid = this.getIdentifier(current, session);
        return !session.getFactory().getIdentifierType(this.persistentClass).equals(oldid, newid);
    }
}

