/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PoolConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class C3P0ConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private Integer isolation;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$C3P0ConnectionProvider == null ? (class$net$sf$hibernate$connection$C3P0ConnectionProvider = C3P0ConnectionProvider.class$("net.sf.hibernate.connection.C3P0ConnectionProvider")) : class$net$sf$hibernate$connection$C3P0ConnectionProvider));
    static /* synthetic */ Class class$net$sf$hibernate$connection$C3P0ConnectionProvider;

    public Connection getConnection() throws SQLException {
        try {
            Connection c = this.ds.getConnection();
            if (this.isolation != null) {
                c.setTransactionIsolation(this.isolation);
            }
            c.setAutoCommit(false);
            return c;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public boolean isStatementCache() {
        return true;
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
        log.info((Object)("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + connectionProps));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
        }
        try {
            int minPoolSize = PropertiesHelper.getInt("hibernate.c3p0.min_size", props, 1);
            int maxPoolSize = PropertiesHelper.getInt("hibernate.c3p0.max_size", props, 100);
            int maxIdleTime = PropertiesHelper.getInt("hibernate.c3p0.timeout", props, 0);
            int maxStatements = PropertiesHelper.getInt("hibernate.c3p0.max_statements", props, 0);
            boolean validateConnection = PropertiesHelper.getBoolean("hibernate.c3p0.validate", props);
            PoolConfig pcfg = new PoolConfig();
            pcfg.setMinPoolSize(minPoolSize);
            pcfg.setMaxPoolSize(maxPoolSize);
            pcfg.setAcquireIncrement(1);
            pcfg.setMaxIdleTime(maxIdleTime);
            pcfg.setMaxStatements(maxStatements);
            pcfg.setTestConnectionOnCheckout(validateConnection);
            DataSource unpooled = DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps);
            this.ds = DataSources.pooledDataSource((DataSource)unpooled, (PoolConfig)pcfg);
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate C3P0 connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate C3P0 connection pool", e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

