/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public class ObjectType
extends AbstractType
implements AbstractComponentType,
AssociationType {
    private final Type identifierType;
    private final Type metaType;
    private static final String[] PROPERTY_NAMES = new String[]{"class", "id"};
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectType(Type metaType, Type identifierType) {
        this.identifierType = identifierType;
        this.metaType = metaType;
    }

    public ObjectType() {
        this(Hibernate.CLASS, Hibernate.SERIALIZABLE);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return 2;
    }

    public String getName() {
        return "object";
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("object is a multicolumn type");
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Class clazz = (Class)this.metaType.nullSafeGet(rs, names[0], session, owner);
        Serializable id = (Serializable)this.identifierType.nullSafeGet(rs, names[1], session, owner);
        if (clazz == null || id == null) {
            return null;
        }
        return session.load(clazz, id);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        Class<?> clazz;
        Serializable id;
        if (value == null) {
            id = null;
            clazz = null;
        } else {
            id = session.getEntityIdentifierIfNotUnsaved(value);
            clazz = value.getClass();
        }
        this.metaType.nullSafeSet(st, clazz, index, session);
        this.identifierType.nullSafeSet(st, id, index + 1, session);
    }

    public Class getReturnedClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = ObjectType.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return ArrayHelper.join(this.metaType.sqlTypes(mapping), this.identifierType.sqlTypes(mapping));
    }

    public String toXML(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return Hibernate.entity(value.getClass()).toXML(value, factory);
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        ObjectTypeCacheEntry e = (ObjectTypeCacheEntry)cached;
        return cached == null ? null : session.load(e.clazz, e.id);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : new ObjectTypeCacheEntry(value.getClass(), session.getEntityIdentifier(value));
    }

    public boolean isObjectType() {
        return true;
    }

    public Cascades.CascadeStyle cascade(int i) {
        return Cascades.STYLE_NONE;
    }

    public int enableJoinedFetch(int i) {
        return -1;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return i == 0 ? component.getClass() : this.id(component, session);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return new Object[]{component.getClass(), this.id(component, session)};
    }

    private Serializable id(Object component, SessionImplementor session) throws HibernateException {
        try {
            return session.getEntityIdentifierIfNotUnsaved(component);
        }
        catch (TransientObjectException toe) {
            return null;
        }
    }

    public Type[] getSubtypes() {
        return new Type[]{this.metaType, this.identifierType};
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public boolean isComponentType() {
        return true;
    }

    public AssociationType.ForeignKeyType getForeignKeyType() {
        return AssociationType.FOREIGN_KEY_FROM_PARENT;
    }

    public boolean isAssociationType() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ObjectTypeCacheEntry
    implements Serializable {
        Class clazz;
        Serializable id;

        ObjectTypeCacheEntry(Class clazz, Serializable id) {
            this.clazz = clazz;
            this.id = id;
        }
    }
}

