#include <iostream>
#include <boost/test/unit_test.hpp>
#include <set>

#include <zypp-core/Url.h>
#include <zypp/PathInfo.h>
#include <zypp-core/base/Easy.h>
#include <zypp-media/auth/AuthData>

#include <zypp-media/auth/CredentialFileReader>

using std::cout;
using std::endl;
using namespace zypp;
using namespace zypp::media;

typedef std::set<AuthData_Ptr> CredentialSet;

struct CredCollector
{
  bool collect(AuthData_Ptr & cred)
  {
    cout << "got: " << endl << *cred << endl;
    creds.insert(cred);
    return true;
  }

  CredentialSet creds;
};

BOOST_AUTO_TEST_CASE(read_cred)
{
  CredCollector collector;
  Pathname credfile = TESTS_SRC_DIR "/media/data/credentials.cat";
  CredentialFileReader reader(credfile,
      bind( &CredCollector::collect, &collector, _1 ));

  BOOST_CHECK_EQUAL(collector.creds.size(), 3);
}
